/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.chunk;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.LevelResource;

public class BroomChunkTicketManager {
    private static final TicketType<ChunkPos> BROOM_WEAK_LOADING_TICKET = TicketType.create((String)"ashenwitchbroom_command_weak", (a, b) -> Long.compare(a.toLong(), b.toLong()), (int)0);
    private static final TicketType<ChunkPos> BROOM_STRONG_LOADING_TICKET = TicketType.create((String)"ashenwitchbroom_command_strong", (a, b) -> Long.compare(a.toLong(), b.toLong()), (int)0);
    private static final Map<String, Map<ChunkPos, Boolean>> loadedChunks = new ConcurrentHashMap<String, Map<ChunkPos, Boolean>>();
    private static final ScheduledExecutorService chunkCheckExecutor = Executors.newScheduledThreadPool(2, r -> {
        Thread t = new Thread(r, "BroomChunkTicketManager-AsyncChecker");
        t.setDaemon(true);
        return t;
    });
    private static BroomChunkTicketManager instance;
    private static final String CHUNKS_DATA_FOLDER = "ashenwitchbroom";
    private static final String CHUNKS_SUBFOLDER = "chunks";
    private static final String WEAK_CHUNKS_DATA_FILE = "weak_loaded_chunks.dat";
    private static final String STRONG_CHUNKS_DATA_FILE = "strong_loaded_chunks.dat";
    private MinecraftServer server;

    public static BroomChunkTicketManager getInstance() {
        if (instance == null) {
            instance = new BroomChunkTicketManager();
        }
        return instance;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        this.loadChunkDataFromFile();
    }

    public ChunkAddResult addLazyLoadedChunk(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Boolean existingType = this.getChunkLoadType(level, chunkX, chunkZ);
        if (existingType != null) {
            if (!existingType.booleanValue()) {
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u7ecf\u662f\u5f31\u52a0\u8f7d\u72b6\u6001", chunkX, chunkZ, dimensionKey);
                return ChunkAddResult.ALREADY_EXISTS_SAME_TYPE;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u7ecf\u662f\u5f3a\u52a0\u8f7d\u72b6\u6001\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e3a\u5f31\u52a0\u8f7d", chunkX, chunkZ, dimensionKey);
            return ChunkAddResult.ALREADY_EXISTS_DIFFERENT_TYPE;
        }
        try {
            level.getChunkSource().addRegionTicket(BROOM_WEAK_LOADING_TICKET, chunkPos, 0, (Object)chunkPos);
            loadedChunks.computeIfAbsent(dimensionKey, k -> new ConcurrentHashMap()).put(chunkPos, false);
            this.saveChunkDataToFile();
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u6210\u529f\u6dfb\u52a0\u5f31\u52a0\u8f7d\u533a\u5757\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}", chunkX, chunkZ, dimensionKey);
            return ChunkAddResult.SUCCESS;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6dfb\u52a0\u5f31\u52a0\u8f7d\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", chunkX, chunkZ, dimensionKey, e.getMessage());
            return ChunkAddResult.FAILED;
        }
    }

    public ChunkAddResult addTickingLoadedChunk(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Boolean existingType = this.getChunkLoadType(level, chunkX, chunkZ);
        if (existingType != null) {
            if (existingType.booleanValue()) {
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u7ecf\u662f\u5f3a\u52a0\u8f7d\u72b6\u6001", chunkX, chunkZ, dimensionKey);
                return ChunkAddResult.ALREADY_EXISTS_SAME_TYPE;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u7ecf\u662f\u5f31\u52a0\u8f7d\u72b6\u6001\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e3a\u5f3a\u52a0\u8f7d", chunkX, chunkZ, dimensionKey);
            return ChunkAddResult.ALREADY_EXISTS_DIFFERENT_TYPE;
        }
        try {
            level.getChunkSource().addRegionTicket(BROOM_STRONG_LOADING_TICKET, chunkPos, 2, (Object)chunkPos);
            loadedChunks.computeIfAbsent(dimensionKey, k -> new ConcurrentHashMap()).put(chunkPos, true);
            this.saveChunkDataToFile();
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u6210\u529f\u6dfb\u52a0\u5f3a\u52a0\u8f7d\u533a\u5757\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff0c\u534a\u5f84\u4e3a2", chunkX, chunkZ, dimensionKey);
            return ChunkAddResult.SUCCESS;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6dfb\u52a0\u5f3a\u52a0\u8f7d\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", chunkX, chunkZ, dimensionKey, e.getMessage());
            return ChunkAddResult.FAILED;
        }
    }

    public boolean removeLoadedChunk(ServerLevel level, int chunkX, int chunkZ, Boolean loadType) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Map<ChunkPos, Boolean> dimensionChunks = loadedChunks.get(dimensionKey);
        if (dimensionChunks == null || !dimensionChunks.containsKey(chunkPos)) {
            return false;
        }
        boolean isStrongLoaded = loadType != null ? loadType : dimensionChunks.get(chunkPos);
        try {
            if (isStrongLoaded) {
                level.getChunkSource().removeRegionTicket(BROOM_STRONG_LOADING_TICKET, chunkPos, 2, (Object)chunkPos);
            } else {
                level.getChunkSource().removeRegionTicket(BROOM_WEAK_LOADING_TICKET, chunkPos, 0, (Object)chunkPos);
            }
            dimensionChunks.remove(chunkPos);
            if (dimensionChunks.isEmpty()) {
                loadedChunks.remove(dimensionKey);
            }
            this.saveChunkDataToFile();
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u6210\u529f\u79fb\u9664{}\u533a\u5757\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}", isStrongLoaded ? "\u5f3a\u52a0\u8f7d" : "\u5f31\u52a0\u8f7d", chunkX, chunkZ, dimensionKey);
            return true;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u79fb\u9664{}\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", isStrongLoaded ? "\u5f3a\u52a0\u8f7d" : "\u5f31\u52a0\u8f7d", chunkX, chunkZ, dimensionKey, e.getMessage());
            return false;
        }
    }

    public BatchOperationResult addLazyLoadedChunksBatch(ServerLevel level, List<ChunkPos> chunks) {
        ArrayList<ChunkPos> successChunks = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> failureChunks = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> alreadyExistsSameType = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> alreadyExistsDifferentType = new ArrayList<ChunkPos>();
        for (ChunkPos chunkPos : chunks) {
            ChunkAddResult result = this.addLazyLoadedChunk(level, chunkPos.x, chunkPos.z);
            switch (result.ordinal()) {
                case 0: {
                    successChunks.add(chunkPos);
                    break;
                }
                case 1: {
                    alreadyExistsSameType.add(chunkPos);
                    break;
                }
                case 2: {
                    alreadyExistsDifferentType.add(chunkPos);
                    break;
                }
                case 3: {
                    failureChunks.add(chunkPos);
                }
            }
        }
        return new BatchOperationResult(successChunks.size(), failureChunks.size(), successChunks, failureChunks, alreadyExistsSameType, alreadyExistsDifferentType);
    }

    public BatchOperationResult addTickingLoadedChunksBatch(ServerLevel level, List<ChunkPos> chunks) {
        ArrayList<ChunkPos> successChunks = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> failureChunks = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> alreadyExistsSameType = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> alreadyExistsDifferentType = new ArrayList<ChunkPos>();
        for (ChunkPos chunkPos : chunks) {
            ChunkAddResult result = this.addTickingLoadedChunk(level, chunkPos.x, chunkPos.z);
            switch (result.ordinal()) {
                case 0: {
                    successChunks.add(chunkPos);
                    break;
                }
                case 1: {
                    alreadyExistsSameType.add(chunkPos);
                    break;
                }
                case 2: {
                    alreadyExistsDifferentType.add(chunkPos);
                    break;
                }
                case 3: {
                    failureChunks.add(chunkPos);
                }
            }
        }
        return new BatchOperationResult(successChunks.size(), failureChunks.size(), successChunks, failureChunks, alreadyExistsSameType, alreadyExistsDifferentType);
    }

    public BatchOperationResult removeLoadedChunksBatch(ServerLevel level, List<ChunkPos> chunks, Boolean loadType) {
        ArrayList<ChunkPos> successChunks = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> failureChunks = new ArrayList<ChunkPos>();
        String dimensionKey = level.dimension().location().toString();
        Map<ChunkPos, Boolean> dimensionChunks = loadedChunks.get(dimensionKey);
        if (dimensionChunks == null) {
            return new BatchOperationResult(0, chunks.size(), successChunks, new ArrayList<ChunkPos>(chunks));
        }
        for (ChunkPos chunkPos : chunks) {
            if (!dimensionChunks.containsKey(chunkPos)) {
                failureChunks.add(chunkPos);
                continue;
            }
            boolean isStrongLoaded = loadType != null ? loadType : dimensionChunks.get(chunkPos);
            try {
                if (isStrongLoaded) {
                    level.getChunkSource().removeRegionTicket(BROOM_STRONG_LOADING_TICKET, chunkPos, 2, (Object)chunkPos);
                } else {
                    level.getChunkSource().removeRegionTicket(BROOM_WEAK_LOADING_TICKET, chunkPos, 0, (Object)chunkPos);
                }
                dimensionChunks.remove(chunkPos);
                successChunks.add(chunkPos);
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u6210\u529f\u79fb\u9664{}\u533a\u5757\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}", isStrongLoaded ? "\u5f3a\u52a0\u8f7d" : "\u5f31\u52a0\u8f7d", chunkPos.x, chunkPos.z, dimensionKey);
            }
            catch (Exception e) {
                failureChunks.add(chunkPos);
                AshenWitchBroom.WRAPPED_LOGGER.error("\u79fb\u9664{}\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", isStrongLoaded ? "\u5f3a\u52a0\u8f7d" : "\u5f31\u52a0\u8f7d", chunkPos.x, chunkPos.z, dimensionKey, e.getMessage());
            }
        }
        if (dimensionChunks.isEmpty()) {
            loadedChunks.remove(dimensionKey);
        }
        if (!successChunks.isEmpty()) {
            this.saveChunkDataToFile();
        }
        return new BatchOperationResult(successChunks.size(), failureChunks.size(), successChunks, failureChunks);
    }

    public static List<ChunkPos> parseCoordinates(String coordStr) {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        try {
            String[] parts = coordStr.trim().split("\\s+");
            if (parts.length == 1) {
                String[] coords = parts[0].split(",");
                if (coords.length == 2) {
                    int x = Integer.parseInt(coords[0].trim());
                    int z = Integer.parseInt(coords[1].trim());
                    chunks.add(new ChunkPos(x, z));
                }
            } else if (parts.length == 2) {
                String[] coords1 = parts[0].split(",");
                String[] coords2 = parts[1].split(",");
                if (coords1.length == 2 && coords2.length == 2) {
                    int x1 = Integer.parseInt(coords1[0].trim());
                    int z1 = Integer.parseInt(coords1[1].trim());
                    int x2 = Integer.parseInt(coords2[0].trim());
                    int z2 = Integer.parseInt(coords2[1].trim());
                    int minX = Math.min(x1, x2);
                    int maxX = Math.max(x1, x2);
                    int minZ = Math.min(z1, z2);
                    int maxZ = Math.max(z1, z2);
                    for (int x = minX; x <= maxX; ++x) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            chunks.add(new ChunkPos(x, z));
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u89e3\u6790\u5750\u6807\u5931\u8d25\uff1a{}", coordStr, e);
        }
        return chunks;
    }

    public static List<ChunkPos> parseCoordinateArgs(int[] args) {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        if (args.length == 2) {
            int x = args[0];
            int z = args[1];
            chunks.add(new ChunkPos(x, z));
        } else if (args.length == 4) {
            int x = args[0];
            int z = args[1];
            int w = args[2];
            int h = args[3];
            for (int dx = 0; dx < w; ++dx) {
                for (int dz = 0; dz < h; ++dz) {
                    chunks.add(new ChunkPos(x + dx, z + dz));
                }
            }
        } else {
            throw new IllegalArgumentException("\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a2\u4e2a\uff08x y\uff09\u62164\u4e2a\uff08x y w h\uff09\uff0c\u5b9e\u9645\u4e3a\uff1a" + args.length);
        }
        return chunks;
    }

    public Boolean getChunkLoadType(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Map<ChunkPos, Boolean> dimensionChunks = loadedChunks.get(dimensionKey);
        if (dimensionChunks != null && dimensionChunks.containsKey(chunkPos)) {
            return dimensionChunks.get(chunkPos);
        }
        return null;
    }

    public boolean isChunkLoadedByManager(ServerLevel level, int chunkX, int chunkZ) {
        return this.getChunkLoadType(level, chunkX, chunkZ) != null;
    }

    public Map<ChunkPos, Boolean> getLoadedChunksInDimension(ServerLevel level) {
        String dimensionKey = level.dimension().location().toString();
        return loadedChunks.getOrDefault(dimensionKey, new ConcurrentHashMap());
    }

    public Set<ChunkPos> getLoadedChunksByType(ServerLevel level, boolean loadType) {
        Map<ChunkPos, Boolean> allChunks = this.getLoadedChunksInDimension(level);
        HashSet<ChunkPos> result = new HashSet<ChunkPos>();
        for (Map.Entry<ChunkPos, Boolean> entry : allChunks.entrySet()) {
            if (entry.getValue() != loadType) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public boolean hasChunk(ServerLevel level, int chunkX, int chunkZ) {
        try {
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            boolean isEntityTicking = level.areEntitiesLoaded(chunkPos.toLong());
            return isEntityTicking;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u68c0\u67e5\u5931\u8d25: {}", chunkX, chunkZ, level.dimension().location().toString(), e.getMessage());
            return false;
        }
    }

    public CompletableFuture<Boolean> waitForChunkLoadedAsync(ServerLevel level, int chunkX, int chunkZ, Consumer<Boolean> onChunkLoaded, int timeoutSeconds) {
        return CompletableFuture.supplyAsync(() -> {
            String dimensionKey = level.dimension().location().toString();
            long startTime = System.currentTimeMillis();
            long timeoutMs = (long)timeoutSeconds * 1000L;
            int checkCount = 0;
            try {
                while (System.currentTimeMillis() - startTime < timeoutMs) {
                    ++checkCount;
                    if (this.hasChunk(level, chunkX, chunkZ)) {
                        long elapsedTime = System.currentTimeMillis() - startTime;
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757\u52a0\u8f7d\u5b8c\u6210: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u8017\u65f6: {}ms, \u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, elapsedTime, checkCount);
                        return true;
                    }
                    Thread.sleep(50L);
                }
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u533a\u5757\u52a0\u8f7d\u8d85\u65f6: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u8d85\u65f6\u65f6\u95f4: {}\u79d2, \u603b\u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, timeoutSeconds, checkCount);
                return false;
            }
            catch (InterruptedException e) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u533a\u5757\u52a0\u8f7d\u7b49\u5f85\u88ab\u4e2d\u65ad: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, checkCount);
                Thread.currentThread().interrupt();
                return false;
            }
        }, chunkCheckExecutor).whenComplete((result, throwable) -> level.getServer().execute(() -> {
            if (throwable != null) {
                AshenWitchBroom.WRAPPED_LOGGER.error("\u5f02\u6b65\u533a\u5757\u52a0\u8f7d\u68c0\u6d4b\u51fa\u9519: ({}, {}) \u5728\u7ef4\u5ea6 {}: {}", chunkX, chunkZ, level.dimension().location().toString(), throwable.getMessage());
                onChunkLoaded.accept(false);
            } else {
                onChunkLoaded.accept((Boolean)result);
            }
        }));
    }

    public void clearAllLoadedChunks() {
        loadedChunks.clear();
        AshenWitchBroom.WRAPPED_LOGGER.debug("\u5df2\u6e05\u9664BroomChunkTicketManager\u4e2d\u7684\u6240\u6709\u52a0\u8f7d\u533a\u5757");
    }

    public void shutdown() {
        AshenWitchBroom.WRAPPED_LOGGER.info("\u6b63\u5728\u4fdd\u5b58\u533a\u5757\u6570\u636e...");
        this.saveChunkDataToFile();
        chunkCheckExecutor.shutdown();
        try {
            if (!chunkCheckExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                chunkCheckExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            chunkCheckExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomChunkTicketManager\u6267\u884c\u5668\u5173\u95ed\u5b8c\u6210");
    }

    public Map<String, Map<ChunkPos, Boolean>> getAllLoadedChunks() {
        return new ConcurrentHashMap<String, Map<ChunkPos, Boolean>>(loadedChunks);
    }

    public int[] getStatistics(ServerLevel level) {
        Map<ChunkPos, Boolean> chunks = this.getLoadedChunksInDimension(level);
        int total = chunks.size();
        int strongCount = 0;
        int weakCount = 0;
        for (Boolean isStrong : chunks.values()) {
            if (isStrong.booleanValue()) {
                ++strongCount;
                continue;
            }
            ++weakCount;
        }
        return new int[]{total, strongCount, weakCount};
    }

    private Path getWeakChunkDataPath() {
        return this.getChunkDataPath(WEAK_CHUNKS_DATA_FILE);
    }

    private Path getStrongChunkDataPath() {
        return this.getChunkDataPath(STRONG_CHUNKS_DATA_FILE);
    }

    private Path getChunkDataPath(String fileName) {
        if (this.server == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u670d\u52a1\u5668\u5b9e\u4f8b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5b58\u6863\u8def\u5f84");
            return null;
        }
        Path worldPath = this.server.getWorldPath(LevelResource.ROOT);
        Path dataFolder = worldPath.resolve(CHUNKS_DATA_FOLDER);
        Path chunksFolder = dataFolder.resolve(CHUNKS_SUBFOLDER);
        try {
            Files.createDirectories(chunksFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u521b\u5efa\u533a\u5757\u6570\u636e\u76ee\u5f55\u5931\u8d25: {}", e.getMessage());
            return null;
        }
        return chunksFolder.resolve(fileName);
    }

    public void saveChunkDataToFile() {
        this.saveWeakChunkDataToFile();
        this.saveStrongChunkDataToFile();
    }

    private void saveWeakChunkDataToFile() {
        Path dataPath = this.getWeakChunkDataPath();
        if (dataPath == null) {
            return;
        }
        this.saveChunkDataToFile(dataPath, false, "\u5f31\u52a0\u8f7d");
    }

    private void saveStrongChunkDataToFile() {
        Path dataPath = this.getStrongChunkDataPath();
        if (dataPath == null) {
            return;
        }
        this.saveChunkDataToFile(dataPath, true, "\u5f3a\u52a0\u8f7d");
    }

    private void saveChunkDataToFile(Path dataPath, boolean isStrong, String typeName) {
        try {
            CompoundTag rootTag = new CompoundTag();
            CompoundTag dimensionsTag = new CompoundTag();
            for (Map.Entry<String, Map<ChunkPos, Boolean>> dimensionEntry : loadedChunks.entrySet()) {
                String dimensionId = dimensionEntry.getKey();
                Map<ChunkPos, Boolean> chunks = dimensionEntry.getValue();
                ListTag chunksList = new ListTag();
                for (Map.Entry<ChunkPos, Boolean> chunkEntry : chunks.entrySet()) {
                    ChunkPos pos = chunkEntry.getKey();
                    Boolean chunkIsStrong = chunkEntry.getValue();
                    if (!chunkIsStrong.equals(isStrong)) continue;
                    CompoundTag chunkTag = new CompoundTag();
                    chunkTag.putInt("x", pos.x);
                    chunkTag.putInt("z", pos.z);
                    chunksList.add((Object)chunkTag);
                }
                if (chunksList.isEmpty()) continue;
                dimensionsTag.put(dimensionId, (Tag)chunksList);
            }
            rootTag.put("dimensions", (Tag)dimensionsTag);
            rootTag.putString("version", "1.0");
            rootTag.putString("type", isStrong ? "strong" : "weak");
            rootTag.putLong("saveTime", System.currentTimeMillis());
            NbtIo.writeCompressed((CompoundTag)rootTag, (Path)dataPath);
            AshenWitchBroom.WRAPPED_LOGGER.debug("{}\u533a\u5757\u6570\u636e\u5df2\u4fdd\u5b58\u5230: {}", typeName, dataPath);
        }
        catch (IOException e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u4fdd\u5b58{}\u533a\u5757\u6570\u636e\u5931\u8d25: {}", typeName, e.getMessage());
        }
    }

    public void loadChunkDataFromFile() {
        loadedChunks.clear();
        int weakCount = this.loadWeakChunkDataFromFile();
        int strongCount = this.loadStrongChunkDataFromFile();
        int totalCount = weakCount + strongCount;
        AshenWitchBroom.WRAPPED_LOGGER.info("\u4ece\u6587\u4ef6\u52a0\u8f7d\u4e86 {} \u4e2a\u533a\u5757\u6570\u636e\uff08\u5f31\u52a0\u8f7d: {}, \u5f3a\u52a0\u8f7d: {}\uff09", totalCount, weakCount, strongCount);
        if (totalCount > 0) {
            this.reapplyChunkTickets();
        }
    }

    private int loadWeakChunkDataFromFile() {
        Path dataPath = this.getWeakChunkDataPath();
        return this.loadChunkDataFromFile(dataPath, false, "\u5f31\u52a0\u8f7d");
    }

    private int loadStrongChunkDataFromFile() {
        Path dataPath = this.getStrongChunkDataPath();
        return this.loadChunkDataFromFile(dataPath, true, "\u5f3a\u52a0\u8f7d");
    }

    private int loadChunkDataFromFile(Path dataPath, boolean isStrong, String typeName) {
        if (dataPath == null || !Files.exists(dataPath, new LinkOption[0])) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("{}\u533a\u5757\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u52a0\u8f7d: {}", typeName, dataPath);
            return 0;
        }
        try {
            String expectedType;
            CompoundTag rootTag = NbtIo.readCompressed((InputStream)Files.newInputStream(dataPath, new OpenOption[0]), (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (!rootTag.contains("dimensions")) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("{}\u533a\u5757\u6570\u636e\u6587\u4ef6\u683c\u5f0f\u65e0\u6548", typeName);
                return 0;
            }
            String fileType = rootTag.getString("type");
            String string = expectedType = isStrong ? "strong" : "weak";
            if (!expectedType.equals(fileType)) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("{}\u533a\u5757\u6570\u636e\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u671f\u671b: {}, \u5b9e\u9645: {}", typeName, expectedType, fileType);
            }
            CompoundTag dimensionsTag = rootTag.getCompound("dimensions");
            int loadedChunkCount = 0;
            for (String dimensionId : dimensionsTag.getAllKeys()) {
                ListTag chunksList = dimensionsTag.getList(dimensionId, 10);
                Map dimensionChunks = loadedChunks.computeIfAbsent(dimensionId, k -> new ConcurrentHashMap());
                for (int i = 0; i < chunksList.size(); ++i) {
                    CompoundTag chunkTag = chunksList.getCompound(i);
                    int x = chunkTag.getInt("x");
                    int z = chunkTag.getInt("z");
                    ChunkPos pos = new ChunkPos(x, z);
                    dimensionChunks.put(pos, isStrong);
                    ++loadedChunkCount;
                }
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u4ece{}\u6587\u4ef6\u52a0\u8f7d\u4e86 {} \u4e2a\u533a\u5757\u6570\u636e", typeName, loadedChunkCount);
            return loadedChunkCount;
        }
        catch (IOException e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u52a0\u8f7d{}\u533a\u5757\u6570\u636e\u5931\u8d25: {}", typeName, e.getMessage());
            return 0;
        }
    }

    private void reapplyChunkTickets() {
        if (this.server == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u670d\u52a1\u5668\u5b9e\u4f8b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u91cd\u65b0\u5e94\u7528\u533a\u5757\u7968\u636e");
            return;
        }
        int reappliedCount = 0;
        for (Map.Entry<String, Map<ChunkPos, Boolean>> dimensionEntry : loadedChunks.entrySet()) {
            String dimensionId = dimensionEntry.getKey();
            Map<ChunkPos, Boolean> chunks = dimensionEntry.getValue();
            ServerLevel level = null;
            for (ServerLevel serverLevel : this.server.getAllLevels()) {
                if (!serverLevel.dimension().location().toString().equals(dimensionId)) continue;
                level = serverLevel;
                break;
            }
            if (level == null) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u627e\u4e0d\u5230\u7ef4\u5ea6 {}\uff0c\u8df3\u8fc7\u533a\u5757\u7968\u636e\u5e94\u7528", dimensionId);
                continue;
            }
            for (Map.Entry entry : chunks.entrySet()) {
                ChunkPos pos = (ChunkPos)entry.getKey();
                Boolean isStrong = (Boolean)entry.getValue();
                try {
                    if (isStrong.booleanValue()) {
                        level.getChunkSource().addRegionTicket(BROOM_STRONG_LOADING_TICKET, pos, 2, (Object)pos);
                    } else {
                        level.getChunkSource().addRegionTicket(BROOM_WEAK_LOADING_TICKET, pos, 0, (Object)pos);
                    }
                    ++reappliedCount;
                }
                catch (Exception e) {
                    AshenWitchBroom.WRAPPED_LOGGER.error("\u91cd\u65b0\u5e94\u7528\u533a\u5757\u7968\u636e\u5931\u8d25: ({}, {}) \u5728\u7ef4\u5ea6 {}: {}", pos.x, pos.z, dimensionId, e.getMessage());
                }
            }
        }
        AshenWitchBroom.WRAPPED_LOGGER.info("\u91cd\u65b0\u5e94\u7528\u4e86 {} \u4e2a\u533a\u5757\u7968\u636e", reappliedCount);
    }

    public static List<ChunkRegion> groupAdjacentChunks(Set<ChunkPos> chunks) {
        if (chunks.isEmpty()) {
            return new ArrayList<ChunkRegion>();
        }
        ArrayList<ChunkRegion> regions = new ArrayList<ChunkRegion>();
        HashSet<ChunkPos> unprocessed = new HashSet<ChunkPos>(chunks);
        while (!unprocessed.isEmpty()) {
            ChunkPos start = (ChunkPos)unprocessed.iterator().next();
            List<ChunkPos> connectedChunks = BroomChunkTicketManager.findConnectedChunks(start, unprocessed);
            unprocessed.removeAll(connectedChunks);
            regions.add(new ChunkRegion(connectedChunks));
        }
        return regions;
    }

    private static List<ChunkPos> findConnectedChunks(ChunkPos start, Set<ChunkPos> available) {
        ArrayList<ChunkPos> connected = new ArrayList<ChunkPos>();
        HashSet<ChunkPos> visited = new HashSet<ChunkPos>();
        BroomChunkTicketManager.dfsConnectedChunks(start, available, visited, connected);
        return connected;
    }

    private static void dfsConnectedChunks(ChunkPos current, Set<ChunkPos> available, Set<ChunkPos> visited, List<ChunkPos> connected) {
        ChunkPos[] neighbors;
        if (!available.contains(current) || visited.contains(current)) {
            return;
        }
        visited.add(current);
        connected.add(current);
        for (ChunkPos neighbor : neighbors = new ChunkPos[]{new ChunkPos(current.x + 1, current.z), new ChunkPos(current.x - 1, current.z), new ChunkPos(current.x, current.z + 1), new ChunkPos(current.x, current.z - 1)}) {
            BroomChunkTicketManager.dfsConnectedChunks(neighbor, available, visited, connected);
        }
    }

    public List<ChunkRegion> getGroupedChunksByType(ServerLevel level, boolean loadType) {
        Set<ChunkPos> chunks = this.getLoadedChunksByType(level, loadType);
        return BroomChunkTicketManager.groupAdjacentChunks(chunks);
    }

    public static enum ChunkAddResult {
        SUCCESS,
        ALREADY_EXISTS_SAME_TYPE,
        ALREADY_EXISTS_DIFFERENT_TYPE,
        FAILED;

    }

    public static class BatchOperationResult {
        private final int successCount;
        private final int failureCount;
        private final List<ChunkPos> successChunks;
        private final List<ChunkPos> failureChunks;
        private final List<ChunkPos> alreadyExistsSameType;
        private final List<ChunkPos> alreadyExistsDifferentType;

        public BatchOperationResult(int successCount, int failureCount, List<ChunkPos> successChunks, List<ChunkPos> failureChunks) {
            this.successCount = successCount;
            this.failureCount = failureCount;
            this.successChunks = successChunks;
            this.failureChunks = failureChunks;
            this.alreadyExistsSameType = new ArrayList<ChunkPos>();
            this.alreadyExistsDifferentType = new ArrayList<ChunkPos>();
        }

        public BatchOperationResult(int successCount, int failureCount, List<ChunkPos> successChunks, List<ChunkPos> failureChunks, List<ChunkPos> alreadyExistsSameType, List<ChunkPos> alreadyExistsDifferentType) {
            this.successCount = successCount;
            this.failureCount = failureCount;
            this.successChunks = successChunks;
            this.failureChunks = failureChunks;
            this.alreadyExistsSameType = alreadyExistsSameType;
            this.alreadyExistsDifferentType = alreadyExistsDifferentType;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public int getFailureCount() {
            return this.failureCount;
        }

        public List<ChunkPos> getSuccessChunks() {
            return this.successChunks;
        }

        public List<ChunkPos> getFailureChunks() {
            return this.failureChunks;
        }

        public List<ChunkPos> getAlreadyExistsSameType() {
            return this.alreadyExistsSameType;
        }

        public List<ChunkPos> getAlreadyExistsDifferentType() {
            return this.alreadyExistsDifferentType;
        }

        public int getTotalCount() {
            return this.successCount + this.failureCount;
        }
    }

    public static class ChunkRegion {
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        private final List<ChunkPos> chunks;
        private final boolean isRectangular;

        public ChunkRegion(List<ChunkPos> chunks) {
            this.chunks = new ArrayList<ChunkPos>(chunks);
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (ChunkPos chunk : chunks) {
                minX = Math.min(minX, chunk.x);
                minZ = Math.min(minZ, chunk.z);
                maxX = Math.max(maxX, chunk.x);
                maxZ = Math.max(maxZ, chunk.z);
            }
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
            int expectedChunks = (maxX - minX + 1) * (maxZ - minZ + 1);
            this.isRectangular = chunks.size() == expectedChunks;
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinZ() {
            return this.minZ;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxZ() {
            return this.maxZ;
        }

        public List<ChunkPos> getChunks() {
            return new ArrayList<ChunkPos>(this.chunks);
        }

        public boolean isRectangular() {
            return this.isRectangular;
        }

        public int getChunkCount() {
            return this.chunks.size();
        }

        public String getDisplayString() {
            if (this.chunks.size() == 1) {
                ChunkPos chunk = this.chunks.get(0);
                return String.format("(%d, %d)", chunk.x, chunk.z);
            }
            if (this.isRectangular && this.chunks.size() > 1) {
                return String.format("(%d, %d) to (%d, %d) [%dx%d]", this.minX, this.minZ, this.maxX, this.maxZ, this.maxX - this.minX + 1, this.maxZ - this.minZ + 1);
            }
            return String.format("Region with %d chunks: %s", this.chunks.size(), this.chunks.stream().map(c -> String.format("(%d,%d)", c.x, c.z)).reduce((a, b) -> a + ", " + b).orElse(""));
        }
    }
}

