/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.client;

import com.magicbroom.examplemod.client.KeyBoardInput;
import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import com.magicbroom.examplemod.network.BroomMountPackets;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="ashenwitchbroom", value={Dist.CLIENT})
public class ClientHandler {
    private static CameraType previousCameraType = null;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Minecraft mc = Minecraft.getInstance();
        if (player != mc.player || mc.level == null) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof MajoBroomEntity) {
            MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
            float forward = 0.0f;
            float strafe = 0.0f;
            boolean jumping = false;
            boolean shiftKeyDown = false;
            boolean sprinting = false;
            boolean ctrlPressed = false;
            if (mc.options.keyUp.isDown()) {
                forward += 1.0f;
            }
            if (mc.options.keyDown.isDown()) {
                forward -= 1.0f;
            }
            if (mc.options.keyLeft.isDown()) {
                strafe += 1.0f;
            }
            if (mc.options.keyRight.isDown()) {
                strafe -= 1.0f;
            }
            if (KeyBoardInput.up || mc.options.keyJump.isDown()) {
                jumping = true;
            }
            if (KeyBoardInput.down) {
                shiftKeyDown = true;
            }
            if (KeyBoardInput.speedBoost) {
                ctrlPressed = true;
            }
            if (KeyBoardInput.DOWN_KEY.getKey().getValue() == 341 && KeyBoardInput.SPEED_BOOST_KEY.getKey().getValue() == 341) {
                if (KeyBoardInput.speedBoost) {
                    shiftKeyDown = true;
                    sprinting = true;
                }
            } else if (KeyBoardInput.speedBoost) {
                sprinting = true;
            }
            broomEntity.updatePlayerInput(forward, strafe, jumping, shiftKeyDown, sprinting, KeyBoardInput.up, KeyBoardInput.down, ctrlPressed);
        }
    }

    @SubscribeEvent
    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        MajoBroomEntity broomEntity;
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (entity instanceof MajoBroomEntity && (broomEntity = (MajoBroomEntity)entity).isSpeedBoostActive()) {
            event.setNewFovModifier(event.getFovModifier() * 1.15f);
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (!event.getLevel().isClientSide || !((entity = event.getEntityBeingMounted()) instanceof MajoBroomEntity)) {
            return;
        }
        MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || !event.getEntityMounting().equals((Object)mc.player)) {
            return;
        }
        if (event.isMounting()) {
            if (((Boolean)Config.ADVANCED_MODE.get()).booleanValue()) {
                previousCameraType = mc.options.getCameraType();
                mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
            }
        } else if (((Boolean)Config.ADVANCED_MODE.get()).booleanValue() && previousCameraType != null) {
            mc.options.setCameraType(previousCameraType);
            previousCameraType = null;
        }
    }

    @SubscribeEvent
    public static void onMovementInputUpdate(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (player == null || !player.level().isClientSide) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof MajoBroomEntity) {
            MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
            if (event.getInput().shiftKeyDown) {
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u62e6\u622ashift\u952e\u4e0b\u9a6c\uff0c\u53d1\u9001\u81ea\u5b9a\u4e49\u4e0b\u9a6c\u8bf7\u6c42\uff1a\u73a9\u5bb6 {} \u4ece\u626b\u5e1a {} (ID: {})", player.getName().getString(), broomEntity.getBroomName(), broomEntity.getId());
                broomEntity.setDeltaMovement(Vec3.ZERO);
                broomEntity.updatePlayerInput(0.0f, 0.0f, false, false, false, false, false, false);
                event.getInput().shiftKeyDown = false;
                BroomMountPackets.BroomMountRequestPack packet = new BroomMountPackets.BroomMountRequestPack(broomEntity.getId(), false);
                PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

