/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.core;

import com.magicbroom.examplemod.chunk.BroomChunkTicketManager;
import com.magicbroom.examplemod.chunk.ChunkLoadingManager;
import com.magicbroom.examplemod.command.BroomCommand;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import com.magicbroom.examplemod.item.MajoBroomItem;
import com.magicbroom.examplemod.item.MajoClothItem;
import com.magicbroom.examplemod.item.MajoHatItem;
import com.magicbroom.examplemod.util.LoggerWrapper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="ashenwitchbroom")
public class AshenWitchBroom {
    public static final String MODID = "ashenwitchbroom";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LoggerWrapper WRAPPED_LOGGER = new LoggerWrapper(LOGGER);
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ashenwitchbroom");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ashenwitchbroom");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ashenwitchbroom");
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"ashenwitchbroom");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ashenwitchbroom");
    public static final Holder<ArmorMaterial> MAJO_HAT_MATERIAL = ARMOR_MATERIALS.register("majo_hat", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 0, ArmorItem.Type.LEGGINGS, 0, ArmorItem.Type.BOOTS, 0), 15, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((TagKey)ItemTags.WOOL), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"majo_hat"), "", true), new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"majo_hat"), "_overlay", false)), 0.0f, 0.0f));
    public static final DeferredItem<MajoHatItem> MAJO_HAT = ITEMS.register("majo_hat", () -> new MajoHatItem(MAJO_HAT_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(14525383, false))));
    public static final Holder<ArmorMaterial> MAJO_CLOTH_MATERIAL = ARMOR_MATERIALS.register("majo_cloth", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 0, ArmorItem.Type.CHESTPLATE, 6, ArmorItem.Type.LEGGINGS, 0, ArmorItem.Type.BOOTS, 0), 15, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((TagKey)ItemTags.WOOL), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"majo_cloth"), "", false)), 0.0f, 0.0f));
    public static final DeferredItem<MajoClothItem> MAJO_CLOTH = ITEMS.register("majo_cloth", () -> new MajoClothItem(MAJO_CLOTH_MATERIAL, ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<MajoBroomItem> MAJO_BROOM_ITEM = ITEMS.register("majo_broom", () -> new MajoBroomItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<EntityType<?>, EntityType<MajoBroomEntity>> MAJO_BROOM_ENTITY = ENTITY_TYPES.register("majo_broom", () -> EntityType.Builder.of(MajoBroomEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 0.5f).clientTrackingRange(192).updateInterval(1).build("majo_broom"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.ashenwitchbroom")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((MajoBroomItem)((Object)((Object)((Object)MAJO_BROOM_ITEM.get())))).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)MAJO_HAT.get());
        output.accept((ItemLike)MAJO_CLOTH.get());
        output.accept((ItemLike)MAJO_BROOM_ITEM.get());
    }).build());

    public AshenWitchBroom(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ARMOR_MATERIALS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.debug("\u901a\u7528\u8bbe\u7f6e\u521d\u59cb\u5316\u5b8c\u6210");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.debug("\u670d\u52a1\u5668\u542f\u52a8\u4e2d");
        BroomChunkTicketManager.getInstance().setServer(event.getServer());
        LOGGER.debug("\u533a\u5757\u6301\u4e45\u5316\u7cfb\u7edf\u5df2\u521d\u59cb\u5316");
        BroomCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().getCommands().getDispatcher());
        LOGGER.debug("\u626b\u5e1a\u6307\u4ee4\u5df2\u6ce8\u518c");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.debug("\u670d\u52a1\u5668\u505c\u6b62\u4e2d\uff0c\u4fdd\u5b58\u533a\u5757\u6570\u636e");
        ChunkLoadingManager.getInstance().clearAllLoadedChunks();
        BroomChunkTicketManager.getInstance().shutdown();
        LOGGER.debug("\u533a\u5757\u6570\u636e\u5df2\u4fdd\u5b58\uff0c\u7ba1\u7406\u5668\u5df2\u5173\u95ed");
    }
}

