/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.data;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BroomData {
    private String broomName;
    private ResourceKey<Level> dimension;
    private BlockPos position;
    private UUID entityUUID;

    public BroomData(String broomName, ResourceKey<Level> dimension, BlockPos position) {
        this.broomName = broomName;
        this.dimension = dimension;
        this.position = position;
        this.entityUUID = null;
    }

    public BroomData(String broomName, ResourceKey<Level> dimension, BlockPos position, UUID entityUUID) {
        this.broomName = broomName;
        this.dimension = dimension;
        this.position = position;
        this.entityUUID = entityUUID;
    }

    public static BroomData fromNBT(CompoundTag tag) {
        ResourceKey dimension;
        String broomName = tag.getString("broomName");
        String dimensionStr = tag.getString("dimension");
        BlockPos position = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        try {
            ResourceLocation dimensionLocation = ResourceLocation.parse((String)dimensionStr);
            dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u89e3\u6790\u7ef4\u5ea6 '{}' \u5931\u8d25\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4e3b\u4e16\u754c\uff1a{}", dimensionStr, e.getMessage());
            dimension = Level.OVERWORLD;
        }
        UUID entityUUID = null;
        if (tag.contains("entityUUID", 8)) {
            try {
                entityUUID = UUID.fromString(tag.getString("entityUUID"));
            }
            catch (IllegalArgumentException e) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u626b\u5e1a\u6570\u636e\u4e2d\u7684\u5b9e\u4f53UUID\u65e0\u6548\uff1a{}", tag.getString("entityUUID"));
            }
        }
        if (entityUUID == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u626b\u5e1a\u6570\u636e\u7f3a\u5c11\u5fc5\u9700\u7684\u5b9e\u4f53UUID\uff0c\u6b64\u6570\u636e\u5c06\u65e0\u6548");
        }
        return new BroomData(broomName, (ResourceKey<Level>)dimension, position, entityUUID);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("broomName", this.broomName);
        tag.putString("dimension", this.dimension.location().toString());
        tag.putInt("x", this.position.getX());
        tag.putInt("y", this.position.getY());
        tag.putInt("z", this.position.getZ());
        if (this.entityUUID != null) {
            tag.putString("entityUUID", this.entityUUID.toString());
        }
        return tag;
    }

    public double getDistanceSquared(BlockPos playerPos, ResourceKey<Level> playerDimension) {
        if (!this.dimension.equals(playerDimension)) {
            return Double.MAX_VALUE;
        }
        double dx = this.position.getX() - playerPos.getX();
        double dy = this.position.getY() - playerPos.getY();
        double dz = this.position.getZ() - playerPos.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public String getBroomName() {
        return this.broomName;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public void setBroomName(String broomName) {
        this.broomName = broomName;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    public void setEntityUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public String toString() {
        return String.format("BroomData{name='%s', dimension='%s', pos=%s, entityUUID=%s}", this.broomName, this.dimension.location().toString(), this.position.toString(), this.entityUUID);
    }
}

