/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.data;

import com.magicbroom.examplemod.chunk.ChunkLoadingManager;
import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class BroomDataManager {
    private static final String DATA_FOLDER = "ashenwitchbroom";
    private static final String FILE_EXTENSION = ".dat";
    private static final ConcurrentHashMap<UUID, ReentrantReadWriteLock> playerLocks = new ConcurrentHashMap();

    private static ReentrantReadWriteLock getPlayerLock(UUID playerUUID) {
        return playerLocks.computeIfAbsent(playerUUID, k -> new ReentrantReadWriteLock());
    }

    private static File getPlayerBroomFile(ServerLevel level, UUID playerUUID) {
        File worldDir = level.getServer().getWorldPath(LevelResource.ROOT).toFile();
        File dataDir = new File(worldDir, DATA_FOLDER);
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return new File(dataDir, playerUUID.toString() + FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BroomData> loadPlayerBrooms(ServerLevel level, UUID playerUUID) {
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        lock.readLock().lock();
        try {
            ArrayList<BroomData> brooms = new ArrayList<BroomData>();
            File broomFile = BroomDataManager.getPlayerBroomFile(level, playerUUID);
            if (!broomFile.exists()) {
                ArrayList<BroomData> arrayList = brooms;
                return arrayList;
            }
            try {
                CompoundTag rootTag = NbtIo.readCompressed((Path)broomFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                ListTag broomsList = rootTag.getList("brooms", 10);
                for (int i = 0; i < broomsList.size(); ++i) {
                    CompoundTag broomTag = broomsList.getCompound(i);
                    BroomData broomData = BroomData.fromNBT(broomTag);
                    brooms.add(broomData);
                }
            }
            catch (IOException e) {
                AshenWitchBroom.WRAPPED_LOGGER.error("\u52a0\u8f7d\u73a9\u5bb6 {} \u7684\u626b\u5e1a\u6570\u636e\u5931\u8d25\uff1a{}", playerUUID, e.getMessage());
            }
            ArrayList<BroomData> arrayList = brooms;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayerBrooms(ServerLevel level, UUID playerUUID, List<BroomData> brooms) {
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        lock.writeLock().lock();
        try {
            File broomFile = BroomDataManager.getPlayerBroomFile(level, playerUUID);
            try {
                CompoundTag rootTag = new CompoundTag();
                ListTag broomsList = new ListTag();
                for (BroomData broomData : brooms) {
                    broomsList.add((Object)broomData.toNBT());
                }
                rootTag.put("brooms", (Tag)broomsList);
                NbtIo.writeCompressed((CompoundTag)rootTag, (Path)broomFile.toPath());
            }
            catch (IOException e) {
                AshenWitchBroom.WRAPPED_LOGGER.error("\u4fdd\u5b58\u73a9\u5bb6 {} \u7684\u626b\u5e1a\u6570\u636e\u5931\u8d25\uff1a{}", playerUUID, e.getMessage());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void addBroom(ServerLevel level, UUID playerUUID, String broomName, ResourceKey<Level> dimension, BlockPos position, UUID entityUUID) {
        if (entityUUID == null) {
            throw new IllegalArgumentException("entityUUID cannot be null when adding broom data");
        }
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        brooms.add(new BroomData(broomName, dimension, position, entityUUID));
        BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
        AshenWitchBroom.WRAPPED_LOGGER.debug("\u4e3a\u73a9\u5bb6 {} \u6dfb\u52a0\u626b\u5e1a '{}' \u5728\u4f4d\u7f6e {} \u7ef4\u5ea6 {} (\u5b9e\u4f53UUID: {})", playerUUID, broomName, position, dimension.location(), entityUUID);
    }

    public static boolean removeBroom(ServerLevel level, UUID playerUUID, String broomName) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        boolean removed = brooms.removeIf(broom -> broom.getBroomName().equals(broomName));
        if (removed) {
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u4e3a\u73a9\u5bb6 {} \u79fb\u9664\u626b\u5e1a '{}'", playerUUID, broomName);
        }
        return removed;
    }

    public static boolean updateBroom(ServerLevel level, UUID playerUUID, String broomName, ResourceKey<Level> newDimension, BlockPos newPosition, UUID newEntityUUID) {
        if (newEntityUUID == null) {
            throw new IllegalArgumentException("newEntityUUID cannot be null when updating broom data");
        }
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!broom.getBroomName().equals(broomName)) continue;
            broom.setDimension(newDimension);
            broom.setPosition(newPosition);
            if (newEntityUUID != null) {
                broom.setEntityUUID(newEntityUUID);
            }
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            return true;
        }
        return false;
    }

    public static BroomData findBroom(ServerLevel level, UUID playerUUID, String broomName) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!broom.getBroomName().equals(broomName)) continue;
            return broom;
        }
        return null;
    }

    public static BroomData findBroomByEntityUUID(ServerLevel level, UUID playerUUID, UUID entityUUID) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!entityUUID.equals(broom.getEntityUUID())) continue;
            return broom;
        }
        return null;
    }

    public static boolean validateBroomEntityUUID(ServerLevel level, UUID playerUUID, String broomName, UUID expectedEntityUUID) {
        BroomData broom = BroomDataManager.findBroom(level, playerUUID, broomName);
        if (broom == null) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u7684\u626b\u5e1a '{}' \u672a\u627e\u5230", playerUUID, broomName);
            return false;
        }
        UUID storedUUID = broom.getEntityUUID();
        if (storedUUID == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u626b\u5e1a '{}' \u6ca1\u6709\u5b9e\u4f53UUID\uff0c\u4e3a\u73a9\u5bb6 {} \u79fb\u9664\u65e0\u6548\u6570\u636e", broomName, playerUUID);
            BroomDataManager.removeBroom(level, playerUUID, broomName);
            return false;
        }
        if (!storedUUID.equals(expectedEntityUUID)) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u73a9\u5bb6 {} \u7684\u626b\u5e1a '{}' \u5b9e\u4f53UUID\u4e0d\u5339\u914d\u3002\u671f\u671b\uff1a{}\uff0c\u5b58\u50a8\uff1a{}\u3002\u79fb\u9664\u8fc7\u671f\u6570\u636e\u3002", playerUUID, broomName, expectedEntityUUID, storedUUID);
            BroomDataManager.removeBroom(level, playerUUID, broomName);
            return false;
        }
        return true;
    }

    public static CompletableFuture<Boolean> verifyBroomExists(ServerPlayer player, String broomName) {
        UUID playerUUID = player.getUUID();
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        if (lock.isWriteLocked()) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u8df3\u8fc7\u73a9\u5bb6 {} \u7684\u626b\u5e1a\u9a8c\u8bc1\uff08\u5199\u5165\u64cd\u4f5c\u8fdb\u884c\u4e2d\uff09", playerUUID);
            return CompletableFuture.completedFuture(false);
        }
        BroomData broomData = BroomDataManager.findBroom((ServerLevel)player.level(), playerUUID, broomName);
        if (broomData == null) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u7684\u626b\u5e1a '{}' \u5728\u6570\u636e\u4e2d\u672a\u627e\u5230", playerUUID, broomName);
            return CompletableFuture.completedFuture(false);
        }
        UUID targetEntityUUID = broomData.getEntityUUID();
        if (targetEntityUUID == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u626b\u5e1a '{}' \u6ca1\u6709\u5b9e\u4f53UUID\uff0c\u4e3a\u73a9\u5bb6 {} \u79fb\u9664\u65e0\u6548\u6570\u636e", broomName, playerUUID);
            BroomDataManager.removeBroom((ServerLevel)player.level(), playerUUID, broomName);
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
        if (targetLevel == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u626b\u5e1a '{}' \u7684\u76ee\u6807\u7ef4\u5ea6 {} \u672a\u627e\u5230", broomName, broomData.getDimension().location());
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        BlockPos broomPos = broomData.getPosition();
        ChunkPos broomChunk = new ChunkPos(broomPos);
        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomDataManager - \u626b\u5e1a\u68c0\u6d4b\u5750\u6807\u8f6c\u6362: \u539f\u59cb\u5750\u6807 BlockPos({}, {}, {}) -> \u533a\u5757\u5750\u6807 ChunkPos({}, {})", broomPos.getX(), broomPos.getY(), broomPos.getZ(), broomChunk.x, broomChunk.z);
        ChunkLoadingManager.getInstance().addWeakLoadedChunkAsync(targetLevel, broomChunk.x, broomChunk.z, chunkLoaded -> {
            try {
                if (chunkLoaded.booleanValue()) {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("BroomDataManager - \u533a\u5757 ({}, {}) \u52a0\u8f7d\u5b8c\u6210\uff0c\u5f00\u59cb\u9a8c\u8bc1\u626b\u5e1a '{}' \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, broomName, targetLevel.dimension().location());
                    Entity targetEntity = targetLevel.getEntity(targetEntityUUID);
                    if (targetEntity instanceof MajoBroomEntity) {
                        MajoBroomEntity broomEntity = (MajoBroomEntity)targetEntity;
                        if (broomData.getBroomName().equals(broomEntity.getBroomName()) && playerUUID.equals(broomEntity.getOwnerUUID())) {
                            AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u7684\u626b\u5e1a '{}' \u5df2\u901a\u8fc7UUID {} \u9a8c\u8bc1", playerUUID, broomName, targetEntityUUID);
                            result.complete(true);
                        } else {
                            AshenWitchBroom.WRAPPED_LOGGER.warn("\u627e\u5230\u626b\u5e1a\u5b9e\u4f53UUID {} \u4f46\u540d\u79f0/\u62e5\u6709\u8005\u4e0d\u5339\u914d\u3002\u671f\u671b\uff1a{}/{}\uff0c\u5b9e\u9645\uff1a{}/{}", targetEntityUUID, broomData.getBroomName(), playerUUID, broomEntity.getBroomName(), broomEntity.getOwnerUUID());
                            result.complete(false);
                        }
                    } else {
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757\u52a0\u8f7d\u540e\u672a\u627e\u5230UUID\u4e3a {} \u7684\u626b\u5e1a\u5b9e\u4f53\uff0c\u79fb\u9664\u8fc7\u671f\u6570\u636e", targetEntityUUID);
                        BroomDataManager.removeBroom(targetLevel, playerUUID, broomName);
                        result.complete(false);
                    }
                } else {
                    AshenWitchBroom.WRAPPED_LOGGER.error("BroomDataManager - \u533a\u5757 ({}, {}) \u52a0\u8f7d\u5931\u8d25\u6216\u8d85\u65f6\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u626b\u5e1a '{}'", broomChunk.x, broomChunk.z, broomName);
                    result.complete(false);
                }
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
            }
            catch (Throwable throwable) {
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                AshenWitchBroom.WRAPPED_LOGGER.debug("BroomDataManager - \u5df2\u6e05\u7406\u9a8c\u8bc1\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                throw throwable;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("BroomDataManager - \u5df2\u6e05\u7406\u9a8c\u8bc1\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
        }, 15);
        return result;
    }

    public static String generateUniqueBroomName(ServerLevel level, UUID playerUUID) {
        List<BroomData> existingBrooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        int counter = 1;
        String baseName = Component.translatable((String)"broom.ashenwitchbroom.default_name").getString();
        String broomName = baseName + counter;
        boolean nameExists = true;
        while (nameExists) {
            String currentName = broomName;
            nameExists = existingBrooms.stream().anyMatch(broom -> broom.getBroomName().equals(currentName));
            if (!nameExists) continue;
            broomName = baseName + ++counter;
        }
        return broomName;
    }

    public static String generateUniqueBroomName(ServerLevel level, UUID playerUUID, String baseName) {
        List<BroomData> existingBrooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        boolean nameExists = existingBrooms.stream().anyMatch(broom -> broom.getBroomName().equals(baseName));
        if (!nameExists) {
            return baseName;
        }
        int counter = 2;
        String broomName = baseName + "_" + counter;
        nameExists = true;
        while (nameExists) {
            String currentName = broomName;
            nameExists = existingBrooms.stream().anyMatch(broom -> broom.getBroomName().equals(currentName));
            if (!nameExists) continue;
            broomName = baseName + "_" + ++counter;
        }
        return broomName;
    }
}

