/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.network;

import com.magicbroom.examplemod.service.BroomSummonService;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SummonBroomPack(double x, double y, double z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SummonBroomPack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ashenwitchbroom", (String)"summon_broom_pack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SummonBroomPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, SummonBroomPack::x, (StreamCodec)ByteBufCodecs.DOUBLE, SummonBroomPack::y, (StreamCodec)ByteBufCodecs.DOUBLE, SummonBroomPack::z, SummonBroomPack::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(SummonBroomPack packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            BroomSummonService.summonBroom(player, packet.x, packet.y, packet.z);
        });
    }
}

