/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.service;

import com.magicbroom.examplemod.chunk.ChunkLoadingManager;
import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.data.BroomDataManager;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BroomSummonService {
    private static final ConcurrentHashMap<UUID, ReentrantLock> playerLocks = new ConcurrentHashMap();

    public static void summonBroom(ServerPlayer player, double x, double y, double z) {
        UUID playerUUID = player.getUUID();
        ReentrantLock playerLock = playerLocks.computeIfAbsent(playerUUID, k -> new ReentrantLock());
        if (!playerLock.tryLock()) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u7684\u53ec\u5524\u8bf7\u6c42\u88ab\u5ffd\u7565 - \u4e0a\u4e00\u4e2a\u64cd\u4f5c\u4ecd\u5728\u8fdb\u884c\u4e2d", playerUUID);
            return;
        }
        try {
            if (player.isPassenger() && player.getVehicle() instanceof MajoBroomEntity) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.already_riding"));
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockPos playerPos = player.blockPosition();
            ResourceKey playerDimension = level.dimension();
            List<BroomData> playerBrooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
            CompletableFuture<String> summonFuture = BroomSummonService.findBestBroomToSummon(level, player, playerBrooms, playerPos, (ResourceKey<Level>)playerDimension);
            ((CompletableFuture)summonFuture.thenAccept(broomName -> level.getServer().execute(() -> {
                try {
                    if (broomName != null) {
                        BroomSummonService.executeBroomSummon(player, broomName, playerPos, (ResourceKey<Level>)playerDimension);
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.no_broom_available"));
                        if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                            BroomSummonService.showBroomSummary(player, playerBrooms);
                        }
                    }
                }
                finally {
                    playerLock.unlock();
                }
            }))).exceptionally(throwable -> {
                level.getServer().execute(() -> playerLock.unlock());
                AshenWitchBroom.WRAPPED_LOGGER.error("\u73a9\u5bb6 {} \u53ec\u5524\u626b\u5e1a\u65f6\u53d1\u751f\u9519\u8bef\uff1a{}", playerUUID, throwable.getMessage());
                return null;
            });
        }
        catch (Exception e) {
            playerLock.unlock();
            AshenWitchBroom.WRAPPED_LOGGER.error("\u73a9\u5bb6 {} \u7684summonBroom\u65b9\u6cd5\u53d1\u751f\u9519\u8bef\uff1a{}", playerUUID, e.getMessage());
            throw e;
        }
    }

    private static CompletableFuture<String> findBestBroomToSummon(ServerLevel level, ServerPlayer player, List<BroomData> playerBrooms, BlockPos playerPos, ResourceKey<Level> playerDimension) {
        ItemStack broomItem;
        ArrayList<BroomData> candidateBrooms = new ArrayList<BroomData>();
        if (((Boolean)Config.ENABLE_NEARBY_SUMMON.get()).booleanValue()) {
            int searchRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
            List<BroomData> nearbyBrooms = BroomSummonService.filterBroomsByDistance(playerBrooms, playerPos, playerDimension, searchRange);
            candidateBrooms.addAll(nearbyBrooms);
        }
        if (((Boolean)Config.ENABLE_WORLD_SUMMON.get()).booleanValue() && candidateBrooms.isEmpty()) {
            List<BroomData> worldBrooms = BroomSummonService.filterBroomsByDimension(playerBrooms, playerDimension);
            candidateBrooms.addAll(worldBrooms);
        }
        if (((Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get()).booleanValue() && candidateBrooms.isEmpty()) {
            candidateBrooms.addAll(playerBrooms);
        }
        if (candidateBrooms.isEmpty() && ((Boolean)Config.ENABLE_INVENTORY_SUMMON.get()).booleanValue() && (broomItem = BroomSummonService.findBroomInInventory(player)) != null) {
            return CompletableFuture.completedFuture("FROM_INVENTORY");
        }
        if (candidateBrooms.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        candidateBrooms.sort(Comparator.comparingDouble(broom -> broom.getDistanceSquared(playerPos, playerDimension)));
        return BroomSummonService.verifyBroomsSequentially(player, candidateBrooms, 0);
    }

    private static List<BroomData> filterBroomsByDistance(List<BroomData> brooms, BlockPos playerPos, ResourceKey<Level> playerDimension, int maxDistance) {
        ArrayList<BroomData> filtered = new ArrayList<BroomData>();
        double maxDistanceSquared = maxDistance * maxDistance;
        for (BroomData broom : brooms) {
            double distanceSquared;
            if (!broom.getDimension().equals(playerDimension) || !((distanceSquared = broom.getDistanceSquared(playerPos, playerDimension)) <= maxDistanceSquared)) continue;
            filtered.add(broom);
        }
        return filtered;
    }

    private static List<BroomData> filterBroomsByDimension(List<BroomData> brooms, ResourceKey<Level> dimension) {
        ArrayList<BroomData> filtered = new ArrayList<BroomData>();
        for (BroomData broom : brooms) {
            if (!broom.getDimension().equals(dimension)) continue;
            filtered.add(broom);
        }
        return filtered;
    }

    private static CompletableFuture<String> verifyBroomsSequentially(ServerPlayer player, List<BroomData> brooms, int index) {
        if (index >= brooms.size()) {
            return CompletableFuture.completedFuture(null);
        }
        BroomData currentBroom = brooms.get(index);
        return BroomDataManager.verifyBroomExists(player, currentBroom.getBroomName()).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(currentBroom.getBroomName());
            }
            BroomDataManager.removeBroom(player.serverLevel(), player.getUUID(), currentBroom.getBroomName());
            return BroomSummonService.verifyBroomsSequentially(player, brooms, index + 1);
        });
    }

    private static void executeBroomSummon(ServerPlayer player, String broomName, BlockPos playerPos, ResourceKey<Level> playerDimension) {
        ServerLevel level = player.serverLevel();
        if ("FROM_INVENTORY".equals(broomName)) {
            BroomSummonService.summonFromInventory(player, playerPos);
            return;
        }
        BroomData broomData = BroomDataManager.findBroom(level, player.getUUID(), broomName);
        if (broomData != null) {
            boolean isCrossDimension;
            BroomSummonService.removeOldBroomEntity(player, broomData);
            boolean bl = isCrossDimension = !broomData.getDimension().equals(playerDimension);
            if (isCrossDimension) {
                BroomDataManager.removeBroom(level, player.getUUID(), broomName);
                newBroom = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
                newBroom.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
                newBroom.setYRot(player.getYRot());
                newBroom.setBroomInfo(broomName, player.getUUID());
                level.addFreshEntity((Entity)newBroom);
                BroomDataManager.addBroom(level, player.getUUID(), broomName, playerDimension, playerPos, newBroom.getUUID());
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u8de8\u7ef4\u5ea6\u53ec\u5524\uff1a\u73a9\u5bb6 {} \u7684\u626b\u5e1a '{}' \u4ece {} \u79fb\u52a8\u5230 {}", player.getUUID(), broomName, broomData.getDimension().location(), playerDimension.location());
            } else {
                newBroom = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
                newBroom.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
                newBroom.setYRot(player.getYRot());
                newBroom.setBroomInfo(broomName, player.getUUID());
                level.addFreshEntity((Entity)newBroom);
                BroomDataManager.updateBroom(level, player.getUUID(), broomName, playerDimension, playerPos, newBroom.getUUID());
            }
            player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summoned", (Object[])new Object[]{broomName}));
            if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                List<BroomData> allBrooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
                BroomSummonService.showBroomSummary(player, allBrooms);
            }
        }
    }

    private static void removeOldBroomEntity(ServerPlayer player, BroomData broomData) {
        ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
        if (targetLevel == null) {
            return;
        }
        UUID targetEntityUUID = broomData.getEntityUUID();
        if (targetEntityUUID == null) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u65e0\u6cd5\u79fb\u9664\u626b\u5e1a '{}' - \u6ca1\u6709\u53ef\u7528\u7684\u5b9e\u4f53UUID", broomData.getBroomName());
            return;
        }
        BlockPos broomPos = broomData.getPosition();
        ChunkPos broomChunk = new ChunkPos(broomPos);
        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomSummonService - \u79fb\u9664\u65e7\u626b\u5e1a\u5750\u6807\u8f6c\u6362: \u539f\u59cb\u5750\u6807 BlockPos({}, {}, {}) -> \u533a\u5757\u5750\u6807 ChunkPos({}, {})", broomPos.getX(), broomPos.getY(), broomPos.getZ(), broomChunk.x, broomChunk.z);
        ChunkLoadingManager.getInstance().addWeakLoadedChunkAsync(targetLevel, broomChunk.x, broomChunk.z, chunkLoaded -> {
            try {
                if (chunkLoaded.booleanValue()) {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("BroomSummonService - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u6210\u529f\u52a0\u8f7d\u7528\u4e8e\u79fb\u9664\u65e7\u626b\u5e1a", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    Entity targetEntity = targetLevel.getEntity(targetEntityUUID);
                    if (targetEntity instanceof MajoBroomEntity) {
                        MajoBroomEntity broomEntity = (MajoBroomEntity)targetEntity;
                        if (broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID())) {
                            targetEntity.discard();
                            AshenWitchBroom.WRAPPED_LOGGER.debug("\u5df2\u79fb\u9664\u73a9\u5bb6 {} \u7684\u626b\u5e1a\u5b9e\u4f53 '{}' (UUID: {})", player.getUUID(), broomData.getBroomName(), targetEntityUUID);
                        } else {
                            AshenWitchBroom.WRAPPED_LOGGER.warn("\u627e\u5230\u626b\u5e1a\u5b9e\u4f53UUID {} \u4f46\u540d\u79f0/\u62e5\u6709\u8005\u4e0d\u5339\u914d\u3002\u671f\u671b\uff1a{}/{}\uff0c\u5b9e\u9645\uff1a{}/{}", targetEntityUUID, broomData.getBroomName(), player.getUUID(), broomEntity.getBroomName(), broomEntity.getOwnerUUID());
                        }
                    } else {
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757\u52a0\u8f7d\u540e\u672a\u627e\u5230UUID\u4e3a {} \u7684\u626b\u5e1a\u5b9e\u4f53", targetEntityUUID);
                    }
                } else {
                    AshenWitchBroom.WRAPPED_LOGGER.warn("BroomSummonService - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u52a0\u8f7d\u8d85\u65f6\uff0c\u65e0\u6cd5\u79fb\u9664\u65e7\u626b\u5e1a", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                }
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
            }
            catch (Throwable throwable) {
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                AshenWitchBroom.WRAPPED_LOGGER.debug("BroomSummonService - \u5df2\u6e05\u7406\u79fb\u9664\u65e7\u626b\u5e1a\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                throw throwable;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("BroomSummonService - \u5df2\u6e05\u7406\u79fb\u9664\u65e7\u626b\u5e1a\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
        });
    }

    private static void summonFromInventory(ServerPlayer player, BlockPos playerPos) {
        ItemStack broomItem = BroomSummonService.findBroomInInventory(player);
        if (broomItem != null) {
            ServerLevel level = player.serverLevel();
            String broomName = BroomDataManager.generateUniqueBroomName(level, player.getUUID());
            MajoBroomEntity broomEntity = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
            broomEntity.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
            broomEntity.setYRot(player.getYRot());
            broomEntity.setBroomInfo(broomName, player.getUUID());
            level.addFreshEntity((Entity)broomEntity);
            if (!player.getAbilities().instabuild) {
                broomItem.shrink(1);
            }
            BroomDataManager.addBroom(level, player.getUUID(), broomName, (ResourceKey<Level>)level.dimension(), playerPos, broomEntity.getUUID());
            player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summoned_from_inventory", (Object[])new Object[]{broomName}));
            if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                List<BroomData> allBrooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
                BroomSummonService.showBroomSummary(player, allBrooms);
            }
        }
    }

    private static ItemStack findBroomInInventory(ServerPlayer player) {
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            return itemStack;
        }
        return null;
    }

    private static void showBroomSummary(ServerPlayer player, List<BroomData> brooms) {
        int storedBrooms = brooms.size();
        int inventoryBrooms = 0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            inventoryBrooms += itemStack.getCount();
        }
        int totalBrooms = storedBrooms + inventoryBrooms;
        ResourceKey currentDimension = player.level().dimension();
        long currentDimensionBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).count();
        long allDimensionBrooms = brooms.size();
        int nearbyRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
        BlockPos playerPos = player.blockPosition();
        long nearbyBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).filter(broom -> broom.getDistanceSquared(playerPos, (ResourceKey<Level>)currentDimension) <= (double)(nearbyRange * nearbyRange)).count();
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_total", (Object[])new Object[]{totalBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_inventory", (Object[])new Object[]{inventoryBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_nearby", (Object[])new Object[]{nearbyRange, nearbyBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_current_world", (Object[])new Object[]{currentDimensionBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_all_dimensions", (Object[])new Object[]{allDimensionBrooms}));
        String nearbyStatus = (Boolean)Config.ENABLE_NEARBY_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String worldStatus = (Boolean)Config.ENABLE_WORLD_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String crossDimensionStatus = (Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String inventoryStatus = (Boolean)Config.ENABLE_INVENTORY_SUMMON.get() != false ? "\u2714" : "\u00d7";
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.summon_order_status", (Object[])new Object[]{nearbyStatus, worldStatus, crossDimensionStatus, inventoryStatus}));
    }
}

