/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.AbilityButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.LevelButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ClickHoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.AbilityColumnsComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.mixins.HolderSet$NamedAccess;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonAbilityTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.util.ExperienceUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class DragonAbilityScreen
extends Screen {
    @Translation(comments={"\u00a7f\u25a0 \u00a7cUSE THE MOUSE WHEEL TO SCROLL THROUGH THE SKILL COLUMNS.", "\u00a7f\u25a0 \u00a76Active skills\u00a7r\u00a7f are used in combat or to apply buffs.", "\u00a7f- \u00a79Skill power\u00a7r\u00a78 scales off your current experience level.", "\u00a7f- \u00a79Experience or mana\u00a7r\u00a78 points are used to cast spells.", "", "\u00a7f\u25a0 \u00a7aPassive skills\u00a7r\u00a7f are upgraded by spending experience levels or just give bonuses.", "\u00a7f- \u00a79Disable\u00a7r\u00a78 the skill by ctrl+right click.", "\u00a7f- \u00a79More information\u00a7r\u00a78 can be found on Curseforge mod page or Github Wiki."})
    private static final String HELP_PASSIVE_ACTIVE = Translation.Type.GUI.wrap("help.passive_active_abilities");
    @Translation(comments={"\u25a0 \u00a7cUSE THE MOUSE WHEEL TO SCROLL THROUGH THE SKILL COLUMNS.", "\u00a7f\u25a0 \u00a7dAbility assignment\u00a7r\u00a7f - drag and drop \u00a76Active skills\u00a7r\u00a7f to the \u00a79hotbar\u00a7r\u00a7f.", "\u00a7f- \u00a79Hotbar\u00a7r\u00a78 is used to quickly access your active skills.", "\u00a7f- \u00a78Check in-game Minecraft \u00a7r\u00a79control\u00a7r\u00a78 settings!"})
    private static final String HELP_ABILITY_ASSIGNMENT = Translation.Type.GUI.wrap("help.ability_assignment");
    private static final ResourceLocation BACKGROUND_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/background_main.png");
    private static final ResourceLocation BACKGROUND_SIDE = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/background_side.png");
    private static final ResourceLocation EXP_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/exp_empty.png");
    private static final ResourceLocation EXP_FULL = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/exp_full.png");
    private static final ResourceLocation LEFT_PANEL_ARROW_CLICK = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/addition_arrow_left_click.png");
    private static final ResourceLocation LEFT_PANEL_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/addition_arrow_left_hover.png");
    private static final ResourceLocation LEFT_PANEL_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/addition_arrow_left_main.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/info_hover.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/info_main.png");
    public LevelButton hoveredLevelButton;
    private Holder<DragonSpecies> dragonSpecies;
    private int guiLeft;
    private int guiTop;
    private boolean leftWindowOpen;
    private final List<AbstractWidget> leftWindowWidgets = new ArrayList<AbstractWidget>();
    private final List<ScrollableComponent> scrollableComponents = new ArrayList<ScrollableComponent>();

    public DragonAbilityScreen() {
        super((Component)Component.empty());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ScrollableComponent component : this.scrollableComponents) {
            component.scroll(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        this.renderBlurredBackground(partialTick);
        int startX = this.guiLeft + 8;
        int startY = this.guiTop - 28;
        if (this.leftWindowOpen && !this.leftWindowWidgets.isEmpty()) {
            graphics.blit(BACKGROUND_SIDE, startX - 50, startY, 0, 0, 48, 203);
        }
        graphics.blit(BACKGROUND_MAIN, startX, startY, 0, 0, 256, 256);
        for (ScrollableComponent component : this.scrollableComponents) {
            component.update();
        }
        if (this.dragonSpecies != null) {
            int totalExperience = ExperienceUtils.getTotalExperience((Player)this.minecraft.player);
            float progress = (float)(totalExperience - ExperienceUtils.getTotalExperience(this.minecraft.player.experienceLevel)) / (float)ExperienceUtils.getExperienceForLevelAfter(this.minecraft.player.experienceLevel);
            float leftExpBarProgress = Math.min(1.0f, Math.min(0.5f, progress) * 2.0f);
            int barYPos = startY + 10;
            int leftBarX = startX + 10;
            int rightBarX = startX + 136;
            graphics.blit(EXP_EMPTY, leftBarX, barYPos, 0.0f, 0.0f, 93, 6, 93, 6);
            graphics.blit(EXP_EMPTY, rightBarX, barYPos, 0.0f, 0.0f, 93, 6, 93, 6);
            graphics.blit(EXP_FULL, leftBarX, barYPos, 0.0f, 0.0f, (int)(93.0f * leftExpBarProgress), 6, 93, 6);
            if ((double)progress > 0.5) {
                float rightExpBarProgress = Math.min(1.0f, Math.min(0.5f, progress - 0.5f) * 2.0f);
                graphics.blit(EXP_FULL, rightBarX, barYPos, 0.0f, 0.0f, (int)(93.0f * rightExpBarProgress), 6, 93, 6);
            }
            int experienceModification = this.hoveredLevelButton == null || !this.hoveredLevelButton.canModifyLevel() ? 0 : this.hoveredLevelButton.getExperienceModification();
            int newExperience = totalExperience + experienceModification;
            int newLevel = Math.max(0, ExperienceUtils.getLevel(newExperience));
            if (experienceModification != 0) {
                float hoverProgress = (float)(newExperience - ExperienceUtils.getTotalExperience(newLevel)) / (float)ExperienceUtils.getExperienceForLevelAfter(newLevel);
                float leftExpBarHoverProgress = Math.min(0.5f, hoverProgress) * 2.0f;
                float rightExpBarHoverProgress = Math.min(0.5f, hoverProgress - leftExpBarHoverProgress / 2.0f) * 2.0f;
                if (experienceModification < 0) {
                    graphics.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                } else {
                    graphics.setColor(0.6f, 0.2f, 0.85f, 1.0f);
                }
                this.drawExperienceBar(graphics, barYPos, leftBarX, leftExpBarHoverProgress);
                if (rightExpBarHoverProgress > 0.0f) {
                    this.drawExperienceBar(graphics, barYPos, rightBarX, rightExpBarHoverProgress);
                }
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            int color = experienceModification == 0 ? 0x262626 : (experienceModification > 0 ? 5736495 : 0xAA0000);
            MutableComponent expectedLevel = Component.literal((String)String.valueOf(newLevel)).withColor(color);
            int expLevelXPos = (rightBarX + leftBarX) / 2 + 48 - this.minecraft.font.width((FormattedText)expectedLevel) / 2 - 1;
            int expLevelYPos = barYPos - 1;
            graphics.drawString(this.minecraft.font, (Component)expectedLevel, expLevelXPos, expLevelYPos, 0, false);
        }
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void drawExperienceBar(GuiGraphics guiGraphics, int y, int initialX, float hoverProgress) {
        guiGraphics.blit(EXP_FULL, initialX, y, 0.0f, 0.0f, (int)(93.0f * hoverProgress), 6, 93, 6);
    }

    public void renderBackground(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public void init() {
        int i;
        int size;
        int xSize = 256;
        int ySize = 256;
        this.guiLeft = (this.width - xSize) / 2;
        this.guiTop = (this.height - ySize / 2) / 2;
        this.leftWindowOpen = true;
        int startX = this.guiLeft - 2;
        int startY = this.guiTop + 2;
        TabButton.addTabButtonsToScreen(this, startX + 17, startY - 56, TabButton.TabButtonType.ABILITY_TAB);
        MagicData data = MagicData.getData((Player)this.minecraft.player);
        List<DragonAbilityInstance> actives = data.getActiveAbilities();
        List<DragonAbilityInstance> upgradablePassives = data.filterPassiveByUpgrade(UpgradeType.IS_MANUAL);
        List<DragonAbilityInstance> constantPassives = data.filterPassiveByUpgrade(UpgradeType.IS_MANUAL.negate());
        this.minecraft.player.registryAccess().registryOrThrow(DragonAbility.REGISTRY).getTag(DSDragonAbilityTags.ORDER).ifPresent(order -> {
            List list = ((HolderSet$NamedAccess)order).dragonSurvival$contents();
            Comparator<DragonAbilityInstance> comparator = Comparator.comparingInt(instance -> {
                int index = list.indexOf(instance.ability());
                return index == -1 ? Integer.MAX_VALUE : index;
            });
            actives.sort(comparator);
            upgradablePassives.sort(comparator);
            constantPassives.sort(comparator);
        });
        if (actives.size() % 4 != 0) {
            size = 4 - actives.size() % 4;
            for (i = 0; i < size; ++i) {
                actives.add(null);
            }
        }
        if (upgradablePassives.size() % 4 != 0) {
            size = 4 - upgradablePassives.size() % 4;
            for (i = 0; i < size; ++i) {
                upgradablePassives.add(null);
            }
        }
        if (constantPassives.size() % 4 != 0) {
            size = 4 - constantPassives.size() % 4;
            for (i = 0; i < size; ++i) {
                constantPassives.add(null);
            }
        }
        if (!actives.isEmpty()) {
            this.scrollableComponents.add(new AbilityColumnsComponent(this, this.guiLeft + 35, this.guiTop, 40, 20, 0.8f, 0.5f, actives));
        }
        if (!upgradablePassives.isEmpty()) {
            this.scrollableComponents.add(new AbilityColumnsComponent(this, this.guiLeft + 111, this.guiTop, 40, 20, 0.8f, 0.5f, upgradablePassives));
        }
        if (!constantPassives.isEmpty()) {
            this.scrollableComponents.add(new AbilityColumnsComponent(this, this.guiLeft + 186, this.guiTop, 40, 20, 0.8f, 0.5f, constantPassives));
        }
        if (!actives.isEmpty()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                AbilityButton widget = new AbilityButton(this.guiLeft - 35, this.guiTop + i2 * 40, data.fromSlot(i2), this, true, i2);
                this.addRenderableWidget((GuiEventListener)widget);
                this.leftWindowWidgets.add((AbstractWidget)widget);
                ((AbstractWidget)widget).visible = this.leftWindowOpen;
            }
            HelpButton leftHelpButton = new HelpButton(this.guiLeft - 24, startY - 25, 13, 13, HELP_ABILITY_ASSIGNMENT, INFO_MAIN, INFO_HOVER);
            this.addRenderableWidget((GuiEventListener)leftHelpButton);
            this.leftWindowWidgets.add((AbstractWidget)leftHelpButton);
            ((AbstractWidget)leftHelpButton).visible = this.leftWindowOpen;
            this.addRenderableWidget((GuiEventListener)new ClickHoverButton(this.guiLeft, this.guiTop + 69, 10, 17, 0, 1, 18, 18, (Component)Component.empty(), button -> {
                this.leftWindowOpen = !this.leftWindowOpen;
                for (AbstractWidget widget : this.leftWindowWidgets) {
                    widget.visible = this.leftWindowOpen;
                }
            }, LEFT_PANEL_ARROW_CLICK, LEFT_PANEL_ARROW_HOVER, LEFT_PANEL_ARROW_MAIN));
        }
        this.addRenderableWidget((GuiEventListener)new HelpButton(this.guiLeft + 122, startY + 131 + 25, 12, 12, HELP_PASSIVE_ACTIVE));
    }

    public void tick() {
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        if (this.dragonSpecies != data.species()) {
            this.dragonSpecies = data.species();
            this.clearWidgets();
            this.init();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

