/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonEmoteScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonInventoryScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSkinsScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSpeciesScreen;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.input.Keybind;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawMenuToggle;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.container.RequestOpenDragonInventory;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public class InventoryScreenHandler {
    @Translation(comments={"Open dragon inventory screen"})
    private static final String TOGGLE_DRAGON_INVENTORY = Translation.Type.GUI.wrap("inventory.toggle_dragon_inventory");
    @Translation(comments={"Open dragon altar"})
    private static final String TOGGLE_DRAGON_ALTAR = Translation.Type.GUI.wrap("inventory.toggle_dragon_altar");
    @Translation(key="dragon_inventory", type=Translation.Type.CONFIGURATION, comments={"If enabled the default inventory is replaced with a custom inventory"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="dragon_inventory")
    public static Boolean dragonInventory = true;
    @Translation(key="inventory_toggle", type=Translation.Type.CONFIGURATION, comments={"If enabled there will be a button that lets you switch between the custom and vanilla inventory"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"inventory"}, key="inventory_toggle")
    public static Boolean inventoryToggle = true;
    private static final ResourceLocation DS_LOGO = DragonSurvival.res("textures/gui/ds_logo.png");
    public static final ResourceLocation INVENTORY_TOGGLE_BUTTON = DragonSurvival.res("textures/gui/inventory_button.png");
    private static ExtendedButton altarOpenButton;
    private static ExtendedButton dragonInventoryButton;
    private static ExtendedButton creativeModeDragonInventoryButton;

    @SubscribeEvent
    public static void onOpenScreen(ScreenEvent.Opening openEvent) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!dragonInventory.booleanValue()) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        if (player == null || player.isCreative() || !DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        if (openEvent.getScreen() instanceof InventoryScreen) {
            openEvent.setCanceled(true);
            PacketDistributor.sendToServer((CustomPacketPayload)RequestOpenDragonInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void removeCraftingButtonInOtherCreativeModeTabs(ScreenEvent.Render.Pre renderEvent) {
        Screen screen = renderEvent.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            if (creativeModeDragonInventoryButton != null) {
                InventoryScreenHandler.creativeModeDragonInventoryButton.visible = screen2.isInventoryOpen();
            }
        }
    }

    @SubscribeEvent
    public static void hideOrShowAltarButton(ScreenEvent.Render.Pre event) {
        if (altarOpenButton != null && event.getScreen() instanceof InventoryScreen) {
            LocalPlayer player = Minecraft.getInstance().player;
            AltarData data = AltarData.getData((Player)player);
            InventoryScreenHandler.altarOpenButton.visible = !data.hasUsedAltar && !DragonStateProvider.isDragon((Entity)player);
        }
    }

    @SubscribeEvent
    public static void moveButtonsIfCraftingTabIsOpened(ScreenEvent.Render.Pre renderEvent) {
        Screen screen = renderEvent.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (altarOpenButton != null) {
                altarOpenButton.setPosition(screen2.getGuiLeft() + 130, screen2.height / 2 - 32);
            }
            if (dragonInventoryButton != null) {
                dragonInventoryButton.setPosition(screen2.getGuiLeft() + 128, screen2.height / 2 - 22);
            }
        }
    }

    @SubscribeEvent
    public static void addCraftingButton(ScreenEvent.Init.Post initGuiEvent) {
        InventoryScreen screen;
        Screen sc = initGuiEvent.getScreen();
        if (sc instanceof InventoryScreen) {
            screen = (InventoryScreen)sc;
            if (ServerConfig.allowDragonChoiceFromInventory.booleanValue()) {
                altarOpenButton = new ExtendedButton(screen.getGuiLeft() + 138, screen.height / 2 - 32, 32, 32, (Component)Component.empty(), button -> ClientProxy.openDragonAltar()){

                    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        guiGraphics.blit(DS_LOGO, this.getX(), this.getY(), 0.0f, 0.0f, 32, 32, 32, 32);
                    }
                };
                altarOpenButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_DRAGON_ALTAR)));
                initGuiEvent.addListener((GuiEventListener)altarOpenButton);
            }
        }
        if (!DragonStateProvider.isDragon((Entity)Minecraft.getInstance().player)) {
            return;
        }
        if (sc instanceof InventoryScreen) {
            screen = (InventoryScreen)sc;
            if (inventoryToggle.booleanValue()) {
                dragonInventoryButton = new ExtendedButton(screen.getGuiLeft() + 128, screen.height / 2 - 22, 20, 18, (Component)Component.empty(), p_onPress_1_ -> InventoryScreenHandler.openDragonInventory()){

                    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        float u = 21.0f;
                        float v = this.isHoveredOrFocused() ? 20.0f : 0.0f;
                        guiGraphics.blit(INVENTORY_TOGGLE_BUTTON, this.getX(), this.getY(), u, v, 20, 18, 256, 256);
                    }
                };
                dragonInventoryButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_DRAGON_INVENTORY)));
                initGuiEvent.addListener((GuiEventListener)dragonInventoryButton);
            }
        }
        if (sc instanceof CreativeModeInventoryScreen) {
            screen = (CreativeModeInventoryScreen)sc;
            if (inventoryToggle.booleanValue()) {
                creativeModeDragonInventoryButton = new ExtendedButton(screen.getGuiLeft() + 128 + 20, screen.height / 2 - 50, 20, 18, (Component)Component.empty(), p_onPress_1_ -> InventoryScreenHandler.openDragonInventory()){

                    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                        float u = 21.0f;
                        float v = this.isHoveredOrFocused() ? 20.0f : 0.0f;
                        guiGraphics.blit(INVENTORY_TOGGLE_BUTTON, this.getX(), this.getY(), u, v, 20, 18, 256, 256);
                    }
                };
                creativeModeDragonInventoryButton.setTooltip(Tooltip.create((Component)Component.translatable((String)TOGGLE_DRAGON_INVENTORY)));
                initGuiEvent.addListener((GuiEventListener)creativeModeDragonInventoryButton);
            }
        }
    }

    @SubscribeEvent
    public static void handleMouse(InputEvent.MouseButton.Pre event) {
        InventoryScreenHandler.handleInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), event.getAction());
    }

    @SubscribeEvent
    public static void handleKey(InputEvent.Key event) {
        InventoryScreenHandler.handleInput(InputConstants.getKey((int)event.getKey(), (int)event.getScanCode()), event.getAction());
    }

    private static void handleInput(InputConstants.Key input, int action) {
        if (action != 1) {
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)Minecraft.getInstance().player)) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            if (Keybind.DRAGON_INVENTORY.matches(input)) {
                PacketDistributor.sendToServer((CustomPacketPayload)RequestOpenDragonInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (Keybind.SKINS_MENU.matches(input)) {
                Minecraft.getInstance().setScreen((Screen)new DragonSkinsScreen());
            } else if (Keybind.ABILITY_MENU.matches(input)) {
                Minecraft.getInstance().setScreen((Screen)new DragonAbilityScreen());
            } else if (Keybind.SPECIES_MENU.matches(input)) {
                Minecraft.getInstance().setScreen((Screen)new DragonSpeciesScreen());
            } else if (Keybind.EMOTE_MENU.matches(input)) {
                Minecraft.getInstance().setScreen((Screen)new DragonEmoteScreen());
            }
        } else if (InventoryScreenHandler.isInventoryTab(screen)) {
            InventoryScreenHandler.switchOrClose(input, screen);
        }
    }

    private static void switchOrClose(InputConstants.Key input, Screen screen) {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        if (Keybind.DRAGON_INVENTORY.matches(input, true)) {
            if (screen instanceof DragonInventoryScreen) {
                player.closeContainer();
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)RequestOpenDragonInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (Keybind.ABILITY_MENU.matches(input, true)) {
            if (screen instanceof DragonAbilityScreen) {
                player.closeContainer();
            } else {
                Minecraft.getInstance().setScreen((Screen)new DragonAbilityScreen());
            }
        } else if (Keybind.SPECIES_MENU.matches(input, true)) {
            if (screen instanceof DragonSpeciesScreen) {
                player.closeContainer();
            } else {
                Minecraft.getInstance().setScreen((Screen)new DragonSpeciesScreen());
            }
        } else if (Keybind.SKINS_MENU.matches(input, true)) {
            if (screen instanceof DragonSkinsScreen) {
                player.closeContainer();
            } else {
                Minecraft.getInstance().setScreen((Screen)new DragonSkinsScreen());
            }
        } else if (Keybind.EMOTE_MENU.matches(input, true)) {
            if (screen instanceof DragonEmoteScreen) {
                player.closeContainer();
            } else {
                Minecraft.getInstance().setScreen((Screen)new DragonEmoteScreen());
            }
        }
    }

    public static void openDragonInventory() {
        DragonInventoryScreen.mouseX = Minecraft.getInstance().mouseHandler.xpos();
        DragonInventoryScreen.mouseY = Minecraft.getInstance().mouseHandler.ypos();
        PacketDistributor.sendToServer((CustomPacketPayload)RequestOpenDragonInventory.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClawInventoryData data = ClawInventoryData.getData((Player)Minecraft.getInstance().player);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonClawMenuToggle(data.isMenuOpen()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static boolean isInventoryTab(Screen screen) {
        return screen instanceof DragonInventoryScreen || screen instanceof DragonAbilityScreen || screen instanceof DragonSkinsScreen || screen instanceof DragonSpeciesScreen || screen instanceof DragonEmoteScreen;
    }
}

