/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class DragonEditorSlotButton
extends Button {
    private static final ResourceLocation SLOT_NUMBER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/slot_number_background.png");
    private final DragonEditorScreen screen;
    private final Function<Integer, Integer> setDragonSlotAction;
    private final Runnable action;
    private final int slot;

    public DragonEditorSlotButton(int x, int y, int slot, DragonEditorScreen screen, Runnable action) {
        super(x, y, 12, 12, (Component)Component.empty(), button -> {}, DEFAULT_NARRATION);
        this.slot = slot;
        this.screen = screen;
        this.action = action;
        this.setDragonSlotAction = selectedSlot -> {
            int prevSlot = this.screen.selectedSaveSlot;
            this.screen.selectedSaveSlot = selectedSlot;
            this.screen.update();
            DragonEditorScreen.HANDLER.recompileCurrentSkin();
            return prevSlot;
        };
    }

    public void onPress() {
        this.screen.actionHistory.add(new DragonEditorScreen.EditorAction<Integer>(this.setDragonSlotAction, this.slot));
        this.action.run();
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.active = this.visible = this.screen.showUi;
        if (this.screen.selectedSaveSlot == this.slot) {
            guiGraphics.blit(SLOT_NUMBER_BACKGROUND, this.getX(), this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (this.screen.selectedSaveSlot == this.slot) {
            TextRenderUtil.drawScaledText(guiGraphics, (float)this.getX() + 4.5f, (float)this.getY() + 3.5f, 1.0f, Integer.toString(this.slot), DyeColor.WHITE.getTextColor());
        } else {
            TextRenderUtil.drawScaledText(guiGraphics, (float)this.getX() + 4.5f, (float)this.getY() + 3.5f, 1.0f, Integer.toString(this.slot), DyeColor.GRAY.getTextColor());
        }
    }
}

