/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAltarScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.DietComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverDisableable;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.DietEntryCache;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarTypeButton
extends Button
implements HoverDisableable {
    @Translation(comments={"You have awakened from your sleep, and become a human."})
    private static final String CHOICE_HUMAN = Translation.Type.GUI.wrap("altar.choice.human");
    @Translation(comments={"\u00a77\u25a0 \u00a76Humans\u00a7r\u00a7f are the builders, travelers, and dreamers of this world.", "\u00a72\u25a0 Features:\u00a7f\u00a7r\u00a77 standard gameplay, varied diet, all items available for use.", "\u00a74\u25a0 Weakness:\u00a7r\u00a77 no flight, no progressive increase in HP, no magic."})
    private static final String HUMAN = Translation.Type.GUI.wrap("altar.info.human");
    private static final ResourceLocation HUMAN_BANNER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/custom/altar/human/altar_icon.png");
    private static final ResourceLocation LOCKED_BANNER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/altar/blocked_species.png");
    @Nullable
    public final UnlockableBehavior.SpeciesEntry speciesEntry;
    private final DragonAltarScreen parent;
    private boolean disableHover;
    private static final int MAX_SHOWN = 5;
    private int scroll;
    private boolean resetScroll;

    public AltarTypeButton(DragonAltarScreen parent, @Nullable UnlockableBehavior.SpeciesEntry speciesEntry, int x, int y) {
        super(x, y, 49, 147, (Component)Component.empty(), Button::onPress, DEFAULT_NARRATION);
        this.parent = parent;
        this.speciesEntry = speciesEntry;
        this.scroll = 0;
    }

    public void onPress() {
        if (this.speciesEntry == null) {
            this.initiateDragonForm(null);
        } else if (this.speciesEntry.isUnlocked()) {
            this.initiateDragonForm(this.speciesEntry.species());
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered() && this.isTop(mouseY)) {
            this.scroll += (int)(-scrollY);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered()) {
            this.handleTooltip(graphics, mouseX, mouseY);
        }
        graphics.renderOutline(this.getX() - 1, this.getY() - 1, this.width + 2, this.height + 2, Color.black.getRGB());
        RenderSystem.enableBlend();
        if (this.speciesEntry != null) {
            graphics.blit(((DragonSpecies)this.speciesEntry.species().value()).miscResources().altarBanner(), this.getX(), this.getY(), 0.0f, this.isHovered() ? 0.0f : 147.0f, 49, 147, 49, 294);
            if (this.speciesEntry.isUnlocked()) {
                StageResources.GrowthIcon growthIcon = StageResources.getGrowthIcon(this.speciesEntry.species(), (ResourceKey<DragonStage>)((DragonSpecies)this.speciesEntry.species().value()).getStartingStage(null).getKey());
                graphics.blit(this.isHovered() && this.isTop(mouseY) ? growthIcon.hoverIcon() : growthIcon.icon(), this.getX() + 1, this.getY() + 1, 0.0f, 0.0f, 18, 18, 18, 18);
            } else {
                graphics.blit(LOCKED_BANNER, this.getX(), this.getY(), 0.0f, 0.0f, 49, 147, 49, 147);
            }
        } else {
            graphics.blit(HUMAN_BANNER, this.getX(), this.getY(), 0.0f, this.isHovered() ? 0.0f : 147.0f, 49, 147, 49, 294);
        }
        RenderSystem.disableBlend();
    }

    private void handleTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        ArrayList<Either> components = new ArrayList<Either>();
        if ((this.speciesEntry == null || this.speciesEntry.isUnlocked()) && this.isTop(mouseY)) {
            if (this.resetScroll) {
                this.resetScroll = false;
                this.scroll = 0;
            }
            if (this.speciesEntry != null) {
                List<Item> diet = DietEntryCache.getDietItems(this.speciesEntry.species());
                this.scroll = diet.size() <= 5 ? 0 : Math.clamp((long)this.scroll, 0, diet.size() - 5);
                int max = Math.min(diet.size(), this.scroll + 5);
                MutableComponent shownFoods = Component.literal((String)("[" + Math.min(diet.size(), this.scroll + 5) + " / " + diet.size() + "]")).withStyle(ChatFormatting.DARK_GRAY);
                components.addFirst(Either.left((Object)Component.translatable((String)Translation.Type.DRAGON_SPECIES_ALTAR_DESCRIPTION.wrap(this.speciesEntry.species().getKey().location()), (Object[])new Object[]{shownFoods})));
                for (int i = this.scroll; i < max; ++i) {
                    components.add(Either.right((Object)new DietComponent(this.speciesEntry.species(), diet.get(i))));
                }
            } else {
                components.addFirst(Either.left((Object)Component.translatable((String)HUMAN)));
            }
        } else {
            String key;
            this.resetScroll = true;
            if (this.speciesEntry != null && !this.speciesEntry.isUnlocked() && I18n.exists((String)(key = Translation.Type.DRAGON_SPECIES_LOCKED.wrap(this.speciesEntry.species())))) {
                components.addFirst(Either.left((Object)Component.translatable((String)key)));
            }
        }
        if (!components.isEmpty()) {
            graphics.renderComponentTooltipFromElements(Minecraft.getInstance().font, components, mouseX, mouseY, ItemStack.EMPTY);
        }
    }

    private boolean isTop(double mouseY) {
        return mouseY > (double)(this.getY() + 6) && mouseY < (double)(this.getY() + 26);
    }

    public void initiateDragonForm(@Nullable Holder<DragonSpecies> species) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (species == null) {
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)CHOICE_HUMAN));
            player.level().playSound((Player)player, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.7f);
            DragonStateHandler data = DragonStateProvider.getData((Player)player);
            data.revertToHumanForm((Player)player, false);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncAltarCooldown(Functions.secondsToTicks(ServerConfig.altarUsageCooldown.intValue())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncComplete(player.getId(), data.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.closeContainer();
        } else {
            ClientProxy.openDragonEditor((ResourceKey<DragonSpecies>)species.getKey(), true);
        }
    }

    public boolean isHovered() {
        return !this.disableHover && this.visible && super.isHovered();
    }

    public boolean isFocused() {
        return !this.disableHover && this.visible && super.isFocused();
    }

    @Override
    public void disableHover() {
        this.disableHover = true;
    }

    @Override
    public void enableHover() {
        this.disableHover = false;
    }
}

