/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class GrowthCrystalButton
extends ExtendedButton {
    public static final int MAX_LINES_SHOWN = 10;
    private final Holder<DragonStage> stage;
    private List<FormattedCharSequence> tooltip = List.of();
    private int scrollAmount;
    private int maxScroll = Integer.MAX_VALUE;

    public GrowthCrystalButton(int xPos, int yPos, Holder<DragonStage> stage) {
        super(xPos, yPos, 8, 16, (Component)Component.empty(), action -> {});
        this.stage = stage;
        this.updateTooltip();
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        DragonStateHandler handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player);
        double percentageFull = ((DragonStage)this.stage.value()).getProgress(handler.getGrowth());
        if (percentageFull > 1.0) {
            graphics.blit(((DragonSpecies)handler.species().value()).miscResources().growthCrystal().full(), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 8, 16);
            return;
        }
        graphics.blit(((DragonSpecies)handler.species().value()).miscResources().growthCrystal().empty(), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 8, 16);
        if (percentageFull > 0.0) {
            int scissorHeight = (int)(percentageFull * (double)this.height);
            graphics.enableScissor(this.getX(), this.getY() + (this.height - scissorHeight), this.getX() + this.width, this.getY() + this.height);
            graphics.blit(((DragonSpecies)handler.species().value()).miscResources().growthCrystal().full(), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 8, 16);
            graphics.disableScissor();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered()) {
            int oldScrollAmount = this.scrollAmount;
            this.scrollAmount = Math.clamp((long)(this.scrollAmount + (int)(-scrollY)), 0, this.maxScroll());
            if (oldScrollAmount != this.scrollAmount) {
                this.updateTooltip();
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isHovered() {
        boolean isHovered = super.isHovered();
        if (!isHovered && this.scrollAmount > 0) {
            this.scrollAmount = 0;
            this.updateTooltip();
        }
        if (isHovered) {
            Minecraft.getInstance().screen.setTooltipForNextRenderPass(this.tooltip);
        }
        return isHovered;
    }

    private void updateTooltip() {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        components.add(Component.translatable((String)LangKey.GROWTH_STAGE).append(DragonStage.translatableName((ResourceKey<DragonStage>)Objects.requireNonNull(this.stage.getKey()))));
        components.add(Component.translatable((String)LangKey.GROWTH_STARTING_AMOUNT, (Object[])new Object[]{((DragonStage)this.stage.value()).growthRange().min()}));
        components.add(Component.translatable((String)LangKey.GROWTH_MAX_AMOUNT, (Object[])new Object[]{((DragonStage)this.stage.value()).growthRange().max()}));
        components.add(Component.translatable((String)LangKey.GROWTH_TIME, (Object[])new Object[]{((DragonStage)this.stage.value()).getTimeToGrowFormatted(false)}));
        ((DragonStage)this.stage.value()).destructionData().ifPresent(data -> {
            components.add(Component.translatable((String)LangKey.GROWTH_CAN_DESTROY_BLOCKS, (Object[])new Object[]{data.blockDestructionGrowth()}));
            components.add(Component.translatable((String)LangKey.GROWTH_CAN_CRUSH_ENTITIES, (Object[])new Object[]{data.crushingGrowth()}));
        });
        components.add(Component.translatable((String)LangKey.GROWTH_MODIFIERS_AT_MAX_GROWTH));
        for (Modifier modifier : ((DragonStage)this.stage.value()).modifiers()) {
            MutableComponent name = modifier.getFormattedDescription((int)((DragonStage)this.stage.value()).growthRange().max(), true);
            components.add(name);
        }
        MutableComponent tooltip = Component.empty();
        for (int i = 0; i < components.size(); ++i) {
            tooltip = i == components.size() - 1 ? tooltip.append((Component)components.get(i)) : tooltip.append((Component)components.get(i)).append("\n");
        }
        List lines = Minecraft.getInstance().font.split((FormattedText)tooltip, 200);
        ArrayList<FormattedCharSequence> shownTooltip = new ArrayList<FormattedCharSequence>();
        this.maxScroll = lines.size();
        for (int line = this.scrollAmount = Math.clamp((long)this.scrollAmount, 0, this.maxScroll()); line < lines.size() && line - this.scrollAmount != 10; ++line) {
            shownTooltip.add((FormattedCharSequence)lines.get(line));
        }
        this.tooltip = shownTooltip;
    }

    private int maxScroll() {
        return Math.max(0, this.maxScroll - 10);
    }
}

