/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ClickHoverButton;
import by.dragonsurvivalteam.dragonsurvival.network.magic.AttemptManualUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ExperiencePointsUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.util.ExperienceUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class LevelButton
extends ClickHoverButton {
    private static final ResourceLocation DOWNGRADE_CLICK = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_click.png");
    private static final ResourceLocation DOWNGRADE_HOVER = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_hover.png");
    private static final ResourceLocation DOWNGRADE_MAIN = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_main.png");
    public static final ResourceLocation UPGRADE_CLICK = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_click.png");
    private static final ResourceLocation UPGRADE_HOVER = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_hover.png");
    private static final ResourceLocation UPGRADE_MAIN = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_main.png");
    private static final int WIDTH = 9;
    private static final int HEIGHT = 14;
    private final Type type;
    private final DragonAbilityInstance ability;

    public void resetDimensions() {
        this.width = 9;
        this.height = 14;
    }

    public LevelButton(Type type, DragonAbilityInstance ability, int xPos, int yPos) {
        super(xPos, yPos, 9, 14, 0, 0, 16, 16, (Component)Component.empty(), button -> {
            switch (type.ordinal()) {
                case 0: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new AttemptManualUpgrade(ability.key(), ExperiencePointsUpgrade.Type.DOWNGRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case 1: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new AttemptManualUpgrade(ability.key(), ExperiencePointsUpgrade.Type.UPGRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }, type.click, type.hover, type.main);
        this.type = type;
        this.ability = ability;
    }

    public int getExperienceModification() {
        ExperiencePointsUpgrade.Type upgradeType = this.type == Type.UPGRADE ? ExperiencePointsUpgrade.Type.UPGRADE : ExperiencePointsUpgrade.Type.DOWNGRADE;
        return MagicData.getData((Player)Minecraft.getInstance().player).getCost((Player)Minecraft.getInstance().player, this.ability.key(), upgradeType);
    }

    public boolean canModifyLevel() {
        return this.isHovered() && this.canModify();
    }

    public boolean isMinOrMaxLevel() {
        UpgradeType<?> upgrade = this.ability.value().upgrade().get();
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.ability.level() == 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> this.ability.level() == upgrade.maxLevel();
        };
    }

    public boolean canModify() {
        if (this.isMinOrMaxLevel()) {
            return false;
        }
        if (this.type == Type.DOWNGRADE) {
            return true;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        return ExperienceUtils.getTotalExperience((Player)Minecraft.getInstance().player) >= Math.abs(MagicData.getData((Player)player).getCost((Player)player, this.ability.key(), ExperiencePointsUpgrade.Type.UPGRADE));
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isMinOrMaxLevel()) {
            return;
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof DragonAbilityScreen) {
            DragonAbilityScreen abilityScreen = (DragonAbilityScreen)screen;
            if (this.isHovered()) {
                abilityScreen.hoveredLevelButton = this;
            }
        }
    }

    public void onPress() {
        if (this.canModify()) {
            super.onPress();
        }
    }

    public static enum Type {
        DOWNGRADE(DOWNGRADE_CLICK, DOWNGRADE_HOVER, DOWNGRADE_MAIN),
        UPGRADE(UPGRADE_CLICK, UPGRADE_HOVER, UPGRADE_MAIN);

        public final ResourceLocation click;
        public final ResourceLocation hover;
        public final ResourceLocation main;

        private Type(ResourceLocation click, ResourceLocation hover, ResourceLocation main) {
            this.click = click;
            this.hover = hover;
            this.main = main;
        }
    }
}

