/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class HelpButton
extends ExtendedButton {
    private static final ResourceLocation MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/info_main.png");
    private static final ResourceLocation HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/ability_screen/info_hover.png");
    private static final int TEXTURE_SIZE = 16;
    private static final int UV = 13;
    private final ResourceLocation hover;
    private final ResourceLocation main;
    private List<Either<FormattedText, TooltipComponent>> tooltip;

    public HelpButton(int x, int y, int sizeX, int sizeY, String tooltip) {
        this(x, y, sizeX, sizeY, new ArrayList<Either<FormattedText, TooltipComponent>>(List.of(Either.left((Object)Component.translatable((String)tooltip)))));
    }

    public HelpButton(int x, int y, int sizeX, int sizeY, List<Either<FormattedText, TooltipComponent>> tooltip) {
        super(x, y, sizeX, sizeY, (Component)Component.empty(), action -> {});
        this.tooltip = tooltip;
        this.main = MAIN;
        this.hover = HOVER;
    }

    public HelpButton(int x, int y, int sizeX, int sizeY, String tooltip, ResourceLocation main, ResourceLocation hover) {
        super(x, y, sizeX, sizeY, (Component)Component.empty(), action -> {});
        this.tooltip = new ArrayList<Either>(List.of(Either.left((Object)Component.translatable((String)tooltip))));
        this.main = main;
        this.hover = hover;
    }

    public void setTooltip(List<Either<FormattedText, TooltipComponent>> tooltip) {
        this.tooltip = tooltip;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation resource;
        if (this.isHovered()) {
            graphics.renderComponentTooltipFromElements(Minecraft.getInstance().font, this.tooltip, mouseX, mouseY, ItemStack.EMPTY);
            resource = this.hover;
        } else {
            resource = this.main;
        }
        graphics.blit(resource, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 13, 13, 16, 16);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }
}

