/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ColorPickerButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BackgroundColorSelectorComponent
extends AbstractContainerEventHandler
implements Renderable {
    public static final int BACKGROUND_COLOR = -14935012;
    public static final int INNER_BORDER_COLOR = new Color(0x78787880, true).getRGB();
    public static final ResourceLocation COLOR_RESET_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_reset_hover.png");
    public static final ResourceLocation COLOR_RESET_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/color_reset_main.png");
    public final ColorPickerButton colorPicker;
    public final HoverButton resetButton;
    private final int x;
    private final int y;
    private final int xSize;
    private final int ySize;
    public boolean visible;

    public BackgroundColorSelectorComponent(DragonEditorScreen screen, int x, int y, int xSize, int ySize) {
        this.x = x;
        this.y = y;
        this.xSize = xSize;
        this.ySize = ySize;
        Color defaultColor = new Color(screen.backgroundColor);
        float alpha = (float)(screen.backgroundColor >> 24 & 0xFF) / 255.0f;
        this.colorPicker = new ColorPickerButton(x + 5, y + 18, xSize - 8, ySize - 26, defaultColor, color -> {
            Color c1 = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha);
            screen.backgroundColor = c1.getRGB();
        });
        this.resetButton = new HoverButton(x + 5, y - 8, 24, 24, 24, 24, COLOR_RESET_MAIN, COLOR_RESET_HOVER, button -> this.colorPicker.resetColor());
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return this.visible && pMouseY >= (double)this.y - 18.0 && pMouseY <= (double)this.y + (double)this.ySize + 3.0 && pMouseX >= (double)this.x && pMouseX <= (double)this.x + (double)this.xSize;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)((Object)this.colorPicker), (Object)this.resetButton);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.visible) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.fill(this.x + 2, this.y - 10, this.x + 32, this.y + 35, -14935012);
            guiGraphics.renderOutline(this.x + 2, this.y - 11, 30, 41, Color.black.getRGB());
            guiGraphics.renderOutline(this.x + 3, this.y - 10, 28, 39, INNER_BORDER_COLOR);
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.fill(this.x, this.y + 15, this.x + this.xSize, this.y + this.ySize - 5, -14935012);
            guiGraphics.renderOutline(this.x, this.y + 14, this.xSize, this.ySize - 18, Color.black.getRGB());
            guiGraphics.renderOutline(this.x + 1, this.y + 15, this.xSize - 2, this.ySize - 20, INNER_BORDER_COLOR);
            this.colorPicker.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            this.resetButton.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
            guiGraphics.pose().popPose();
        }
    }
}

