/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DragonUIRenderComponent
extends AbstractContainerEventHandler
implements Renderable {
    private final Screen screen;
    private final Supplier<DragonEntity> getter;
    public float yRot;
    public float xRot;
    public float xOffset;
    public float yOffset;
    public float zoom;
    public int x;
    public int y;
    public int width;
    public int height;

    public DragonUIRenderComponent(Screen screen, int x, int y, int xSize, int ySize, Supplier<DragonEntity> dragonGetter) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = xSize;
        this.height = ySize;
        this.getter = dragonGetter;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.isMouseOver(pMouseX, pMouseY)) {
            this.screen.setFocused((GuiEventListener)this);
        }
        float scale = this.zoom;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(this.yRot * 10.0f));
        quaternion.rotateY((float)Math.toRadians(180.0f - this.xRot * 10.0f));
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)this.x + (float)this.width / 2.0f + this.xOffset), (float)((float)(this.y + this.height - 30) + this.yOffset), (float)((int)scale), (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)quaternion, null, (LivingEntity)this.getter.get());
        guiGraphics.pose().popPose();
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.x && pMouseX <= (double)(this.x + this.width) && pMouseY >= (double)this.y && pMouseY <= (double)(this.y + this.height);
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of();
    }

    public boolean mouseDragged(double x1, double y1, int rightClick, double x2, double y2) {
        if (this.isMouseOver(x1, y1)) {
            if (rightClick == 0) {
                this.xRot -= (float)(x2 / 5.0);
                this.yRot -= (float)(y2 / 5.0);
            } else if (rightClick == 1) {
                this.xOffset += (float)x2;
                this.yOffset += (float)y2;
                this.xOffset = Mth.clamp((float)this.xOffset, (float)(-((float)this.width / 2.0f)), (float)((float)this.width / 2.0f));
                this.yOffset = Mth.clamp((float)this.yOffset, (float)(-((float)this.height / 2.0f)), (float)((float)this.height / 2.0f));
            }
            return true;
        }
        this.setDragging(false);
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isMouseOver(pMouseX, pMouseY)) {
            this.zoom += (float)pScrollY * 2.0f;
            this.zoom = Mth.clamp((float)this.zoom, (float)10.0f, (float)100.0f);
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }
}

