/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.BlockVision;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.FrustumAccess;
import by.dragonsurvivalteam.dragonsurvival.registry.DSParticles;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.BlockVisionData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class BlockVisionHandler {
    private static final SpawnParticlesEffect.PositionSource PARTICLE_POSITION = SpawnParticlesEffect.inBoundingBox();
    private static final int EXTENDED_SEARCH_RANGE = 16;
    private static Cache<LevelChunkSection, Boolean[]> CHUNK_CACHE;
    private static final List<Data> RENDER_DATA;
    private static final List<Data> SEARCH_RESULT;
    private static final List<BlockPos> REMOVAL;
    private static BlockVisionData vision;
    private static Vec3 lastScanCenter;
    private static boolean isSearching;
    private static boolean hasPendingUpdate;

    @SubscribeEvent
    public static void handleBlockVision(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        vision = player.getExistingData(DSDataAttachments.BLOCK_VISION).orElse(null);
        if (vision == null) {
            BlockVisionHandler.clear();
            return;
        }
        BlockVisionHandler.initCache();
        if (!isSearching && hasPendingUpdate) {
            RENDER_DATA.clear();
            RENDER_DATA.addAll(SEARCH_RESULT);
            SEARCH_RESULT.clear();
            REMOVAL.clear();
            hasPendingUpdate = false;
        }
        if (!isSearching && BlockVisionHandler.isOutsideRange(vision.getRange(null))) {
            lastScanCenter = player.position();
            isSearching = true;
            Util.backgroundExecutor().submit(() -> {
                BlockVisionHandler.collect((Player)player, vision.getRange(null) + 16);
                isSearching = false;
                hasPendingUpdate = true;
            });
        }
        if (RENDER_DATA.isEmpty()) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        pose.pushPose();
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        pose.mulPose(event.getModelViewMatrix());
        pose.translate(-camera.x(), -camera.y(), -camera.z());
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableDepthTest();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        for (int index = 0; index < RENDER_DATA.size(); ++index) {
            Data data = RENDER_DATA.get(index);
            if (BlockVisionHandler.wasRemoved(data)) {
                RENDER_DATA.remove(index);
                --index;
                continue;
            }
            if (data.range() == 0 || !data.isInRange(player.getEyePosition(), data.range()) || !((FrustumAccess)event.getFrustum()).dragonSurvival$cubeInFrustum(data.x(), data.y(), data.z(), data.x() + 1.0f, data.y() + 1.0f, data.z() + 1.0f)) continue;
            if (data.displayType() == BlockVision.DisplayType.OUTLINE) {
                data.render((VertexConsumer)buffer, pose.last());
                continue;
            }
            if (Minecraft.getInstance().isPaused() || data.displayType() != BlockVision.DisplayType.PARTICLES || player.tickCount % 10 != 0) continue;
            double xPos = PARTICLE_POSITION.getCoordinate((double)data.x(), (double)data.x() + 0.5, 2.0f, player.getRandom());
            double yPos = PARTICLE_POSITION.getCoordinate((double)data.y(), (double)data.y() + 0.5, 2.0f, player.getRandom());
            double zPos = PARTICLE_POSITION.getCoordinate((double)data.z(), (double)data.z() + 0.5, 2.0f, player.getRandom());
            player.level().addParticle((ParticleOptions)DSParticles.GLOW.get(), xPos, yPos, zPos, (double)BuiltInRegistries.BLOCK.getId((Object)data.block()), 0.0, 0.0);
        }
        MeshData meshData = buffer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        pose.popPose();
        RenderSystem.enableDepthTest();
        RenderType.cutout().clearRenderState();
    }

    @SubscribeEvent
    public static void clearData(EntityLeaveLevelEvent event) {
        if (event.getEntity() == Minecraft.getInstance().player) {
            BlockVisionHandler.clear();
        }
    }

    public static void updateEntry(BlockPos position, BlockState oldState, BlockState newState) {
        int range;
        if (oldState == null || newState == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || vision == null) {
            return;
        }
        Block newBlock = newState.getBlock();
        if (oldState.getBlock() == newBlock) {
            return;
        }
        int searchRange = vision.getRange(null);
        if (lastScanCenter != null && player.position().distanceToSqr(lastScanCenter) - 256.0 > (double)(searchRange * searchRange)) {
            return;
        }
        if (!RENDER_DATA.isEmpty() && vision.getRange(oldState.getBlock()) != 0) {
            REMOVAL.add(position);
        }
        if ((range = vision.getRange(newBlock)) != 0) {
            RENDER_DATA.add(new Data(newBlock, range, vision.getDisplayType(newBlock), position.getX(), position.getY(), position.getZ()));
        }
    }

    private static void collect(Player player, int searchRange) {
        BlockPos startPosition = player.blockPosition();
        ChunkPos currentChunkPosition = new ChunkPos(startPosition);
        LevelChunk currentChunk = null;
        int minChunkX = startPosition.getX() - searchRange;
        int maxChunkX = startPosition.getX() + searchRange;
        int minChunkY = Math.max(player.level().getMinBuildHeight(), startPosition.getY() - searchRange);
        int maxChunkY = Math.min(player.level().getMaxBuildHeight(), startPosition.getY() + searchRange);
        int minChunkZ = startPosition.getZ() - searchRange;
        int maxChunkZ = startPosition.getZ() + searchRange;
        boolean foundSection = false;
        BlockPos.MutableBlockPos mutablePosition = BlockPos.ZERO.mutable();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                int sectionX = SectionPos.blockToSectionCoord((int)x);
                int sectionZ = SectionPos.blockToSectionCoord((int)z);
                if (currentChunk == null || currentChunkPosition.x != sectionX || currentChunkPosition.z != sectionZ) {
                    currentChunkPosition = new ChunkPos(sectionX, sectionZ);
                    currentChunk = player.level().getChunk(sectionX, sectionZ);
                }
                foundSection = false;
                for (int y = maxChunkY; y >= minChunkY; --y) {
                    int sectionIndex = currentChunk.getSectionIndex(y);
                    LevelChunkSection section = currentChunk.getSection(sectionIndex);
                    mutablePosition.set(x, y, z);
                    if (foundSection || BlockVisionHandler.containsOres(currentChunk, section, sectionIndex)) {
                        foundSection = true;
                        BlockState state = BlockVisionHandler.getState(currentChunk, (BlockPos)mutablePosition);
                        if (state.isAir()) continue;
                        Block block = state.getBlock();
                        int range = vision.getRange(block);
                        if (range != 0) {
                            SEARCH_RESULT.add(new Data(block, range, vision.getDisplayType(block), x, y, z));
                        }
                    }
                    if (foundSection || y == minChunkY) continue;
                    y = Math.max(minChunkY, SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)y)));
                }
                if (foundSection || z == maxChunkZ) continue;
                z = Math.min(maxChunkZ, SectionPos.sectionToBlockCoord((int)(SectionPos.blockToSectionCoord((int)z) + 1)));
            }
            if (foundSection || x == maxChunkX) continue;
            x = Math.min(maxChunkX, SectionPos.sectionToBlockCoord((int)(SectionPos.blockToSectionCoord((int)x) + 1)));
        }
    }

    private static boolean isWithin(BlockPos position, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        return position.getX() >= xMin && position.getX() <= xMax && position.getY() >= yMin && position.getY() <= yMax && position.getZ() >= zMin && position.getZ() <= zMax;
    }

    private static boolean containsOres(LevelChunk chunk, LevelChunkSection section, int sectionIndex) {
        Boolean[] cachedSection = (Boolean[])CHUNK_CACHE.getIfPresent((Object)section);
        if (cachedSection == null || cachedSection[sectionIndex] == null) {
            boolean containsRelevantBlock;
            boolean bl = containsRelevantBlock = !section.hasOnlyAir() && section.maybeHas(state -> vision.getRange(state.getBlock()) != 0);
            if (cachedSection == null) {
                cachedSection = new Boolean[chunk.getSections().length];
            }
            cachedSection[sectionIndex] = containsRelevantBlock;
            CHUNK_CACHE.put((Object)section, (Object)cachedSection);
        }
        return cachedSection[sectionIndex];
    }

    private static BlockState getState(LevelChunk chunk, BlockPos position) {
        if (BlockVisionHandler.isWithin(position, chunk.getPos().getMinBlockX(), position.getY(), chunk.getPos().getMinBlockZ(), chunk.getPos().getMaxBlockX(), position.getY(), chunk.getPos().getMaxBlockZ())) {
            return chunk.getBlockState(position);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        return player.level().getBlockState(position);
    }

    private static boolean wasRemoved(Data data) {
        for (int i = 0; i < REMOVAL.size(); ++i) {
            BlockPos position = REMOVAL.get(i);
            if ((float)position.getX() != data.x() || (float)position.getY() != data.y() || (float)position.getZ() != data.z()) continue;
            REMOVAL.remove(i);
            return true;
        }
        return false;
    }

    private static boolean isOutsideRange(int visibleRange) {
        if (lastScanCenter == null) {
            return true;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 currentPosition = player.position();
        float halfRange = (float)visibleRange / 2.0f;
        return currentPosition.distanceToSqr(lastScanCenter) > (double)(halfRange * halfRange);
    }

    private static void drawLines(VertexConsumer buffer, PoseStack.Pose pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color) {
        BlockVisionHandler.drawLine(buffer, pose, minX, minY, minZ, maxX, minY, minZ, 1, 0, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, minY, minZ, minX, maxY, minZ, 0, 1, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, minY, minZ, minX, minY, maxZ, 0, 0, 1, color);
        BlockVisionHandler.drawLine(buffer, pose, maxX, minY, minZ, maxX, maxY, minZ, 0, 1, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, maxX, maxY, minZ, minX, maxY, minZ, -1, 0, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, maxY, minZ, minX, maxY, maxZ, 0, 0, 1, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, maxY, maxZ, minX, minY, maxZ, 0, -1, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, minY, maxZ, maxX, minY, maxZ, 1, 0, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, maxX, minY, maxZ, maxX, minY, minZ, 0, 0, -1, color);
        BlockVisionHandler.drawLine(buffer, pose, minX, maxY, maxZ, maxX, maxY, maxZ, 1, 0, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, maxX, minY, maxZ, maxX, maxY, maxZ, 0, 1, 0, color);
        BlockVisionHandler.drawLine(buffer, pose, maxX, maxY, minZ, maxX, maxY, maxZ, 0, 0, 1, color);
    }

    private static void drawLine(VertexConsumer buffer, PoseStack.Pose pose, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int normalX, int normalY, int normalZ, int color) {
        buffer.addVertex(pose, fromX, fromY, fromZ).setColor(color).setNormal(pose, (float)normalX, (float)normalY, (float)normalZ);
        buffer.addVertex(pose, toX, toY, toZ).setColor(color).setNormal(pose, (float)normalX, (float)normalY, (float)normalZ);
    }

    private static void clear() {
        if (CHUNK_CACHE == null) {
            return;
        }
        RENDER_DATA.clear();
        SEARCH_RESULT.clear();
        REMOVAL.clear();
        lastScanCenter = null;
        isSearching = false;
        hasPendingUpdate = false;
        CHUNK_CACHE.invalidateAll();
        CHUNK_CACHE = null;
    }

    private static void initCache() {
        if (CHUNK_CACHE == null) {
            CHUNK_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).concurrencyLevel(1).build();
        }
    }

    static {
        RENDER_DATA = new ArrayList<Data>();
        SEARCH_RESULT = new ArrayList<Data>();
        REMOVAL = new ArrayList<BlockPos>();
    }

    private record Data(Block block, int range, BlockVision.DisplayType displayType, float x, float y, float z) {
        public boolean isInRange(Vec3 position, int visibleRange) {
            return position.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= (double)(visibleRange * visibleRange);
        }

        public void render(VertexConsumer buffer, PoseStack.Pose pose) {
            BlockVisionHandler.drawLines(buffer, pose, this.x, this.y, this.z, this.x + 1.0f, this.y + 1.0f, this.z + 1.0f, vision.getColor(this.block));
        }
    }
}

