/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonArmorRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonGlowLayerRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonItemRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.HunterHandler;
import by.dragonsurvivalteam.dragonsurvival.compat.Compat;
import by.dragonsurvivalteam.dragonsurvival.compat.ModCheck;
import by.dragonsurvivalteam.dragonsurvival.compat.sophisticatedBackpacks.DragonBackpackRenderLayer;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.Color;

public class DragonRenderer
extends GeoEntityRenderer<DragonEntity> {
    public static final Map<Integer, Map<String, Vec3>> BONE_POSITIONS = new HashMap<Integer, Map<String, Vec3>>();
    private static final List<String> BONES = List.of("BreathSource");
    private static final Color RENDER_COLOR = Color.ofRGB((int)255, (int)255, (int)255);
    private static final Color TRANSPARENT_RENDER_COLOR = Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
    public ResourceLocation glowTexture;
    public boolean isRenderingLayer;
    public boolean shouldRenderLayers = true;
    private boolean resetNeckVisibility;

    public DragonRenderer(EntityRendererProvider.Context context, GeoModel<DragonEntity> model) {
        super(context, model);
        this.getRenderLayers().add(new DragonGlowLayerRenderer(this));
        this.getRenderLayers().add(new DragonArmorRenderLayer(this));
        this.getRenderLayers().add(new DragonItemRenderLayer((GeoRenderer<DragonEntity>)this, (bone, animatable) -> {
            if (bone.getName().equals(ClientDragonRenderer.renderItemsInMouth != false ? "RightItem_jaw" : "RightItem")) {
                return animatable.getMainHandItem();
            }
            if (bone.getName().equals(ClientDragonRenderer.renderItemsInMouth != false ? "LeftItem_jaw" : "LeftItem")) {
                return animatable.getOffhandItem();
            }
            return null;
        }, (bone, animatable) -> null));
        if (ModCheck.isModLoaded("sophisticatedbackpacks")) {
            this.getRenderLayers().add(new DragonBackpackRenderLayer(this));
        }
    }

    public static Vec3 getBonePosition(Player player, String name) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return Vec3.ZERO;
        }
        Map<String, Vec3> positions = BONE_POSITIONS.get(dragon.getId());
        if (positions == null) {
            return Vec3.ZERO;
        }
        return positions.getOrDefault(name, Vec3.ZERO);
    }

    public void preRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        Minecraft.getInstance().getProfiler().push("player_dragon");
        Player player = animatable.getPlayer();
        this.resetNeckVisibility = model.getBone("Neck").map(bone -> {
            if (bone.isHidden()) {
                return false;
            }
            if (animatable.isInInventory || Compat.displayNeck()) {
                return false;
            }
            if (!RenderingUtils.isFirstPerson(player)) {
                return false;
            }
            bone.setHidden(true);
            return true;
        }).orElse(false);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void postRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        super.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        if (this.resetNeckVisibility) {
            model.getBone("Neck").ifPresent(bone -> bone.setHidden(false));
            this.resetNeckVisibility = false;
        }
        BONES.forEach(name -> model.getBone(name).ifPresent(bone -> {
            Vector3d worldPosition = bone.getWorldPosition();
            Vec3 position = new Vec3(worldPosition.x(), worldPosition.y(), worldPosition.z()).subtract(ClientDragonRenderer.getModelOffset(animatable, 1.0f));
            BONE_POSITIONS.computeIfAbsent(animatable.getId(), key -> new HashMap()).put(bone.getName(), position);
        }));
        Minecraft.getInstance().getProfiler().pop();
    }

    public void actuallyRender(PoseStack poseStack, DragonEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        Player player = animatable.getPlayer();
        if (player == null || player.isSpectator() || player.isInvisibleTo((Player)Minecraft.getInstance().player)) {
            return;
        }
        poseStack.pushPose();
        this.setupRender(animatable, player, poseStack, partialTick);
        DragonStateHandler handler = DragonStateProvider.getData(player);
        boolean hasWings = !((DragonBody)handler.body().value()).canHideWings() || handler.getCurrentStageCustomization().wings;
        for (String boneName : ((DragonBody)handler.body().value()).bonesToHideForToggle()) {
            model.getBone(boneName).ifPresent(bone -> bone.setHidden(!hasWings));
        }
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        handler.refreshBody = false;
        poseStack.popPose();
    }

    private void setupRender(DragonEntity dragon, Player player, PoseStack pose, float partialTick) {
        MovementData movement = MovementData.getData((Entity)player);
        Vec3 offset = this.getRenderOffset(dragon, partialTick);
        pose.translate(-offset.x(), -offset.y(), -offset.z());
        pose.mulPose(Axis.YN.rotationDegrees((float)movement.bodyYaw));
        if (ServerFlightHandler.isGliding(player) || player.isPassenger() && DragonStateProvider.isDragon(player.getVehicle()) && ServerFlightHandler.isGliding((Player)player.getVehicle())) {
            pose.mulPose(Axis.XN.rotationDegrees(dragon.prevXRot));
            pose.mulPose(Axis.ZP.rotation(dragon.prevZRot));
        }
    }

    public Color getRenderColor(DragonEntity animatable, float partialTick, int packedLight) {
        boolean isInvisible = animatable.isInvisible();
        Color color = isInvisible && !animatable.isInvisibleTo((Player)Minecraft.getInstance().player) ? TRANSPARENT_RENDER_COLOR : RENDER_COLOR;
        return HunterHandler.modifyAlpha((Entity)animatable.getPlayer(), color);
    }

    @NotNull
    public Vec3 getRenderOffset(@NotNull DragonEntity dragon, float partialTicks) {
        return ClientDragonRenderer.getModelOffset(dragon, partialTicks);
    }
}

