/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.util;

import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;

@EventBusSubscriber(value={Dist.CLIENT})
public class AnimationTickTimer {
    public static final CopyOnWriteArrayList<AnimationTickTimer> TIMERS = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<String, Double> animationTimes = new ConcurrentHashMap();

    @SubscribeEvent
    public static void onTick(RenderFrameEvent.Pre event) {
        for (AnimationTickTimer timer : TIMERS) {
            ((ConcurrentHashMap.KeySetView)timer.animationTimes.keySet()).forEach(key -> {
                timer.animationTimes.computeIfPresent((String)key, (animation, tick) -> tick - (double)event.getPartialTick().getRealtimeDeltaTicks());
                if (timer.animationTimes.get(key) <= 0.0) {
                    timer.animationTimes.remove(key);
                }
            });
            if (!timer.animationTimes.isEmpty()) continue;
            TIMERS.remove(timer);
        }
    }

    public boolean isPresent(String animation) {
        return this.animationTimes.containsKey(animation);
    }

    public boolean isPresent(RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return this.animationTimes.containsKey(((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }

    public double getDuration(String animation) {
        return this.animationTimes.getOrDefault(animation, 0.0);
    }

    public double getDuration(RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return this.getDuration(((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }

    public void putAnimation(String animation, Double ticks) {
        this.animationTimes.put(animation, ticks);
        if (!TIMERS.contains(this)) {
            TIMERS.add(this);
        }
    }

    public void stopAnimation(String animation) {
        this.animationTimes.remove(animation);
    }

    public <A extends GeoAnimatable, T extends GeoModel<A>> void putAnimation(T model, A animatable, String animation) {
        this.animationTimes.put(animation, AnimationUtils.animationDuration(model, animatable, animation));
        if (!TIMERS.contains(this)) {
            TIMERS.add(this);
        }
    }

    public <A extends GeoAnimatable, T extends GeoModel<A>> void putAnimation(T model, A animatable, RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        this.putAnimation(model, animatable, ((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }
}

