/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.bernie.geckolib.animation.RawAnimation;

public class RandomAnimationPicker {
    private final List<WeightedAnimation> weightedAnimations = new ArrayList<WeightedAnimation>();
    private final float totalWeight;

    public RandomAnimationPicker(WeightedAnimation weightedAnimation, WeightedAnimation ... moreWeightedAnimations) {
        this.weightedAnimations.add(weightedAnimation);
        Collections.addAll(this.weightedAnimations, moreWeightedAnimations);
        this.totalWeight = this.weightedAnimations.stream().map(WeightedAnimation::weight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public RawAnimation pickRandomAnimation() {
        float randomWeight = (float)Math.random() * this.totalWeight;
        for (WeightedAnimation weightedAnimation : this.weightedAnimations) {
            if (!((randomWeight -= weightedAnimation.weight()) <= 0.0f)) continue;
            return weightedAnimation.animation();
        }
        throw new IllegalStateException("No animation was picked for a RandomAnimationPicker instance!");
    }

    public record WeightedAnimation(RawAnimation animation, float weight) {
    }
}

