/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonPartLoader
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceKey<DragonSpecies>, Map<SkinLayer, Map<String, DragonPart>>> DRAGON_PARTS = new HashMap<ResourceKey<DragonSpecies>, Map<SkinLayer, Map<String, DragonPart>>>();
    private static final int LAYER = 0;

    public DragonPartLoader() {
        super(new Gson(), "skin/parts");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        DRAGON_PARTS.clear();
        map.forEach((location, value) -> {
            String[] elements = location.getPath().split("/", 2);
            if (elements.length != 2) {
                DragonSurvival.LOGGER.error("The dragon parts need to be stored as '<layer>/*.json' - [{}] is invalid", location);
                return;
            }
            try {
                SkinLayer layer = SkinLayer.valueOf(elements[0].toUpperCase(Locale.ENGLISH));
                DragonPart part = DragonPart.load(value.getAsJsonObject());
                for (ResourceKey<DragonSpecies> species : part.applicableSpecies()) {
                    DRAGON_PARTS.computeIfAbsent(species, key -> new HashMap()).computeIfAbsent(layer, key -> new HashMap()).put(part.key(), part);
                }
            }
            catch (IllegalArgumentException exception) {
                DragonSurvival.LOGGER.error("[{}] is not a valid layer for the dragon part - [{}] is invalid", (Object)elements[0], location);
            }
        });
    }

    @Nullable
    public static DragonPart getDragonPart(SkinLayer layer, ResourceKey<DragonSpecies> species, @Nullable Holder<DragonBody> body, String partKey) {
        return DragonPartLoader.getDragonParts(layer, species, body).get(partKey);
    }

    public static Map<String, DragonPart> getDragonParts(SkinLayer layer, ResourceKey<DragonSpecies> species, @Nullable Holder<DragonBody> body) {
        if (Objects.equals(layer.name, "Extra") && layer != SkinLayer.EXTRA) {
            return DragonPartLoader.getDragonParts(SkinLayer.EXTRA, species, body);
        }
        Map<SkinLayer, Map<String, DragonPart>> layers = DRAGON_PARTS.get(species);
        if (layers == null) {
            DragonSurvival.LOGGER.error("Part type map missing for dragon type {}", species);
            return new HashMap<String, DragonPart>();
        }
        Map<String, DragonPart> parts = layers.get((Object)layer);
        if (parts == null) {
            return new HashMap<String, DragonPart>();
        }
        if (parts.isEmpty()) {
            return new HashMap<String, DragonPart>();
        }
        if (body != null) {
            return parts.keySet().stream().filter(key -> {
                DragonPart part = (DragonPart)parts.get(key);
                return part.applicableBodies().isEmpty() && ((DragonBody)body.value()).model() == DragonBody.DEFAULT_MODEL || part.applicableBodies().contains(body.getKey());
            }).collect(Collectors.toMap(key -> key, parts::get));
        }
        return parts;
    }

    public static Map<String, DragonPart> getDragonParts(Player player, SkinLayer layer) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        return DragonPartLoader.getDragonParts(layer, handler.speciesKey(), handler.body());
    }
}

