/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skins;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skins.GiteeSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.GithubSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.NetSkinLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skins.SkinObject;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DragonSkins {
    public static final HashMap<ResourceKey<DragonStage>, HashMap<String, SkinObject>> USER_SKINS = new HashMap();
    public static final HashMap<String, CompletableFuture<ResourceLocation>> SKIN_CACHE = new HashMap();
    public static final HashMap<String, CompletableFuture<ResourceLocation>> GLOW_CACHE = new HashMap();
    public static final List<Supplier<NetSkinLoader>> SKIN_LOADERS = List.of(GithubSkinLoader::new, GiteeSkinLoader::new);
    public static NetSkinLoader skinLoader = new GithubSkinLoader();
    public static final List<ResourceKey<DragonStage>> validStages = List.of(DragonStages.newborn, DragonStages.young, DragonStages.adult);
    private static final ArrayList<String> hasFailedFetch = new ArrayList();
    private static double lastSkinFetchAttemptTime;
    private static int numSkinFetchAttempts;
    private static boolean initialized;

    public static boolean playerSkinOrGlowFetchingInProgress(String playerName, ResourceKey<DragonStage> stage) {
        String playerKey = playerName + "_" + stage.location().getPath();
        return SKIN_CACHE.containsKey(playerKey) && !SKIN_CACHE.get(playerKey).isDone() || GLOW_CACHE.containsKey(playerKey) && !GLOW_CACHE.get(playerKey).isDone();
    }

    public static boolean fetchHasFailed(String playerName, ResourceKey<DragonStage> stage) {
        String playerKey = playerName + "_" + stage.location().getPath();
        return hasFailedFetch.contains(playerKey);
    }

    @Nullable
    public static ResourceLocation getPlayerSkin(String playerName, ResourceKey<DragonStage> dragonStage) {
        String skinKey = validStages.contains(dragonStage) ? playerName + "_" + dragonStage.location().getPath() : playerName + "_" + DragonStages.adult.location().getPath();
        if (SKIN_CACHE.containsKey(skinKey) && SKIN_CACHE.get(skinKey) != null && SKIN_CACHE.get(skinKey).isDone()) {
            return SKIN_CACHE.get(skinKey).join();
        }
        if (!hasFailedFetch.contains(skinKey) && !SKIN_CACHE.containsKey(skinKey)) {
            SKIN_CACHE.put(skinKey, CompletableFuture.supplyAsync(() -> DragonSkins.fetchSkinFile(playerName, dragonStage, new String[0])));
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getPlayerGlow(String playerName, ResourceKey<DragonStage> dragonStage) {
        String skinKey = playerName + "_" + dragonStage.location().getPath();
        if (GLOW_CACHE.containsKey(skinKey) && GLOW_CACHE.get(skinKey) != null) {
            if (GLOW_CACHE.get(skinKey).isDone()) {
                return GLOW_CACHE.get(skinKey).join();
            }
        } else {
            GLOW_CACHE.put(skinKey, CompletableFuture.supplyAsync(() -> DragonSkins.fetchSkinFile(playerName, dragonStage, "glow")));
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getPlayerSkin(Player player, ResourceKey<DragonStage> dragonStage) {
        String playerKey = player.getGameProfile().getName() + "_" + dragonStage.location().getPath();
        boolean renderCustomSkin = DragonStateProvider.getData((Player)player).getSkinData().renderCustomSkin;
        if ((ClientDragonRenderer.renderOtherPlayerSkins.booleanValue() || player == DragonSurvival.PROXY.getLocalPlayer()) && renderCustomSkin) {
            if (SKIN_CACHE.containsKey(playerKey) && SKIN_CACHE.get(playerKey) != null && SKIN_CACHE.get(playerKey).isDone()) {
                return SKIN_CACHE.get(playerKey).join();
            }
            if (!hasFailedFetch.contains(playerKey) && !SKIN_CACHE.containsKey(playerKey)) {
                SKIN_CACHE.put(playerKey, CompletableFuture.supplyAsync(() -> DragonSkins.fetchSkinFile(player, dragonStage, new String[0])));
            }
        }
        return null;
    }

    @Nullable
    public static ResourceLocation fetchSkinFile(String playerName, ResourceKey<DragonStage> stage, String ... extra) {
        ResourceLocation resourceLocation;
        block21: {
            ResourceLocation resource;
            String playerKey = playerName + "_" + stage.location().getPath();
            Object[] text = (String[])ArrayUtils.addAll((Object[])new String[]{playerKey}, (Object[])extra);
            String resourceName = StringUtils.join((Object[])text, (String)"_");
            try {
                resource = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)resourceName.toLowerCase(Locale.ENGLISH));
            }
            catch (ResourceLocationException exception) {
                DragonSurvival.LOGGER.error((Object)exception);
                return null;
            }
            try (SimpleTexture simpleTexture = new SimpleTexture(resource);){
                if (Minecraft.getInstance().getTextureManager().getTexture(resource, (AbstractTexture)simpleTexture) != simpleTexture) {
                    ResourceLocation resourceLocation2 = resource;
                    return resourceLocation2;
                }
            }
            if (USER_SKINS.isEmpty()) {
                DragonSkins.init();
            }
            HashMap playerSkinMap = USER_SKINS.getOrDefault(stage, null);
            String skinName = StringUtils.join((Object[])ArrayUtils.addAll((Object[])new String[]{playerName}, (Object[])extra), (String)"_");
            SkinObject skin = null;
            if (playerSkinMap != null) {
                skin = playerSkinMap.getOrDefault(skinName, null);
            }
            if (skin == null) {
                if (!validStages.contains(stage)) {
                    DragonSurvival.LOGGER.debug("Failed to get skin information for custom stage {} for {}. Falling back to using adult stage.", stage, (Object)playerName);
                    return DragonSkins.fetchSkinFile(playerName, DragonStages.adult, extra);
                }
                return DragonSkins.fetchSkinResource(extra, playerKey, null);
            }
            InputStream imageStream = skinLoader.querySkinImage(skin);
            try {
                resourceLocation = DragonSkins.readSkin(imageStream, resource);
                if (imageStream == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return DragonSkins.fetchSkinResource(extra, playerKey, exception);
                }
            }
            imageStream.close();
        }
        return resourceLocation;
    }

    @Nullable
    private static ResourceLocation fetchSkinResource(String[] extra, String playerKey, @Nullable Exception exception) {
        boolean isNormalSkin = extra == null || extra.length == 0;
        DragonSkins.handleSkinFetchError(playerKey, isNormalSkin, exception);
        return null;
    }

    private static ResourceLocation readSkin(InputStream imageStream, ResourceLocation location) throws IOException {
        if (imageStream == null) {
            throw new IOException("Skin was not successfully fetched for [" + String.valueOf(location) + "]");
        }
        NativeImage customTexture = NativeImage.read((InputStream)imageStream);
        RenderSystem.recordRenderCall(() -> Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)new DynamicTexture(customTexture)));
        return location;
    }

    private static void handleSkinFetchError(String playerKey, boolean isNormalSkin, @Nullable Exception exception) {
        if (isNormalSkin && !hasFailedFetch.contains(playerKey)) {
            if (exception != null) {
                DragonSurvival.LOGGER.info("Custom skin for user {} doesn't exist.  If you do not have a skin registered under your username that has been uploaded to GitHub, ignore this message.", (Object)playerKey, (Object)exception);
            } else {
                DragonSurvival.LOGGER.info("Custom skin for user {} doesn't exist.  If you do not have a skin registered under your username that has been uploaded to GitHub, ignore this message.", (Object)playerKey);
            }
            hasFailedFetch.add(playerKey);
        }
    }

    public static ResourceLocation fetchSkinFile(Player playerEntity, ResourceKey<DragonStage> dragonStage, String ... extra) {
        return DragonSkins.fetchSkinFile(playerEntity.getGameProfile().getName(), dragonStage, extra);
    }

    @Nullable
    public static ResourceLocation getGlowTexture(Player player, ResourceKey<DragonStage> dragonStage) {
        String playerKey = player.getGameProfile().getName() + "_" + dragonStage.location().getPath();
        boolean renderCustomSkin = DragonStateProvider.getData((Player)player).getSkinData().renderCustomSkin;
        if ((ClientDragonRenderer.renderOtherPlayerSkins.booleanValue() || player == DragonSurvival.PROXY.getLocalPlayer()) && SKIN_CACHE.containsKey(playerKey) && renderCustomSkin) {
            if (GLOW_CACHE.containsKey(playerKey)) {
                if (GLOW_CACHE.get(playerKey).isDone()) {
                    return GLOW_CACHE.get(playerKey).join();
                }
            } else {
                GLOW_CACHE.put(playerKey, CompletableFuture.supplyAsync(() -> DragonSkins.fetchSkinFile(player, dragonStage, "glow")));
            }
        }
        return null;
    }

    public static void init() {
        DragonSkins.init(false);
    }

    public static synchronized void init(boolean force) {
        if (initialized && !force) {
            return;
        }
        DragonSkins.invalidateSkins();
        for (Supplier<NetSkinLoader> loader : SKIN_LOADERS) {
            NetSkinLoader testLoader = loader.get();
            if (!testLoader.ping()) continue;
            skinLoader = testLoader;
            break;
        }
        if (skinLoader == null) {
            skinLoader = new GithubSkinLoader();
            DragonSurvival.LOGGER.warn("Unable to connect to skin database.");
            return;
        }
        try {
            Collection<SkinObject> skins = skinLoader.querySkinList();
            if (skins == null) {
                DragonSurvival.LOGGER.warn("Unable to connect to skin database.");
                return;
            }
            DragonSkins.parseSkinObjects(skins);
            initialized = true;
        }
        catch (IOException e) {
            DragonSurvival.LOGGER.warn("Unable to connect to skin database.", (Throwable)e);
        }
    }

    private static void parseSkinObject(SkinObject skin) {
        boolean isGlow = false;
        String skinName = skin.name;
        if ((skinName = skin.name.substring(0, skinName.indexOf("."))).endsWith("_glow")) {
            isGlow = true;
            skinName = skin.name.substring(0, skinName.lastIndexOf("_"));
        }
        if (skinName.contains("_")) {
            ResourceKey<DragonStage> dragonStage;
            Object name = skinName.substring(0, skinName.lastIndexOf("_"));
            if (isGlow) {
                name = (String)name + "_glow";
            }
            if ((dragonStage = DragonSkins.parseResourceKeyFromName(skin.name)) == null) {
                return;
            }
            if (!USER_SKINS.containsKey(dragonStage)) {
                USER_SKINS.put(dragonStage, new HashMap());
            }
            skin.short_name = name;
            skin.glow = isGlow;
            USER_SKINS.get(dragonStage).putIfAbsent((String)name, skin);
        }
    }

    public static ResourceKey<DragonStage> parseResourceKeyFromName(String name) {
        String skinName = name.substring(0, name.indexOf("."));
        if (skinName.endsWith("_glow")) {
            skinName = name.substring(0, skinName.lastIndexOf("_"));
        }
        if (skinName.contains("_")) {
            String level = skinName.substring(skinName.lastIndexOf("_") + 1);
            try {
                return ResourceKey.create(DragonStage.REGISTRY, (ResourceLocation)DragonSurvival.res(level));
            }
            catch (ResourceLocationException exception) {
                DragonSurvival.LOGGER.warn("Could not parse dragon stage from the skin [{}] due to [{}]", (Object)name, (Object)exception.getMessage());
            }
        }
        return null;
    }

    public static void parseSkinObjects(Collection<SkinObject> skinObjects) {
        for (SkinObject skin : skinObjects) {
            DragonSkins.parseSkinObject(skin);
        }
    }

    private static void invalidateSkins() {
        USER_SKINS.clear();
        SKIN_CACHE.clear();
        GLOW_CACHE.clear();
        hasFailedFetch.clear();
    }

    public static boolean renderCustomSkin(LocalPlayer player) {
        return DragonStateProvider.getData((Player)player).getSkinData().renderCustomSkin;
    }
}

