/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonGrowthArgument;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class DragonGrowthCommand {
    @Translation(comments={"Set growth to %s for %s players."})
    private static final String SET_GROWTH_TO_PLAYERS = Translation.Type.COMMAND.wrap("growth.clear_from_entities");
    @Translation(comments={"Set growth to %s for %s."})
    private static final String SET_GROWTH_TO_PLAYER = Translation.Type.COMMAND.wrap("growth.clear_from_single_entity");
    @Translation(comments={"Failed to set growth since player was not a dragon."})
    private static final String FAILED_TO_SET_GROWTH = Translation.Type.COMMAND.wrap("growth.failed_to_set_growth");

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dragon-growth").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dragon_growth", (ArgumentType)new DragonGrowthArgument(event.getBuildContext())).executes(source -> {
            Collection players = EntityArgument.getPlayers((CommandContext)source, (String)"targets");
            double growth = DragonGrowthArgument.get(source);
            int count = 0;
            for (Player player : players) {
                DragonStateHandler handler = DragonStateProvider.getData(player);
                if (!handler.isDragon()) continue;
                handler.setDesiredGrowth(player, growth);
                ++count;
            }
            int finalCount = count;
            if (players.size() == 1) {
                if (count == 0) {
                    ((CommandSourceStack)source.getSource()).sendFailure((Component)Component.translatable((String)FAILED_TO_SET_GROWTH));
                } else {
                    ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)SET_GROWTH_TO_PLAYER, (Object[])new Object[]{growth, ((Player)players.iterator().next()).getDisplayName()}), true);
                }
            } else {
                ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.translatable((String)SET_GROWTH_TO_PLAYERS, (Object[])new Object[]{growth, finalCount}), true);
            }
            return 1;
        }))));
    }
}

