/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands.arguments;

import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonSpeciesArgument;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DragonBodyArgument
implements ArgumentType<Holder<DragonBody>> {
    public static final String ID = "dragon_body";
    private final HolderLookup.RegistryLookup<DragonBody> lookup;
    private final CommandBuildContext context;

    public DragonBodyArgument(CommandBuildContext context) {
        this.lookup = context.lookupOrThrow(DragonBody.REGISTRY);
        this.context = context;
    }

    @Nullable
    public Holder<DragonBody> parse(StringReader reader) throws CommandSyntaxException {
        Optional optional = this.lookup.get(ResourceKey.create(DragonBody.REGISTRY, (ResourceLocation)ResourceLocation.read((StringReader)reader)));
        return optional.orElse(null);
    }

    public static Holder<DragonBody> get(CommandContext<?> context) {
        return (Holder)context.getArgument(ID, Holder.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList suggestions = new ArrayList();
        Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
        if (species != null) {
            this.context.lookupOrThrow(DragonBody.REGISTRY).listElements().forEach(body -> {
                if (DragonBody.bodyIsValidForSpecies((Holder<DragonBody>)body, species)) {
                    suggestions.add(body.getRegisteredName());
                }
            });
        } else {
            this.lookup.listElementIds().forEach(element -> suggestions.add(element.location().toString()));
        }
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }
}

