/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncEnderDragonMark;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.PrimordialAnchorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimordialAnchorBlock
extends Block
implements EntityBlock {
    @Translation(key="primordial_anchor_gives_flight_grant_state", type=Translation.Type.CONFIGURATION, comments={"If enabled, the primordial anchor will give the flight grant state."})
    @ConfigOption(side=ConfigSide.SERVER, category={"primordial_anchor"}, key="primordial_anchor_gives_flight_grant_state")
    public static Boolean anchorGivesFlightGrantState = true;
    @Translation(key="primordial_anchor_gives_spin_grant_state", type=Translation.Type.CONFIGURATION, comments={"If enabled, the primordial anchor will give the spin grant state."})
    @ConfigOption(side=ConfigSide.SERVER, category={"primordial_anchor"}, key="primordial_anchor_gives_spin_grant_state")
    public static Boolean anchorGivesSpinGrantState = false;
    @Translation(comments={"The ender dragon has blessed you with the ability to fly."})
    private static final String PRIMORDIAL_ANCHOR_GRANTED_FLIGHT = Translation.Type.GUI.wrap("primordial_anchor.spin_grant_gained");
    @Translation(comments={"The ender dragon has blessed you with the ability to spin through the air."})
    private static final String PRIMORDIAL_ANCHOR_GRANTED_SPIN = Translation.Type.GUI.wrap("primordial_anchor.flight_grant_gained");
    @Translation(comments={"The ender dragon has blessed you with the ability to fly and spin through the air."})
    private static final String PRIMORDIAL_ANCHOR_GRANTED_FLIGHT_SPIN = Translation.Type.GUI.wrap("primordial_anchor.flight_spin_grant_gained");
    public static final BooleanProperty CHARGED = BooleanProperty.create((String)"charged");
    public static final BooleanProperty BLOODY = BooleanProperty.create((String)"bloody");

    public PrimordialAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOODY, (Comparable)Boolean.valueOf(false)));
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull RandomSource random) {
        if (!((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            return;
        }
        if (random.nextInt(100) == 0) {
            level.playLocalSound(position, SoundEvents.RESPAWN_ANCHOR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        this.spawnParticles(position, level, ParticleTypes.REVERSE_PORTAL);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CHARGED});
        builder.add(new Property[]{BLOODY});
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, @NotNull Level level, @NotNull BlockPos position) {
        return (Boolean)blockState.getValue((Property)CHARGED) != false ? 15 : 0;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)BLOODY)).booleanValue()) {
            for (int i = 0; i < 10; ++i) {
                this.spawnParticles(position, level, ParticleTypes.SOUL);
            }
            level.playSound(player, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.BLOCKS, 4.0f, 1.0f);
            player.hurt(level.damageSources().magic(), 1.0f);
            return InteractionResult.PASS;
        }
        if (!((Boolean)state.getValue((Property)CHARGED)).booleanValue() || level.dimension() != Level.END) {
            for (int i = 0; i < 10; ++i) {
                this.spawnParticles(position, level, ParticleTypes.LARGE_SMOKE);
            }
            level.playSound(player, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            for (int i = 0; i < 10; ++i) {
                this.spawnParticles(position, level, ParticleTypes.LARGE_SMOKE);
            }
            level.playSound(player, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.hurt(level.damageSources().magic(), 1.0f);
            return InteractionResult.PASS;
        }
        this.expendCharge(player, level, position, state);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos teleportPosition = this.findOrCreateValidTeleportPos(serverLevel, position).above(5);
            DimensionTransition transition = new DimensionTransition(serverLevel, teleportPosition.getCenter(), player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND);
            player.changeDimension(transition);
            handler.markedByEnderDragon = false;
            boolean flightWasActuallyGranted = false;
            boolean spinWasActuallyGranted = false;
            if (anchorGivesFlightGrantState.booleanValue()) {
                flightWasActuallyGranted = true;
                handler.flightWasGranted = true;
            }
            if (anchorGivesSpinGrantState.booleanValue()) {
                spinWasActuallyGranted = true;
                handler.spinWasGranted = true;
            }
            if (flightWasActuallyGranted && spinWasActuallyGranted) {
                player.sendSystemMessage((Component)Component.translatable((String)PRIMORDIAL_ANCHOR_GRANTED_FLIGHT_SPIN));
            } else if (flightWasActuallyGranted) {
                player.sendSystemMessage((Component)Component.translatable((String)PRIMORDIAL_ANCHOR_GRANTED_FLIGHT));
            } else if (spinWasActuallyGranted) {
                player.sendSystemMessage((Component)Component.translatable((String)PRIMORDIAL_ANCHOR_GRANTED_SPIN));
            }
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncEnderDragonMark(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(DSItemTags.PRIMORDIAL_ANCHOR_FUEL)) {
            this.charge(player, level, position, state);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    private BlockPos findTallestBlock(BlockGetter level, BlockPos position, int radius, boolean allowBedrock) {
        BlockPos tallestPosition = null;
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            block1: for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                if (xOffset == 0 && zOffset == 0 && !allowBedrock) continue;
                for (int y = level.getMaxBuildHeight() - 1; y > (tallestPosition == null ? level.getMinBuildHeight() : tallestPosition.getY()); --y) {
                    BlockPos positionToCheck = new BlockPos(position.getX() + xOffset, y, position.getZ() + zOffset);
                    BlockState state = level.getBlockState(positionToCheck);
                    if (!state.isCollisionShapeFullBlock(level, positionToCheck) || !allowBedrock && state.is(Blocks.BEDROCK)) continue;
                    tallestPosition = positionToCheck;
                    continue block1;
                }
            }
        }
        return tallestPosition == null ? position : tallestPosition;
    }

    @Nullable
    private BlockPos findValidSpawnInChunk(LevelChunk chunk) {
        ChunkPos chunkPosition = chunk.getPos();
        BlockPos position = new BlockPos(chunkPosition.getMinBlockX(), 30, chunkPosition.getMinBlockZ());
        int section = chunk.getHighestSectionPosition() + 16 - 1;
        BlockPos maxPosition = new BlockPos(chunkPosition.getMaxBlockX(), section, chunkPosition.getMaxBlockZ());
        BlockPos spawnPosition = null;
        double currentDistanceToCenter = 0.0;
        for (BlockPos positionToCheck : BlockPos.betweenClosed((BlockPos)position, (BlockPos)maxPosition)) {
            BlockState state = chunk.getBlockState(positionToCheck);
            BlockPos above = positionToCheck.above();
            BlockPos twoAbove = positionToCheck.above(2);
            if (!state.is(Blocks.END_STONE) || chunk.getBlockState(above).isCollisionShapeFullBlock((BlockGetter)chunk, above) || chunk.getBlockState(twoAbove).isCollisionShapeFullBlock((BlockGetter)chunk, twoAbove)) continue;
            double distance = positionToCheck.distToCenterSqr((Position)Vec3.ZERO);
            if (spawnPosition != null && !(distance < currentDistanceToCenter)) continue;
            spawnPosition = positionToCheck;
            currentDistanceToCenter = distance;
        }
        return spawnPosition;
    }

    private LevelChunk getChunk(Level level, Vec3 position) {
        return level.getChunk(Mth.floor((double)(position.x / 16.0)), Mth.floor((double)(position.z / 16.0)));
    }

    private boolean isChunkEmpty(Level level, Vec3 position) {
        return this.getChunk(level, position).getHighestFilledSectionIndex() == -1;
    }

    private Vec3 findExitPortalXZPosTentative(Level level, BlockPos startPosition) {
        Vec3 horizontal = new Vec3((double)startPosition.getX(), 0.0, (double)startPosition.getZ()).normalize();
        Vec3 position = horizontal.scale(1024.0);
        int j = 16;
        while (!this.isChunkEmpty(level, position) && j-- > 0) {
            DragonSurvival.LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)position);
            position = position.add(horizontal.scale(-16.0));
        }
        int k = 16;
        while (this.isChunkEmpty(level, position) && k-- > 0) {
            DragonSurvival.LOGGER.debug("Skipping forward past empty chunk at {}", (Object)position);
            position = position.add(horizontal.scale(16.0));
        }
        DragonSurvival.LOGGER.debug("Found chunk at {}", (Object)position);
        return position;
    }

    private BlockPos findOrCreateValidTeleportPos(ServerLevel level, BlockPos position) {
        Vec3 exitPortalPosition = this.findExitPortalXZPosTentative((Level)level, position);
        LevelChunk chunk = this.getChunk((Level)level, exitPortalPosition);
        BlockPos spawnPosition = this.findValidSpawnInChunk(chunk);
        if (spawnPosition == null) {
            BlockPos islandPosition = BlockPos.containing((double)(exitPortalPosition.x + 0.5), (double)75.0, (double)(exitPortalPosition.z + 0.5));
            DragonSurvival.LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)islandPosition);
            level.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(configuredFeatureRegistry -> configuredFeatureRegistry.getHolder(EndFeatures.END_ISLAND)).ifPresent(configuredFeatureHolder -> ((ConfiguredFeature)configuredFeatureHolder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), RandomSource.create((long)islandPosition.asLong()), islandPosition));
            spawnPosition = islandPosition;
        } else {
            DragonSurvival.LOGGER.debug("Found suitable block to teleport to: {}", (Object)spawnPosition);
        }
        return this.findTallestBlock((BlockGetter)level, spawnPosition, 16, true);
    }

    private void charge(@Nullable Player player, Level level, BlockPos position, BlockState state) {
        BlockState blockstate = (BlockState)state.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(true));
        level.setBlock(position, blockstate, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, position, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
        level.playSound(player, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void expendCharge(@Nullable Player player, Level level, BlockPos position, BlockState state) {
        BlockState blockstate = (BlockState)state.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false));
        level.setBlock(position, blockstate, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, position, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
        level.playSound(player, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, (Holder)SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void spawnParticles(BlockPos position, Level level, SimpleParticleType particle) {
        double x = (double)position.getX() + 0.5 + (0.5 - level.getRandom().nextDouble());
        double y = (double)position.getY() + 1.0;
        double z = (double)position.getZ() + 0.5 + (0.5 - level.getRandom().nextDouble());
        double speed = (double)level.getRandom().nextFloat() * 0.04;
        level.addParticle((ParticleOptions)particle, x, y, z, 0.0, speed, 0.0);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos position, @NotNull BlockState state) {
        return ((BlockEntityType)DSBlockEntities.PRIMORDIAL_ANCHOR.get()).create(position, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)DSBlockEntities.PRIMORDIAL_ANCHOR.get()), PrimordialAnchorBlockEntity::serverTick);
    }
}

