/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinData
implements INBTSerializable<CompoundTag> {
    public static final String RENDER_CUSTOM_SKIN = "render_custom_skin";
    public final Map<ResourceKey<DragonStage>, Boolean> recompileSkin = new HashMap<ResourceKey<DragonStage>, Boolean>();
    public final Map<ResourceKey<DragonStage>, Boolean> isCompiled = new HashMap<ResourceKey<DragonStage>, Boolean>();
    public final Lazy<HashMap<ResourceKey<DragonSpecies>, SkinPreset>> skinPresets = Lazy.of(this::initialize);
    public boolean renderCustomSkin;
    public boolean blankSkin;

    public HashMap<ResourceKey<DragonSpecies>, SkinPreset> initialize() {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return new HashMap<ResourceKey<DragonSpecies>, SkinPreset>();
        }
        HashMap<ResourceKey<DragonSpecies>, SkinPreset> presets = new HashMap<ResourceKey<DragonSpecies>, SkinPreset>();
        for (ResourceKey<DragonSpecies> dragonSpecies : ResourceHelper.keys(null, DragonSpecies.REGISTRY)) {
            SkinPreset preset = new SkinPreset();
            preset.initDefaults((Holder<DragonSpecies>)((Holder)ResourceHelper.get(null, dragonSpecies).get()), null);
            presets.put(dragonSpecies, preset);
        }
        return presets;
    }

    public void compileSkin(ResourceKey<DragonStage> dragonStage) {
        this.recompileSkin.put(dragonStage, true);
    }

    public Lazy<DragonStageCustomization> get(ResourceKey<DragonSpecies> dragonSpecies, ResourceKey<DragonStage> dragonStage) {
        return ((SkinPreset)((HashMap)this.skinPresets.get()).get(dragonSpecies)).get(dragonStage);
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(RENDER_CUSTOM_SKIN, this.renderCustomSkin);
        for (Map.Entry entry : ((HashMap)this.skinPresets.get()).entrySet()) {
            tag.put(((ResourceKey)entry.getKey()).location().toString(), (Tag)((SkinPreset)entry.getValue()).serializeNBT(provider));
        }
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag tag, @Nullable Holder<DragonBody> currentBody) {
        this.renderCustomSkin = tag.getBoolean(RENDER_CUSTOM_SKIN);
        for (String key : tag.getAllKeys()) {
            ResourceKey dragonSpecies = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)key));
            if (!provider.lookup(DragonSpecies.REGISTRY).flatMap(lookup -> lookup.get(dragonSpecies)).isPresent()) continue;
            SkinPreset preset = new SkinPreset();
            preset.deserializeNBT(provider, tag.getCompound(key), (ResourceKey<DragonSpecies>)dragonSpecies);
            if (preset.isEmpty()) {
                Holder speciesHolder = (Holder)ResourceHelper.get(provider, dragonSpecies).get();
                if (currentBody != null && ((DragonSpecies)speciesHolder.value()).isValidForBody(currentBody)) {
                    preset.initDefaults((Holder<DragonSpecies>)speciesHolder, ((DragonBody)currentBody.value()).model());
                }
            }
            ((HashMap)this.skinPresets.get()).put(dragonSpecies, preset);
        }
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        this.renderCustomSkin = tag.getBoolean(RENDER_CUSTOM_SKIN);
        for (String key : tag.getAllKeys()) {
            ResourceKey dragonSpecies = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)key));
            if (!provider.lookup(DragonSpecies.REGISTRY).flatMap(lookup -> lookup.get(dragonSpecies)).isPresent()) continue;
            SkinPreset preset = new SkinPreset();
            preset.deserializeNBT(provider, tag.getCompound(key), (ResourceKey<DragonSpecies>)dragonSpecies);
            ((HashMap)this.skinPresets.get()).put(dragonSpecies, preset);
        }
    }
}

