/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncGlowInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.GlowData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Glow
extends DurationInstanceBase<GlowData, Instance> {
    public static final Codec<Glow> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)TextColor.CODEC.fieldOf("color").forGetter(Glow::color)).apply((Applicative)instance, Glow::new));
    private final TextColor color;

    public Glow(DurationInstanceBase<?, ?> base, TextColor color) {
        super(base);
        this.color = color;
    }

    public static Glow create(ResourceLocation id, TextColor color) {
        return new Glow(DurationInstanceBase.create(id).infinite().removeAutomatically().hidden().build(), color);
    }

    public static Glow create(ResourceLocation id, LevelBasedValue duration, TextColor color) {
        return new Glow(DurationInstanceBase.create(id).duration(duration).hidden().build(), color);
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<GlowData> type() {
        return (AttachmentType)DSDataAttachments.GLOW.value();
    }

    public TextColor color() {
        return this.color;
    }

    public static class Instance
    extends DurationInstance<Glow> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(Glow baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public int getColor() {
            return ((Glow)this.baseData()).color().getValue();
        }

        @Override
        public Component getDescription() {
            return Component.empty();
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (!storageHolder.level().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)storageHolder, (CustomPacketPayload)new SyncGlowInstance(storageHolder.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (!storageHolder.level().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)storageHolder, (CustomPacketPayload)new SyncGlowInstance(storageHolder.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

