/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.LevelBasedTier;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncHarvestBonus;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HarvestBonuses;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarvestBonus
extends DurationInstanceBase<HarvestBonuses, Instance> {
    @Translation(comments={"\u00a76\u25a0 Harvest Bonus:\u00a7r", " - Base speed: %s", " - Harvest level: %s", " - Break speed: %s", " - Applies to: %s"})
    private static final String HARVEST_BONUS = Translation.Type.GUI.wrap("harvest_bonus");
    @Translation(comments={"Default"})
    private static final String DEFAULT = Translation.Type.GUI.wrap("harvest_bonus.default");
    public static float BASE_SPEED = 1.0f;
    public static int NO_BONUS_VALUE = 0;
    public static final LevelBasedValue NO_BONUS = LevelBasedValue.constant((float)NO_BONUS_VALUE);
    public static final Codec<HarvestBonus> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("blocks").forGetter(HarvestBonus::blocks), (App)LevelBasedTier.CODEC.optionalFieldOf("base_speed").forGetter(HarvestBonus::tiers), (App)LevelBasedValue.CODEC.optionalFieldOf("harvest_bonus", (Object)NO_BONUS).forGetter(HarvestBonus::harvestBonus), (App)LevelBasedValue.CODEC.optionalFieldOf("break_speed_multiplier", (Object)NO_BONUS).forGetter(HarvestBonus::breakSpeedMultiplier)).apply((Applicative)instance, HarvestBonus::new));
    private final Optional<HolderSet<Block>> blocks;
    private final Optional<LevelBasedTier> tiers;
    private final LevelBasedValue harvestBonus;
    private final LevelBasedValue breakSpeedMultiplier;

    public HarvestBonus(DurationInstanceBase<?, ?> base, Optional<HolderSet<Block>> blocks, Optional<LevelBasedTier> tiers, LevelBasedValue harvestBonus, LevelBasedValue breakSpeedMultiplier) {
        super(base);
        this.blocks = blocks;
        this.tiers = tiers;
        this.harvestBonus = harvestBonus;
        this.breakSpeedMultiplier = breakSpeedMultiplier;
    }

    public MutableComponent getDescription(int abilityLevel) {
        Tiers tier;
        int harvestBonus = (int)this.harvestBonus.calculate(abilityLevel);
        String breakSpeedMultiplier = NumberFormat.getPercentInstance().format(1.0f + this.breakSpeedMultiplier.calculate(abilityLevel));
        MutableComponent appliesTo = this.blocks.isEmpty() ? Component.translatable((String)LangKey.ALL_BLOCKS) : Functions.translateHolderSet(this.blocks.get(), Holder::getRegisteredName);
        MutableComponent baseSpeed = null;
        if (this.tiers.isPresent() && (tier = this.tiers.get().get(abilityLevel)) != null) {
            baseSpeed = DSLanguageProvider.enumValue(tier);
        }
        if (baseSpeed == null) {
            baseSpeed = Component.translatable((String)DEFAULT);
        }
        return Component.translatable((String)HARVEST_BONUS, (Object[])new Object[]{DSColors.dynamicValue(baseSpeed), DSColors.dynamicValue(harvestBonus), DSColors.dynamicValue(breakSpeedMultiplier), DSColors.dynamicValue(appliesTo)});
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<HarvestBonuses> type() {
        return (AttachmentType)DSDataAttachments.HARVEST_BONUSES.value();
    }

    public Optional<HolderSet<Block>> blocks() {
        return this.blocks;
    }

    public Optional<LevelBasedTier> tiers() {
        return this.tiers;
    }

    public LevelBasedValue harvestBonus() {
        return this.harvestBonus;
    }

    public LevelBasedValue breakSpeedMultiplier() {
        return this.breakSpeedMultiplier;
    }

    public static class Instance
    extends DurationInstance<HarvestBonus> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(HarvestBonus baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public float getBaseSpeed(BlockState state) {
            if (((HarvestBonus)this.baseData()).tiers().isEmpty()) {
                return BASE_SPEED;
            }
            if (((HarvestBonus)this.baseData()).blocks().isPresent() && !((HarvestBonus)this.baseData()).blocks().get().contains(state.getBlockHolder())) {
                return BASE_SPEED;
            }
            Tiers tier = ((HarvestBonus)this.baseData()).tiers().get().get(this.appliedAbilityLevel());
            if (tier != null) {
                return tier.getSpeed();
            }
            return BASE_SPEED;
        }

        public int getHarvestBonus(BlockState state) {
            if (((HarvestBonus)this.baseData()).blocks().isPresent() && !((HarvestBonus)this.baseData()).blocks().get().contains(state.getBlockHolder())) {
                return NO_BONUS_VALUE;
            }
            return (int)((HarvestBonus)this.baseData()).harvestBonus().calculate(this.appliedAbilityLevel());
        }

        public float getSpeedMultiplier(BlockState state) {
            if (((HarvestBonus)this.baseData()).blocks().isPresent() && !((HarvestBonus)this.baseData()).blocks().get().contains(state.getBlockHolder())) {
                return NO_BONUS_VALUE;
            }
            return ((HarvestBonus)this.baseData()).breakSpeedMultiplier().calculate(this.appliedAbilityLevel());
        }

        @Override
        public Component getDescription() {
            return ((HarvestBonus)this.baseData()).getDescription(this.appliedAbilityLevel());
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncHarvestBonus(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncHarvestBonus(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

