/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.util.AdditionalEffectData;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionData(HolderSet<MobEffect> effects, LevelBasedValue amplifier, LevelBasedValue duration, LevelBasedValue probability, boolean effectParticles, boolean showIcon) {
    public static final LevelBasedValue DEFAULT_PROBABILITY = LevelBasedValue.constant((float)1.0f);
    public static final MapCodec<PotionData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)BuiltInRegistries.MOB_EFFECT.key()).fieldOf("effects").forGetter(PotionData::effects), (App)LevelBasedValue.CODEC.fieldOf("amplifier").forGetter(PotionData::amplifier), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(PotionData::duration), (App)LevelBasedValue.CODEC.optionalFieldOf("probability", (Object)DEFAULT_PROBABILITY).forGetter(PotionData::probability), (App)Codec.BOOL.optionalFieldOf("effect_particles", (Object)false).forGetter(PotionData::effectParticles), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(PotionData::showIcon)).apply((Applicative)instance, PotionData::new));

    public void apply(@Nullable ServerPlayer dragon, int level, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            this.effects().forEach(effect -> {
                MobEffectInstance instance = livingTarget.getEffect(effect);
                Calculated calculated = Calculated.from(this, level);
                if (instance != null && instance.getAmplifier() >= calculated.amplifier() && instance.getDuration() >= calculated.duration()) {
                    return;
                }
                if (livingTarget.getRandom().nextDouble() > (double)calculated.probability()) {
                    return;
                }
                if (((MobEffect)effect.value()).isInstantenous()) {
                    ((MobEffect)effect.value()).applyInstantenousEffect((Entity)dragon, null, livingTarget, calculated.amplifier(), 1.0);
                } else {
                    livingTarget.addEffect(new MobEffectInstance(effect, calculated.duration(), calculated.amplifier(), false, this.effectParticles, this.showIcon), (Entity)dragon);
                }
            });
        }
    }

    public void remove(@Nullable ServerPlayer dragon, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.effects.forEach(effect -> {
                MobEffectInstance instance = livingEntity.getEffect(effect);
                if (instance == null) {
                    return;
                }
                if (dragon == null || ((AdditionalEffectData)instance).dragonSurvival$getApplier(dragon.serverLevel()) == dragon) {
                    livingEntity.removeEffect(effect);
                }
            });
        }
    }

    public List<MutableComponent> getDescription(int level) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        Calculated calculated = Calculated.from(this, level);
        for (Holder effect : this.effects) {
            MutableComponent name = Component.translatable((String)((MobEffect)effect.value()).getDescriptionId());
            if (calculated.amplifier() > 0) {
                name.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (calculated.amplifier() + 1))));
            }
            MutableComponent applies = Component.translatable((String)LangKey.ABILITY_APPLIES, (Object[])new Object[]{DSColors.dynamicValue(name)});
            if (calculated.duration() != -1) {
                applies.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_DURATION, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(calculated.duration()))}));
            }
            if (calculated.probability() < 1.0f) {
                applies.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_CHANCE, (Object[])new Object[]{DSColors.dynamicValue(NumberFormat.getPercentInstance().format(calculated.probability()))}));
            }
            components.add(applies);
        }
        return components;
    }

    public PotionContents toPotionContents(@NotNull RandomSource random, int level) {
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        Calculated calculated = Calculated.from(this, level);
        for (Holder effect : this.effects) {
            if (random.nextDouble() >= (double)calculated.probability()) continue;
            instances.add(new MobEffectInstance(effect, calculated.duration(), calculated.amplifier(), false, this.effectParticles()));
        }
        return new PotionContents(Optional.empty(), Optional.empty(), instances);
    }

    @SafeVarargs
    public static Builder create(Holder<MobEffect> ... effects) {
        return new Builder(effects);
    }

    public static Builder create(HolderSet<MobEffect> effects) {
        return new Builder(effects);
    }

    public record Calculated(int amplifier, int duration, float probability) {
        public static Calculated from(PotionData data, int level) {
            return new Calculated((int)data.amplifier().calculate(level), (int)data.duration().calculate(level), data.probability().calculate(level));
        }
    }

    public static class Builder {
        private final HolderSet<MobEffect> effects;
        private LevelBasedValue amplifier = LevelBasedValue.constant((float)0.0f);
        private LevelBasedValue duration = DragonAbilities.INFINITE_DURATION;
        private LevelBasedValue probability = DEFAULT_PROBABILITY;
        private boolean effectParticles;
        private boolean showIcon = true;

        @SafeVarargs
        public Builder(Holder<MobEffect> ... effects) {
            this.effects = HolderSet.direct(effects);
        }

        public Builder(HolderSet<MobEffect> effects) {
            this.effects = effects;
        }

        public Builder amplifier(int amplifier) {
            this.amplifier = LevelBasedValue.constant((float)amplifier);
            return this;
        }

        public Builder amplifierPer(float amplifier) {
            this.amplifier = LevelBasedValue.perLevel((float)amplifier);
            return this;
        }

        public Builder duration(int duration) {
            this.duration = LevelBasedValue.constant((float)Functions.secondsToTicks(duration));
            return this;
        }

        public Builder durationPer(int duration) {
            this.duration = LevelBasedValue.perLevel((float)Functions.secondsToTicks(duration));
            return this;
        }

        public Builder probability(float probability) {
            this.probability = LevelBasedValue.constant((float)probability);
            return this;
        }

        public Builder probabilityPer(float probability) {
            this.probability = LevelBasedValue.perLevel((float)probability);
            return this;
        }

        public Builder showParticles() {
            this.effectParticles = true;
            return this;
        }

        public Builder hideIcon() {
            this.showIcon = false;
            return this;
        }

        public PotionData build() {
            return new PotionData(this.effects, this.amplifier, this.duration, this.probability, this.effectParticles, this.showIcon);
        }
    }
}

