/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.phys.Vec3;

public record SpawnParticles(ParticleOptions particle, SpawnParticlesEffect.PositionSource horizontalPosition, SpawnParticlesEffect.PositionSource verticalPosition, SpawnParticlesEffect.VelocitySource horizontalVelocity, SpawnParticlesEffect.VelocitySource verticalVelocity, FloatProvider speed) {
    public static final Codec<SpawnParticles> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticles::particle), (App)SpawnParticlesEffect.PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticles::horizontalPosition), (App)SpawnParticlesEffect.PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticles::verticalPosition), (App)SpawnParticlesEffect.VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticles::horizontalVelocity), (App)SpawnParticlesEffect.VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticles::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticles::speed)).apply((Applicative)instance, SpawnParticles::new));

    public static SpawnParticlesEffect.PositionSource offsetFromEntityPosition(float offset) {
        return new SpawnParticlesEffect.PositionSource(SpawnParticlesEffect.PositionSourceType.ENTITY_POSITION, offset, 1.0f);
    }

    public static SpawnParticlesEffect.PositionSource inBoundingBox() {
        return new SpawnParticlesEffect.PositionSource(SpawnParticlesEffect.PositionSourceType.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static SpawnParticlesEffect.VelocitySource movementScaled(float movementScale) {
        return new SpawnParticlesEffect.VelocitySource(movementScale, (FloatProvider)ConstantFloat.ZERO);
    }

    public static SpawnParticlesEffect.VelocitySource fixedVelocity(FloatProvider velocity) {
        return new SpawnParticlesEffect.VelocitySource(0.0f, velocity);
    }

    public void apply(ServerLevel level, BlockPos blockPos, int count) {
        for (int i = 0; i < count; ++i) {
            level.sendParticles(this.particle, (double)blockPos.getX() + this.horizontalPosition.getCoordinate(0.5, 0.5, 1.0f, level.random), (double)blockPos.getY() + this.verticalPosition.getCoordinate(0.5, 0.5, 1.0f, level.random), (double)blockPos.getZ() + this.horizontalPosition.getCoordinate(0.5, 0.5, 1.0f, level.random), 1, this.horizontalVelocity.getVelocity(0.0, level.random), this.verticalVelocity.getVelocity(0.0, level.random), this.horizontalVelocity.getVelocity(0.0, level.random), (double)this.speed.sample(level.random));
        }
    }

    public void apply(ServerLevel level, Entity entity, int count) {
        RandomSource randomsource = entity.getRandom();
        Vec3 origin = entity.position();
        Vec3 vec3 = entity.getKnownMovement();
        float width = entity.getBbWidth();
        float height = entity.getBbHeight();
        for (int i = 0; i < count; ++i) {
            level.sendParticles(this.particle, this.horizontalPosition.getCoordinate(origin.x(), origin.x(), width, randomsource), this.verticalPosition.getCoordinate(origin.y(), origin.y() + (double)(height / 2.0f), height, randomsource), this.horizontalPosition.getCoordinate(origin.z(), origin.z(), width, randomsource), 1, this.horizontalVelocity.getVelocity(vec3.x(), randomsource), this.verticalVelocity.getVelocity(vec3.y(), randomsource), this.horizontalVelocity.getVelocity(vec3.z(), randomsource), (double)this.speed.sample(randomsource));
        }
    }
}

