/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.ability;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.NotNull;

public record ActionContainer(AbilityTargeting effect, TriggerPoint triggerPoint, LevelBasedValue triggerRate) {
    public static final Codec<ActionContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbilityTargeting.CODEC.fieldOf("target_selection").forGetter(ActionContainer::effect), (App)TriggerPoint.CODEC.optionalFieldOf("trigger_point", (Object)TriggerPoint.DEFAULT).forGetter(ActionContainer::triggerPoint), (App)LevelBasedValue.CODEC.optionalFieldOf("trigger_rate", (Object)LevelBasedValue.constant((float)1.0f)).forGetter(ActionContainer::triggerRate)).apply((Applicative)instance, ActionContainer::new));

    public void tick(ServerPlayer dragon, DragonAbilityInstance instance, int currentTick) {
        int actualTick = currentTick - instance.value().activation().getCastTime(instance.level());
        float rate = this.triggerRate.calculate(instance.level());
        if (rate > 0.0f && (float)actualTick % rate != 0.0f) {
            return;
        }
        this.effect.apply(dragon, instance);
    }

    public void remove(ServerPlayer dragon, DragonAbilityInstance instance) {
        this.effect.remove(dragon, instance);
    }

    public static enum TriggerPoint implements StringRepresentable
    {
        DEFAULT("default"),
        CHARGING("charging"),
        CHANNEL_COMPLETION("channel_completion");

        public static final Codec<TriggerPoint> CODEC;
        private final String name;

        private TriggerPoint(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TriggerPoint::values);
        }
    }
}

