/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationKey;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationLayer;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.RawAnimation;

public record SimpleAbilityAnimation(String animationKey, AnimationLayer layer, int transitionLength, boolean locksNeck, boolean locksTail) implements AbilityAnimation
{
    public static final Codec<SimpleAbilityAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("animation_key").forGetter(SimpleAbilityAnimation::animationKey), (App)Codec.STRING.xmap(AnimationLayer::valueOf, Enum::name).fieldOf("layer").forGetter(SimpleAbilityAnimation::layer), (App)Codec.INT.optionalFieldOf("transition_length", (Object)0).forGetter(SimpleAbilityAnimation::transitionLength), (App)Codec.BOOL.fieldOf("locks_neck").forGetter(SimpleAbilityAnimation::locksNeck), (App)Codec.BOOL.fieldOf("locks_tail").forGetter(SimpleAbilityAnimation::locksTail)).apply((Applicative)instance, SimpleAbilityAnimation::new));

    @Override
    public void play(AnimationState<?> state, AnimationType animationType) {
        state.getController().transitionLength(this.transitionLength);
        state.setAndContinue(this.getRawAnimation(animationType));
    }

    @Override
    public boolean locksHead() {
        return this.locksNeck;
    }

    @Override
    public AnimationLayer getLayer() {
        return this.layer();
    }

    private RawAnimation getRawAnimation(AnimationType type) {
        RawAnimation rawAnimation = RawAnimation.begin();
        if (type == AnimationType.PLAY_AND_HOLD) {
            rawAnimation = rawAnimation.thenPlayAndHold(this.animationKey);
        } else if (type == AnimationType.LOOPING) {
            rawAnimation = rawAnimation.thenLoop(this.animationKey);
        } else if (type == AnimationType.PLAY_ONCE) {
            rawAnimation = rawAnimation.then(this.animationKey, Animation.LoopType.PLAY_ONCE);
        }
        return rawAnimation;
    }

    public static Builder create(AnimationKey key, AnimationLayer layer) {
        return new Builder(key.getName(), layer);
    }

    @Override
    public String getName() {
        return this.animationKey;
    }

    public static class Builder {
        private final String animationKey;
        private final AnimationLayer layer;
        private int transitionLength = 0;
        private boolean locksNeck = false;
        private boolean locksTail = false;

        public Builder(String animationKey, AnimationLayer layer) {
            this.animationKey = animationKey;
            this.layer = layer;
        }

        public Builder transitionLength(int transitionLength) {
            this.transitionLength = transitionLength;
            return this;
        }

        public Builder locksNeck() {
            this.locksNeck = true;
            return this;
        }

        public Builder locksTail() {
            this.locksTail = true;
            return this;
        }

        public SimpleAbilityAnimation build() {
            return new SimpleAbilityAnimation(this.animationKey, this.layer, this.transitionLength, this.locksNeck, this.locksTail);
        }
    }
}

