/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.NearbyEntityPredicate;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.WeatherPredicate;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CustomPredicates(Optional<HolderSet<FluidType>> eyeInFluid, Optional<WeatherPredicate> weatherPredicate, Optional<MinMaxBounds.Ints> sunLightLevel, Optional<ResourceLocation> hasDurationEffect, Optional<NearbyEntityPredicate> isNearbyEntity, Optional<MinMaxBounds.Ints> playerHunger, Optional<MinMaxBounds.Doubles> healthPercentage, Optional<UUID> hasUUID) implements EntitySubPredicate
{
    public static final MapCodec<CustomPredicates> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)NeoForgeRegistries.FLUID_TYPES.key()).optionalFieldOf("eye_in_fluid").forGetter(CustomPredicates::eyeInFluid), (App)WeatherPredicate.CODEC.optionalFieldOf("weather_predicate").forGetter(CustomPredicates::weatherPredicate), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("sun_light_level").forGetter(CustomPredicates::sunLightLevel), (App)ResourceLocation.CODEC.optionalFieldOf("has_duration_effect").forGetter(CustomPredicates::hasDurationEffect), (App)NearbyEntityPredicate.CODEC.optionalFieldOf("is_nearby_entity").forGetter(CustomPredicates::isNearbyEntity), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("player_hunger").forGetter(CustomPredicates::playerHunger), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("health_percentage").forGetter(CustomPredicates::healthPercentage), (App)UUIDUtil.LENIENT_CODEC.optionalFieldOf("has_uuid").forGetter(CustomPredicates::hasUUID)).apply((Applicative)instance, CustomPredicates::new));

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (!this.eyeInFluid.map(fluids -> fluids.stream().anyMatch(fluid -> entity.isEyeInFluidType((FluidType)fluid.value()))).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.weatherPredicate.map(predicate -> predicate.matches(level, entity.position())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.sunLightLevel.map(light -> light.matches(CustomPredicates.getSunLightLevel(entity))).orElse(true).booleanValue()) {
            return false;
        }
        if (this.hasDurationEffect.isPresent()) {
            ResourceLocation abilityEffect = this.hasDurationEffect.get();
            boolean isPresent = false;
            for (Storage<?> storage : DSDataAttachments.getStorages(entity)) {
                if (!storage.all().stream().anyMatch(entry -> entry.id().equals((Object)abilityEffect))) continue;
                isPresent = true;
                break;
            }
            if (!isPresent) {
                return false;
            }
        }
        if (!this.isNearbyEntity.map(predicate -> predicate.matches(level, position)).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.playerHunger.map(hunger -> hunger.matches(CustomPredicates.getPlayerHunger(entity))).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.healthPercentage.map(health -> health.matches((double)CustomPredicates.getHealthPercentage(entity))).orElse(true).booleanValue()) {
            return false;
        }
        return this.hasUUID.map(uuid -> uuid.equals(entity.getUUID())).orElse(true) != false;
    }

    public static int getSunLightLevel(Entity entity) {
        int light = entity.level().getBrightness(LightLayer.SKY, entity.blockPosition()) - entity.level().getSkyDarken();
        return (int)Math.round((double)light * Functions.getSunPosition(entity));
    }

    public static int getPlayerHunger(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getFoodData().getFoodLevel();
        }
        return 0;
    }

    public static float getHealthPercentage(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.getHealth() / living.getMaxHealth();
        }
        return 0.0f;
    }

    public static class Builder {
        private Optional<HolderSet<FluidType>> eyeInFluid = Optional.empty();
        private Optional<Boolean> isRaining = Optional.empty();
        private Optional<Boolean> isThundering = Optional.empty();
        private Optional<Boolean> isSnowing = Optional.empty();
        private Optional<Boolean> isRainingOrSnowing = Optional.empty();
        private Optional<MinMaxBounds.Ints> sunLightLevel = Optional.empty();
        private Optional<ResourceLocation> hasDurationEffect = Optional.empty();
        private Optional<NearbyEntityPredicate> isNearbyEntity = Optional.empty();
        private Optional<UUID> hasUUID = Optional.empty();
        private Optional<MinMaxBounds.Ints> playerHunger = Optional.empty();
        private Optional<MinMaxBounds.Doubles> healthPercentage = Optional.empty();

        public static Builder start() {
            return new Builder();
        }

        public Builder eyeInFluid(Holder<FluidType> fluid) {
            this.eyeInFluid = Optional.of(HolderSet.direct((Holder[])new Holder[]{fluid}));
            return this;
        }

        public Builder eyeInFluid(HolderSet<FluidType> fluids) {
            this.eyeInFluid = Optional.of(fluids);
            return this;
        }

        public Builder raining(boolean isRaining) {
            this.isRaining = Optional.of(isRaining);
            return this;
        }

        public Builder thundering(boolean isThundering) {
            this.isThundering = Optional.of(isThundering);
            return this;
        }

        public Builder snowing(boolean isSnowing) {
            this.isSnowing = Optional.of(isSnowing);
            return this;
        }

        public Builder rainingOrSnowing(boolean isRainingOrSnowing) {
            this.isRainingOrSnowing = Optional.of(isRainingOrSnowing);
            return this;
        }

        public Builder sunLightLevel(int atLeast) {
            this.sunLightLevel = Optional.of(MinMaxBounds.Ints.atLeast((int)atLeast));
            return this;
        }

        public Builder hasDurationEffect(ResourceLocation abilityEffect) {
            this.hasDurationEffect = Optional.of(abilityEffect);
            return this;
        }

        public Builder isNearbyEntity(NearbyEntityPredicate isNearbyEntity) {
            this.isNearbyEntity = Optional.of(isNearbyEntity);
            return this;
        }

        public Builder hasUUID(UUID uuid) {
            this.hasUUID = Optional.of(uuid);
            return this;
        }

        public Builder hungerInRange(int min, int max) {
            this.playerHunger = Optional.of(MinMaxBounds.Ints.between((int)min, (int)max));
            return this;
        }

        public Builder healthPercentage(double min, double max) {
            this.healthPercentage = Optional.of(MinMaxBounds.Doubles.between((double)min, (double)max));
            return this;
        }

        public CustomPredicates build() {
            return new CustomPredicates(this.eyeInFluid, Optional.of(new WeatherPredicate(this.isRaining, this.isThundering, this.isSnowing, this.isRainingOrSnowing)), this.sunLightLevel, this.hasDurationEffect, this.isNearbyEntity, this.playerHunger, this.healthPercentage, this.hasUUID);
        }
    }
}

