/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.DragonStagePredicate;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DragonPredicate(Optional<HolderSet<DragonSpecies>> dragonSpecies, Optional<DragonStagePredicate> dragonStage, Optional<HolderSet<DragonBody>> dragonBody, Optional<Boolean> isGrowthStopped, Optional<Boolean> markedByEnderDragon, Optional<Boolean> flightWasGranted, Optional<Boolean> spinWasGranted, Optional<Boolean> isFlying) implements EntitySubPredicate
{
    public static final MapCodec<DragonPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(DragonSpecies.REGISTRY).optionalFieldOf("dragon_species").forGetter(DragonPredicate::dragonSpecies), (App)DragonStagePredicate.CODEC.optionalFieldOf("stage_specific").forGetter(DragonPredicate::dragonStage), (App)RegistryCodecs.homogeneousList(DragonBody.REGISTRY).optionalFieldOf("dragon_body").forGetter(DragonPredicate::dragonBody), (App)Codec.BOOL.optionalFieldOf("is_growth_stopped").forGetter(DragonPredicate::isGrowthStopped), (App)Codec.BOOL.optionalFieldOf("marked_by_ender_dragon").forGetter(DragonPredicate::markedByEnderDragon), (App)Codec.BOOL.optionalFieldOf("flight_was_granted").forGetter(DragonPredicate::flightWasGranted), (App)Codec.BOOL.optionalFieldOf("spin_was_granted").forGetter(DragonPredicate::spinWasGranted), (App)Codec.BOOL.optionalFieldOf("is_flying").forGetter(DragonPredicate::isFlying)).apply((Applicative)instance, DragonPredicate::new));

    public boolean matches(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        if (!handler.isDragon()) {
            return false;
        }
        if (this.dragonSpecies().isPresent() && !this.dragonSpecies().get().contains(handler.species())) {
            return false;
        }
        if (this.dragonStage().isPresent() && !this.dragonStage().get().matches(handler.stage(), handler.getGrowth())) {
            return false;
        }
        if (this.dragonBody().isPresent() && !this.dragonBody().get().contains(handler.body())) {
            return false;
        }
        if (this.isGrowthStopped().isPresent() && this.isGrowthStopped().get() != handler.isGrowthStopped) {
            return false;
        }
        if (this.markedByEnderDragon().isPresent() && this.markedByEnderDragon().get() != handler.markedByEnderDragon) {
            return false;
        }
        if (this.flightWasGranted().isPresent() && this.flightWasGranted().get() != handler.flightWasGranted) {
            return false;
        }
        if (this.spinWasGranted().isPresent() && this.spinWasGranted().get() != handler.spinWasGranted) {
            return false;
        }
        return !this.isFlying().isPresent() || this.isFlying().get() == ServerFlightHandler.isFlying((Player)player);
    }

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public static class Builder {
        private Optional<HolderSet<DragonSpecies>> dragonSpecies = Optional.empty();
        private Optional<DragonStagePredicate> dragonStage = Optional.empty();
        private Optional<HolderSet<DragonBody>> dragonBody = Optional.empty();
        private Optional<Boolean> isGrowthStopped = Optional.empty();
        private Optional<Boolean> markedByEnderDragon = Optional.empty();
        private Optional<Boolean> flightWasGranted = Optional.empty();
        private Optional<Boolean> spinWasGranted = Optional.empty();
        private Optional<Boolean> isFlying = Optional.empty();

        public static Builder dragon() {
            return new Builder();
        }

        public Builder species(Holder<DragonSpecies> dragonSpecies) {
            this.dragonSpecies = Optional.of(HolderSet.direct((Holder[])new Holder[]{dragonSpecies}));
            return this;
        }

        public Builder species(HolderSet<DragonSpecies> dragonSpecies) {
            this.dragonSpecies = Optional.of(dragonSpecies);
            return this;
        }

        public Builder stage(DragonStagePredicate predicate) {
            this.dragonStage = Optional.of(predicate);
            return this;
        }

        public Builder stage(Holder<DragonStage> dragonStage) {
            this.dragonStage = Optional.of(DragonStagePredicate.Builder.start().stage(dragonStage).build());
            return this;
        }

        public Builder stage(Holder<DragonStage> dragonStage, MinMaxBounds.Doubles progress) {
            this.dragonStage = Optional.of(DragonStagePredicate.Builder.start().stage(dragonStage).progress(progress).build());
            return this;
        }

        public Builder body(Holder<DragonBody> dragonBody) {
            this.dragonBody = Optional.of(HolderSet.direct((Holder[])new Holder[]{dragonBody}));
            return this;
        }

        public Builder growthStopped(boolean isGrowthStopped) {
            this.isGrowthStopped = Optional.of(isGrowthStopped);
            return this;
        }

        public Builder markedByEnderDragon(boolean markedByEnderDragon) {
            this.markedByEnderDragon = Optional.of(markedByEnderDragon);
            return this;
        }

        public Builder flightWasGranted(boolean flightWasGranted) {
            this.flightWasGranted = Optional.of(flightWasGranted);
            return this;
        }

        public Builder spinWasGranted(boolean spinWasGranted) {
            this.spinWasGranted = Optional.of(spinWasGranted);
            return this;
        }

        public Builder isFlying(boolean isFlying) {
            this.isFlying = Optional.of(isFlying);
            return this;
        }

        public DragonPredicate build() {
            return new DragonPredicate(this.dragonSpecies, this.dragonStage, this.dragonBody, this.isGrowthStopped, this.markedByEnderDragon, this.flightWasGranted, this.spinWasGranted, this.isFlying);
        }
    }
}

