/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.DragonSurvivalClient;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.util.AnimationTickTimer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationLayer;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationType;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.compat.create.SkyhookRendererHelper;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.TreasureRestData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmote;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber
public class DragonEntity
extends LivingEntity
implements GeoEntity {
    private static final int MAX_EMOTES = 4;
    private static final int CONTINUOUS_ANIMATION_SLOTS = 4;
    private static final double DEFAULT_WALK_SPEED = 0.1;
    private static final double DEFAULT_SNEAK_SPEED = 0.03;
    private static final double DEFAULT_SPRINT_SPEED = 0.165;
    private static final double DEFAULT_SWIM_SPEED = 0.051;
    private static final double DEFAULT_FAST_SWIM_SPEED = 0.13;
    private static final double DEFAULT_CLIMB_SPEED = 1.0E-4;
    private static final double BASE_SCALE = 1.0;
    public static final ConcurrentHashMap<Integer, Boolean> DRAGONS_JUMPING = new ConcurrentHashMap();
    private static double globalTickCount;
    public final ArrayList<Double> headYawHistory = new ArrayList();
    public double currentHeadYawChange;
    public final ArrayList<Double> bodyYawHistory = new ArrayList();
    public double currentBodyYawChange;
    public final ArrayList<Double> headPitchHistory = new ArrayList();
    public double currentHeadPitchChange;
    public final ArrayList<Double> verticalVelocityHistory = new ArrayList();
    public double currentTailMotionUp;
    public AnimationController<DragonEntity> mainAnimationController;
    public volatile Integer playerId;
    public boolean neckLocked;
    public boolean tailLocked;
    public float prevZRot;
    public float prevXRot;
    public boolean overrideUUIDWithLocalPlayerForTextureFetch;
    public boolean isInInventory;
    public boolean clearVerticalVelocity;
    private final DragonEmote[] currentlyPlayingEmotes = new DragonEmote[4];
    private final boolean[] soundForEmoteHasAlreadyPlayedThisTick = new boolean[4];
    private final AnimationTickTimer animationTickTimer = new AnimationTickTimer();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Pair<AbilityAnimation, AnimationType> currentAbilityAnimation;
    private boolean begunPlayingAbilityAnimation;
    public boolean renderingWasCancelled;
    private static final String EMOTE = "emote_";
    private static final String CONTINUOUS = "continuous_";
    private static final RawAnimation BITE;
    private static final RawAnimation USE_ITEM_RIGHT;
    private static final RawAnimation USE_ITEM_LEFT;
    private static final RawAnimation EAT_ITEM_RIGHT;
    private static final RawAnimation EAT_ITEM_LEFT;
    private static final RawAnimation SIT_ON_MAGIC_SOURCE;
    private static final RawAnimation SLEEP;
    private static final RawAnimation SIT;
    private static final RawAnimation FLY;
    private static final RawAnimation FLY_SOARING;
    private static final RawAnimation FLY_DIVE;
    private static final RawAnimation FLY_DIVE_ALT;
    private static final RawAnimation FLY_SPIN;
    private static final RawAnimation FLY_LAND;
    private static final RawAnimation SWIM;
    private static final RawAnimation SWIM_FAST;
    private static final RawAnimation FALL_LOOP;
    private static final RawAnimation SNEAK;
    private static final RawAnimation SNEAK_WALK;
    private static final RawAnimation DIG_SNEAK;
    private static final RawAnimation RUN;
    private static final RawAnimation WALK;
    private static final RawAnimation IDLE;
    private static final RawAnimation DIG;
    private static final RawAnimation CLIMBING_UP;
    private static final RawAnimation CLIMBING_DOWN;
    private static final RawAnimation JUMP;
    private static final RawAnimation FLY_LAND_END;
    private static final RawAnimation CREATE_SKYHOOK_RIDING;

    public DragonEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        int finalSlot;
        int slot;
        this.mainAnimationController = new AnimationController((GeoAnimatable)this, "main", 2, this::predicate);
        registrar.add(this.mainAnimationController);
        for (slot = 0; slot < 4; ++slot) {
            finalSlot = slot;
            registrar.add(new AnimationController((GeoAnimatable)this, EMOTE + slot, state -> this.emotePredicate((AnimationState<DragonEntity>)state, finalSlot)));
        }
        registrar.add(new AnimationController((GeoAnimatable)this, "bite", 2, this::bitePredicate));
        registrar.add(new AnimationController((GeoAnimatable)this, "breath", 2, this::breathPredicate));
        for (slot = 0; slot < 4; ++slot) {
            finalSlot = slot;
            registrar.add(new AnimationController((GeoAnimatable)this, CONTINUOUS + slot, state -> this.continousPredicate((AnimationState<DragonEntity>)state, finalSlot)));
        }
    }

    public void stopAllEmotes() {
        Arrays.fill(this.currentlyPlayingEmotes, null);
    }

    public int getTicksForEmote(int slot) {
        if (this.animationTickTimer.isPresent(EMOTE + slot)) {
            return (int)Math.ceil(this.animationTickTimer.getDuration(EMOTE + slot));
        }
        return -1;
    }

    public void clearSoundsPlayedThisTick() {
        Arrays.fill(this.soundForEmoteHasAlreadyPlayedThisTick, false);
    }

    public boolean markEmoteSoundPlayedThisTick(int slot) {
        if (this.soundForEmoteHasAlreadyPlayedThisTick[slot]) {
            return false;
        }
        this.soundForEmoteHasAlreadyPlayedThisTick[slot] = true;
        return true;
    }

    public void stopEmote(int slot) {
        if (this.currentlyPlayingEmotes[slot] != null) {
            this.animationTickTimer.stopAnimation(EMOTE + slot);
            this.currentlyPlayingEmotes[slot] = null;
        }
    }

    public void stopEmote(DragonEmote emote) {
        for (int i = 0; i < 4; ++i) {
            if (this.currentlyPlayingEmotes[i] != emote) continue;
            this.currentlyPlayingEmotes[i] = null;
            this.animationTickTimer.stopAnimation(EMOTE + i);
            return;
        }
    }

    public void beginPlayingEmote(DragonEmote emote) {
        int i;
        if (emote == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (this.currentlyPlayingEmotes[i] == emote) {
                this.currentlyPlayingEmotes[i] = null;
                this.animationTickTimer.stopAnimation(EMOTE + i);
                continue;
            }
            if (this.currentlyPlayingEmotes[i] == null || this.currentlyPlayingEmotes[i].blend() || emote.blend()) continue;
            this.currentlyPlayingEmotes[i] = null;
            this.animationTickTimer.stopAnimation(EMOTE + i);
        }
        for (i = 0; i < 4; ++i) {
            if (this.currentlyPlayingEmotes[i] != null) continue;
            this.currentlyPlayingEmotes[i] = emote;
            if (emote.duration() != -1) {
                this.animationTickTimer.putAnimation(EMOTE + i, Double.valueOf(emote.duration()));
            } else {
                this.animationTickTimer.putAnimation(EMOTE + i, AnimationUtils.animationDuration(DragonSurvivalClient.DRAGON_MODEL, this, emote.animationKey()));
            }
            if (emote.sound().isPresent() && this.getPlayer() != null) {
                emote.sound().get().playSound(this.getPlayer());
            }
            return;
        }
    }

    public DragonEmote[] getCurrentlyPlayingEmotes() {
        return this.currentlyPlayingEmotes;
    }

    private boolean checkAllEmotes(Predicate<DragonEmote> predicate) {
        for (DragonEmote emote : this.currentlyPlayingEmotes) {
            if (emote == null || !predicate.test(emote)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayingAnyEmote() {
        return Stream.of(this.currentlyPlayingEmotes).anyMatch(Objects::nonNull);
    }

    public boolean isPlayingEmote(DragonEmote emote) {
        return Stream.of(this.currentlyPlayingEmotes).anyMatch(e -> e == emote);
    }

    public void setCurrentAbilityAnimation(Pair<AbilityAnimation, AnimationType> currentAbilityAnimation) {
        if (this.currentAbilityAnimation != null) {
            this.animationTickTimer.stopAnimation(((AbilityAnimation)this.currentAbilityAnimation.getFirst()).getName());
        }
        this.currentAbilityAnimation = currentAbilityAnimation;
        this.begunPlayingAbilityAnimation = false;
    }

    private boolean checkAndPlayAbilityAnimation(AnimationState<DragonEntity> state, AnimationLayer layer) {
        boolean isNotPlayingCurrentAbilityAnimation;
        AnimationLayer currentAbilityLayer = this.currentAbilityAnimation != null ? ((AbilityAnimation)this.currentAbilityAnimation.getFirst()).getLayer() : null;
        boolean bl = isNotPlayingCurrentAbilityAnimation = this.currentAbilityAnimation != null && currentAbilityLayer == layer && this.animationTickTimer.getDuration(((AbilityAnimation)this.currentAbilityAnimation.getFirst()).getName()) <= 0.0;
        if (!this.begunPlayingAbilityAnimation && isNotPlayingCurrentAbilityAnimation) {
            this.begunPlayingAbilityAnimation = true;
            state.getController().setAnimationSpeed(1.0);
            ((AbilityAnimation)this.currentAbilityAnimation.getFirst()).play(state, (AnimationType)((Object)this.currentAbilityAnimation.getSecond()));
            if (this.currentAbilityAnimation.getSecond() == AnimationType.PLAY_ONCE) {
                this.animationTickTimer.putAnimation(DragonSurvivalClient.DRAGON_MODEL, this, ((AbilityAnimation)this.currentAbilityAnimation.getFirst()).getName());
            }
        } else if (this.begunPlayingAbilityAnimation && isNotPlayingCurrentAbilityAnimation && this.currentAbilityAnimation.getSecond() == AnimationType.PLAY_ONCE) {
            this.begunPlayingAbilityAnimation = false;
            this.currentAbilityAnimation = null;
        } else if (this.begunPlayingAbilityAnimation && currentAbilityLayer == layer) {
            state.getController().setAnimationSpeed(1.0);
            return true;
        }
        return this.begunPlayingAbilityAnimation && currentAbilityLayer == layer;
    }

    private PlayState breathPredicate(AnimationState<DragonEntity> state) {
        Player player = this.getPlayer();
        if (player == null) {
            return PlayState.STOP;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.refreshBody) {
            state.getController().forceAnimationReset();
        }
        if (this.checkAndPlayAbilityAnimation(state, AnimationLayer.BREATH)) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState playOrContinueAnimation(RawAnimation animation, AnimationState<DragonEntity> state, MovementData movement) {
        movement.bite = false;
        if (this.animationTickTimer.getDuration(animation) <= 0.0) {
            this.animationTickTimer.putAnimation(DragonSurvivalClient.DRAGON_MODEL, this, animation);
        }
        return state.setAndContinue(animation);
    }

    private PlayState bitePredicate(AnimationState<DragonEntity> state) {
        Player player = this.getPlayer();
        if (player == null) {
            return PlayState.STOP;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.refreshBody) {
            state.getController().forceAnimationReset();
        }
        if (this.checkAndPlayAbilityAnimation(state, AnimationLayer.BITE)) {
            return PlayState.CONTINUE;
        }
        MovementData movement = MovementData.getData((Entity)player);
        boolean isUsingItem = player.isUsingItem();
        boolean isUsingEdibleItem = isUsingItem && DragonFoodHandler.isEdible(player, player.getMainHandItem());
        InteractionHand usedItemHand = this.getUsedItemHand();
        if (!ClientDragonRenderer.renderItemsInMouth.booleanValue()) {
            if (isUsingEdibleItem) {
                if (usedItemHand == InteractionHand.MAIN_HAND || this.animationTickTimer.getDuration(EAT_ITEM_RIGHT) > 0.0) {
                    return this.playOrContinueAnimation(EAT_ITEM_RIGHT, state, movement);
                }
                if (usedItemHand == InteractionHand.OFF_HAND || this.animationTickTimer.getDuration(EAT_ITEM_LEFT) > 0.0) {
                    return this.playOrContinueAnimation(EAT_ITEM_LEFT, state, movement);
                }
            } else if (isUsingItem) {
                if (usedItemHand == InteractionHand.MAIN_HAND && player.getTicksUsingItem() == 1 || this.animationTickTimer.getDuration(USE_ITEM_RIGHT) > 0.0) {
                    return this.playOrContinueAnimation(USE_ITEM_RIGHT, state, movement);
                }
                if (usedItemHand == InteractionHand.OFF_HAND && player.getTicksUsingItem() == 1 || this.animationTickTimer.getDuration(USE_ITEM_LEFT) > 0.0) {
                    return this.playOrContinueAnimation(USE_ITEM_LEFT, state, movement);
                }
            } else if (player.getItemInHand(InteractionHand.MAIN_HAND) != ItemStack.EMPTY && (movement.bite || this.animationTickTimer.getDuration(USE_ITEM_RIGHT) > 0.0)) {
                return this.playOrContinueAnimation(USE_ITEM_RIGHT, state, movement);
            }
        }
        if (movement.bite && !movement.dig || this.animationTickTimer.getDuration(BITE) > 0.0) {
            return this.playOrContinueAnimation(BITE, state, movement);
        }
        return PlayState.STOP;
    }

    private PlayState continousPredicate(AnimationState<DragonEntity> state, int slot) {
        Player player = this.getPlayer();
        if (player == null) {
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.refreshBody) {
            state.getController().forceAnimationReset();
        }
        if (AnimationUtils.doesAnimationExist(DragonSurvivalClient.DRAGON_MODEL, this, CONTINUOUS + slot)) {
            RawAnimation continuousAnimation = RawAnimation.begin().thenPlay(CONTINUOUS + slot);
            state.setAndContinue(continuousAnimation);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState emotePredicate(AnimationState<DragonEntity> state, int slot) {
        Player player = this.getPlayer();
        if (player == null) {
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (handler.refreshBody) {
            state.getController().forceAnimationReset();
        }
        if (this.currentlyPlayingEmotes[slot] != null) {
            DragonEmote emote = this.currentlyPlayingEmotes[slot];
            double duration = this.animationTickTimer.getDuration(EMOTE + slot);
            if (duration > 0.0 || emote.loops()) {
                state.getController().setAnimationSpeed(emote.speed());
                if (!emote.loops()) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay(emote.animationKey()));
                }
                if (duration <= 0.0) {
                    if (emote.duration() != -1) {
                        this.animationTickTimer.putAnimation(EMOTE + slot, Double.valueOf(emote.duration()));
                    } else {
                        this.animationTickTimer.putAnimation(EMOTE + slot, AnimationUtils.animationDuration(DragonSurvivalClient.DRAGON_MODEL, this, emote.animationKey()));
                    }
                }
                return state.setAndContinue(RawAnimation.begin().thenLoop(emote.animationKey()));
            }
            this.currentlyPlayingEmotes[slot] = null;
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Nullable
    public Player getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        Entity entity = this.level().getEntity(this.playerId.intValue());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public float getScale() {
        Player player = this.getPlayer();
        if (player == null) {
            return super.getScale();
        }
        if (player.level().isClientSide()) {
            return (float)DragonStateProvider.getData(player).getVisualScale(player, DragonSurvival.PROXY.getPartialTick());
        }
        return player.getScale();
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        Player player = this.getPlayer();
        if (player == null) {
            return super.getDefaultDimensions(pose);
        }
        return player.getDimensions(pose);
    }

    @Nullable
    public PlayerTeam getTeam() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getTeam();
        }
        return super.getTeam();
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getDeltaMovement();
        }
        return super.getDeltaMovement();
    }

    public float getHealth() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getHealth();
        }
        return super.getHealth();
    }

    public float getMaxHealth() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getMaxHealth();
        }
        return super.getMaxHealth();
    }

    public boolean isInvisible() {
        if (super.isInvisible()) {
            return true;
        }
        Player player = this.getPlayer();
        return player != null && player.isInvisible();
    }

    public boolean isCurrentlyGlowing() {
        if (super.isCurrentlyGlowing()) {
            return true;
        }
        Player player = this.getPlayer();
        return player != null && player.isCurrentlyGlowing();
    }

    private void lockTailAndNeck() {
        this.neckLocked = true;
        this.tailLocked = true;
    }

    private void clearVerticalVelocity() {
        this.clearVerticalVelocity = true;
    }

    public static boolean isConsideredSwimmingForAnimation(Player player) {
        boolean isInFluid = player.canSwimInFluidType(player.getInBlockState().getFluidState().getFluidType());
        return isInFluid && !player.isPassenger() && (!player.onGround() || !player.getEyeInFluidType().isAir());
    }

    private PlayState predicate(AnimationState<DragonEntity> state) {
        boolean animationWasNullBeforePredicate;
        Player player = this.getPlayer();
        if (player == null) {
            return PlayState.STOP;
        }
        AnimationController animationController = state.getController();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        TreasureRestData treasureRest = TreasureRestData.getData(player);
        if (handler.refreshBody) {
            animationController.forceAnimationReset();
        }
        boolean useDynamicScaling = false;
        double animationSpeed = 1.0;
        double speedFactor = ClientConfig.movementAnimationSpeedFactor;
        double baseSpeed = 0.1;
        double smallSizeFactor = ClientConfig.smallSizeAnimationSpeedFactor;
        double bigSizeFactor = ClientConfig.largeSizeAnimationSpeedFactor;
        double distanceFromGround = ServerFlightHandler.distanceFromGround(player);
        if (this.checkAllEmotes(emote -> !emote.blend())) {
            this.neckLocked = this.checkAllEmotes(DragonEmote::locksHead);
            this.tailLocked = this.checkAllEmotes(DragonEmote::locksTail);
            state.getController().stop();
            return PlayState.STOP;
        }
        Vec3 deltaMovement = player.getDeltaMovement();
        this.neckLocked = false;
        this.tailLocked = false;
        if (this.checkAndPlayAbilityAnimation(state, AnimationLayer.BASE)) {
            return PlayState.CONTINUE;
        }
        MovementData movement = MovementData.getData((Entity)player);
        boolean isSwimming = DragonEntity.isConsideredSwimmingForAnimation(player);
        boolean bl = animationWasNullBeforePredicate = animationController.getCurrentAnimation() == null;
        if (!movement.isMovingHorizontally() && handler.isOnMagicSource) {
            return state.setAndContinue(SIT_ON_MAGIC_SOURCE);
        }
        if (player.isSleeping() || treasureRest.isResting()) {
            return state.setAndContinue(SLEEP);
        }
        if (SkyhookRendererHelper.isPlayerRidingSkyhook(player.getUUID()) && AnimationUtils.doesAnimationExist(DragonSurvivalClient.DRAGON_MODEL, this, CREATE_SKYHOOK_RIDING)) {
            return state.setAndContinue(CREATE_SKYHOOK_RIDING);
        }
        if (player.isPassenger()) {
            return state.setAndContinue(SIT);
        }
        if (player.getAbilities().flying || ServerFlightHandler.isFlying(player)) {
            if (ServerFlightHandler.isGliding(player)) {
                if (ServerFlightHandler.isSpin(player)) {
                    animationSpeed = 2.0;
                    state.setAnimation(FLY_SPIN);
                    animationController.transitionLength(5);
                } else if (deltaMovement.y < -1.0) {
                    state.setAnimation(FLY_DIVE_ALT);
                    animationController.transitionLength(4);
                } else if (deltaMovement.y < -0.25) {
                    state.setAnimation(FLY_DIVE);
                    animationController.transitionLength(4);
                } else if (deltaMovement.y > 0.5) {
                    animationSpeed = 1.5;
                    state.setAnimation(FLY);
                    animationController.transitionLength(2);
                } else {
                    state.setAnimation(FLY_SOARING);
                    animationController.transitionLength(4);
                }
            } else if (movement.desiredMoveVec.y < 0.0 && deltaMovement.y < 0.0 && distanceFromGround < 10.0 && deltaMovement.length() < 4.0) {
                state.setAnimation(FLY_LAND);
                animationController.transitionLength(2);
            } else if (ServerFlightHandler.isSpin(player)) {
                state.setAnimation(FLY_SPIN);
                animationController.transitionLength(2);
            } else {
                if (movement.desiredMoveVec.y > 0.0) {
                    animationSpeed = 2.0;
                }
                state.setAnimation(FLY);
                animationController.transitionLength(2);
            }
        } else if (player.getPose() == Pose.SWIMMING) {
            if (ServerFlightHandler.isSpin(player)) {
                state.setAnimation(FLY_SPIN);
                animationController.transitionLength(2);
            } else {
                if (!(AnimationUtils.isAnimationPlaying(animationController, SWIM) || AnimationUtils.isAnimationPlaying(animationController, SWIM_FAST) || AnimationUtils.isAnimationPlaying(animationController, FLY_SPIN))) {
                    this.clearVerticalVelocity();
                }
                useDynamicScaling = true;
                baseSpeed = 0.13;
                state.setAnimation(SWIM_FAST);
                animationController.transitionLength(4);
            }
        } else if (isSwimming) {
            if (ServerFlightHandler.isSpin(player)) {
                animationSpeed = 2.0;
                state.setAnimation(FLY_SPIN);
                animationController.transitionLength(2);
            } else {
                if (!(AnimationUtils.isAnimationPlaying(animationController, SWIM) || AnimationUtils.isAnimationPlaying(animationController, SWIM_FAST) || AnimationUtils.isAnimationPlaying(animationController, FLY_SPIN))) {
                    this.clearVerticalVelocity();
                }
                useDynamicScaling = true;
                baseSpeed = 0.051;
                state.setAnimation(SWIM);
                animationController.transitionLength(2);
            }
        } else if (AnimationUtils.isAnimationPlaying(animationController, FLY_LAND)) {
            state.setAnimation(FLY_LAND_END);
            if (!FLY_LAND_END.getAnimationStages().isEmpty()) {
                this.animationTickTimer.putAnimation(DragonSurvivalClient.DRAGON_MODEL, this, FLY_LAND_END);
            }
            animationController.transitionLength(2);
        } else if (!(this.animationTickTimer.getDuration(FLY_LAND_END) > 0.0)) {
            if (player.onClimbable()) {
                if (movement.deltaMovement.y() < 0.0) {
                    state.setAnimation(CLIMBING_DOWN);
                } else {
                    state.setAnimation(CLIMBING_UP);
                }
                useDynamicScaling = true;
                baseSpeed = 1.0E-4;
                animationController.transitionLength(2);
            } else if (DRAGONS_JUMPING.getOrDefault(this.playerId, false).booleanValue()) {
                state.resetCurrentAnimation();
                state.setAnimation(JUMP);
                animationController.transitionLength(2);
                this.animationTickTimer.putAnimation(DragonSurvivalClient.DRAGON_MODEL, this, JUMP);
                DRAGONS_JUMPING.remove(this.playerId);
            } else if (!this.animationTickTimer.isPresent(JUMP) || !DRAGONS_JUMPING.getOrDefault(this.playerId, true).booleanValue()) {
                if (!player.onGround()) {
                    state.setAnimation(FALL_LOOP);
                    animationController.transitionLength(2);
                } else if (player.isShiftKeyDown() || !DragonSizeHandler.canPoseFit(player, Pose.STANDING) && DragonSizeHandler.canPoseFit(player, Pose.CROUCHING)) {
                    if (movement.isMovingHorizontally()) {
                        useDynamicScaling = true;
                        baseSpeed = 0.03;
                        state.setAnimation(SNEAK_WALK);
                        animationController.transitionLength(5);
                    } else if (movement.dig) {
                        state.setAnimation(DIG_SNEAK);
                        animationController.transitionLength(5);
                    } else {
                        state.setAnimation(SNEAK);
                        animationController.transitionLength(5);
                    }
                } else if (player.isSprinting()) {
                    useDynamicScaling = true;
                    baseSpeed = 0.165;
                    state.setAnimation(RUN);
                    animationController.transitionLength(4);
                } else if (movement.isMovingHorizontally()) {
                    useDynamicScaling = true;
                    state.setAnimation(WALK);
                    animationController.transitionLength(2);
                } else if (movement.dig) {
                    state.setAnimation(DIG);
                    animationController.transitionLength(6);
                } else {
                    state.setAnimation(IDLE);
                    animationController.transitionLength(2);
                }
            }
        }
        if (animationWasNullBeforePredicate) {
            animationController.transitionLength(0);
        }
        double finalAnimationSpeed = animationSpeed;
        if (useDynamicScaling) {
            double horizontalDistance = deltaMovement.horizontalDistance();
            double speedComponent = Math.min(ClientConfig.maxAnimationSpeedFactor, (horizontalDistance - baseSpeed) / baseSpeed * speedFactor);
            double sizeDistance = handler.getVisualScale(player, state.getPartialTick()) - 1.0;
            double sizeFactor = sizeDistance >= 0.0 ? bigSizeFactor : smallSizeFactor;
            double sizeComponent = 1.0 / (1.0 + sizeDistance * sizeFactor);
            finalAnimationSpeed = Math.min(ClientConfig.maxAnimationSpeed, Math.max(ClientConfig.minAnimationSpeed, (animationSpeed + speedComponent) * sizeComponent));
        }
        AnimationUtils.setAnimationSpeed(finalAnimationSpeed, state.getAnimationTick(), animationController);
        if (this.isPlayingAnyEmote()) {
            this.neckLocked = this.checkAllEmotes(DragonEmote::locksHead);
            this.tailLocked = this.checkAllEmotes(DragonEmote::locksTail);
        }
        if (this.currentAbilityAnimation != null) {
            this.neckLocked = ((AbilityAnimation)this.currentAbilityAnimation.getFirst()).locksHead();
            this.tailLocked = ((AbilityAnimation)this.currentAbilityAnimation.getFirst()).locksTail();
        }
        return PlayState.CONTINUE;
    }

    @SubscribeEvent
    public static void tickEntity(RenderFrameEvent.Pre event) {
        globalTickCount += (double)event.getPartialTick().getRealtimeDeltaTicks();
    }

    public double getTick(Object obj) {
        return (this.playerId != null ? (double)this.level().getEntity((int)this.playerId.intValue()).tickCount : globalTickCount) + 200.0;
    }

    @NotNull
    public Vec3 position() {
        Player player = this.getPlayer();
        if (player == null) {
            return super.position();
        }
        return player.position();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean shouldPlayAnimsWhileGamePaused() {
        return true;
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getArmorSlots();
        }
        return List.of();
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot slotIn) {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getItemBySlot(slotIn);
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(@NotNull EquipmentSlot slotIn, @NotNull ItemStack stack) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setItemSlot(slotIn, stack);
        }
    }

    @NotNull
    public HumanoidArm getMainArm() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getMainArm();
        }
        return HumanoidArm.LEFT;
    }

    static {
        BITE = RawAnimation.begin().thenLoop("bite");
        USE_ITEM_RIGHT = RawAnimation.begin().thenLoop("use_item_right");
        USE_ITEM_LEFT = RawAnimation.begin().thenLoop("use_item_left");
        EAT_ITEM_RIGHT = RawAnimation.begin().thenLoop("eat_item_right");
        EAT_ITEM_LEFT = RawAnimation.begin().thenLoop("eat_item_left");
        SIT_ON_MAGIC_SOURCE = RawAnimation.begin().thenLoop("sit_on_magic_source");
        SLEEP = RawAnimation.begin().thenLoop("sleep_left");
        SIT = RawAnimation.begin().thenLoop("sit");
        FLY = RawAnimation.begin().thenLoop("fly");
        FLY_SOARING = RawAnimation.begin().thenLoop("fly_soaring");
        FLY_DIVE = RawAnimation.begin().thenLoop("fly_dive");
        FLY_DIVE_ALT = RawAnimation.begin().thenLoop("fly_dive_alt");
        FLY_SPIN = RawAnimation.begin().thenLoop("fly_spin");
        FLY_LAND = RawAnimation.begin().thenLoop("fly_land");
        SWIM = RawAnimation.begin().thenLoop("swim");
        SWIM_FAST = RawAnimation.begin().thenLoop("swim_fast");
        FALL_LOOP = RawAnimation.begin().thenLoop("fall_loop");
        SNEAK = RawAnimation.begin().thenLoop("sneak");
        SNEAK_WALK = RawAnimation.begin().thenLoop("sneak_walk");
        DIG_SNEAK = RawAnimation.begin().thenLoop("dig_sneak");
        RUN = RawAnimation.begin().thenLoop("run");
        WALK = RawAnimation.begin().thenLoop("walk");
        IDLE = RawAnimation.begin().thenLoop("idle");
        DIG = RawAnimation.begin().thenLoop("dig");
        CLIMBING_UP = RawAnimation.begin().thenLoop("climbing_up");
        CLIMBING_DOWN = RawAnimation.begin().thenLoop("climbing_down");
        JUMP = RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE);
        FLY_LAND_END = RawAnimation.begin().then("fly_land_end", Animation.LoopType.PLAY_ONCE);
        CREATE_SKYHOOK_RIDING = RawAnimation.begin().thenLoop("create_skyhook_riding");
    }
}

