/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.goals;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FearData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber
public class DynamicAvoidEntityGoal
extends Goal {
    private static final int MAX_DISTANCE = 4096;
    private final PathfinderMob mob;
    private final TargetingConditions avoidCondition;
    private final PathNavigation navigation;
    private Path path;
    private Player toAvoid;
    private float walkSpeed;
    private float sprintSpeed;

    public DynamicAvoidEntityGoal(PathfinderMob mob) {
        this.mob = mob;
        this.avoidCondition = TargetingConditions.forCombat();
        this.navigation = mob.getNavigation();
    }

    @SubscribeEvent
    public static void attachGoal(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            mob.goalSelector.addGoal(5, (Goal)new DynamicAvoidEntityGoal(mob));
        }
    }

    public boolean canUse() {
        this.selectPlayer();
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 fleePosition = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.position());
        if (fleePosition == null) {
            return false;
        }
        if (this.toAvoid.distanceToSqr(fleePosition) < this.toAvoid.distanceToSqr((Entity)this.mob)) {
            return false;
        }
        this.path = this.navigation.createPath(BlockPos.containing((Position)fleePosition), 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.toAvoid != null) {
            return this.toAvoid.getExistingData(DSDataAttachments.FEAR).map(fear -> fear.getData((Entity)this.mob).distance() != -1).orElse(false);
        }
        return true;
    }

    public void start() {
        this.navigation.moveTo(this.path, (double)this.walkSpeed);
    }

    public void stop() {
        this.toAvoid = null;
    }

    public void tick() {
        if (this.mob.distanceToSqr((Entity)this.toAvoid) < 49.0) {
            this.mob.getNavigation().setSpeedModifier((double)this.sprintSpeed);
        } else {
            this.mob.getNavigation().setSpeedModifier((double)this.walkSpeed);
        }
    }

    private void selectPlayer() {
        double closestDistanceTo = 2.147483647E9;
        for (Player player : this.mob.level().players()) {
            FearData.Data data;
            double distanceTo;
            FearData fear = player.getExistingData(DSDataAttachments.FEAR).orElse(null);
            if (fear == null || (distanceTo = player.position().distanceToSqr(this.mob.position())) > closestDistanceTo || distanceTo > 4096.0 || (data = fear.getData((Entity)this.mob)).distance() == -1 || !this.avoidCondition.range((double)data.distance()).test((LivingEntity)this.mob, (LivingEntity)player)) continue;
            this.toAvoid = player;
            this.walkSpeed = data.walkSpeed();
            this.sprintSpeed = data.sprintSpeed();
        }
    }
}

