/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.compat.ModCheck;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.DietEntryCache;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DragonFoodHandler {
    @Translation(key="disable_dragon_food_handling", type=Translation.Type.CONFIGURATION, comments={"Disable all modifications that dragon survival does to the food system. Some mods will have this setting automatically enabled (such as TFC)."})
    @ConfigOption(side=ConfigSide.SERVER, category={"food"}, key="disable_dragon_food_handling")
    public static Boolean disableDragonFoodHandling = false;
    @Translation(key="dragon_food_is_required", type=Translation.Type.CONFIGURATION, comments={"Dragons will need to adhere to their diets if enabled"})
    @ConfigOption(side=ConfigSide.SERVER, category={"food"}, key="dragon_food_is_required")
    public static Boolean requireDragonFood = true;
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="bad_food_poison_chance", type=Translation.Type.CONFIGURATION, comments={"Chance of getting poisoned from eating non-dragon food"})
    @ConfigOption(side=ConfigSide.SERVER, category={"food"}, key="bad_food_poison_chance")
    public static Float badFoodPoisonChance = Float.valueOf(0.5f);

    public static boolean dragonFoodHandlingIsDisabled() {
        return disableDragonFoodHandling != false || ModCheck.isModLoaded("tfc");
    }

    @Nullable
    public static FoodProperties getDragonFoodProperties(Holder<DragonSpecies> species, ItemStack stack, @Nullable FoodProperties original) {
        if (DragonFoodHandler.dragonFoodHandlingIsDisabled()) {
            return original;
        }
        if (DietEntryCache.isEmpty(species)) {
            return original;
        }
        FoodProperties properties = DietEntryCache.getDiet(species, stack.getItem());
        if (properties != null) {
            return properties;
        }
        if (original != null) {
            if (requireDragonFood.booleanValue()) {
                return DragonFoodHandler.getBadFoodProperties();
            }
            return original;
        }
        return null;
    }

    public static boolean isEdible(Player player, ItemStack stack) {
        return stack.getFoodProperties((LivingEntity)player) != null;
    }

    public static int getUseDuration(ItemStack stack, Player entity, int original) {
        FoodProperties properties = DragonFoodHandler.getDragonFoodProperties(DragonStateProvider.getData(entity).species(), stack, null);
        if (properties != null) {
            return properties.eatDurationTicks();
        }
        return original;
    }

    @SubscribeEvent
    public static void setDragonFoodUseDuration(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity;
        if (DragonFoodHandler.dragonFoodHandlingIsDisabled() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (!data.isDragon() || !DragonFoodHandler.isEdible(player, event.getItem())) {
            return;
        }
        event.setDuration(DragonFoodHandler.getUseDuration(event.getItem(), player, event.getDuration()));
    }

    private static FoodProperties getBadFoodProperties() {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.effect(() -> new MobEffectInstance(MobEffects.HUNGER, 600, 0), 1.0f);
        builder.effect(() -> new MobEffectInstance(MobEffects.POISON, 600, 0), badFoodPoisonChance.floatValue());
        builder.nutrition(1);
        return builder.build();
    }
}

