/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ManaHandling;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ManaCost;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.ExperienceUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ManaHandler {
    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        MagicData magic = MagicData.getData(player);
        if (magic.isCasting()) {
            return;
        }
        if (magic.getCurrentMana() < ManaHandler.getMaxMana(player)) {
            ManaHandler.replenishMana(player, (float)player.getAttributeValue(DSAttributes.MANA_REGENERATION));
        }
    }

    public static boolean hasEnoughMana(Player player, float manaCost) {
        if (manaCost == 0.0f || player.hasEffect(DSEffects.SOURCE_OF_MAGIC) || player.hasInfiniteMaterials()) {
            return true;
        }
        if (ManaHandler.getMaxMana(player) == 0.0f) {
            return false;
        }
        return ManaHandler.getCurrentMana(player) + ManaHandler.getManaFromExperience(player) - manaCost >= 0.0f;
    }

    public static float getMaxMana(Player player) {
        float mana = (float)player.getAttributeValue(DSAttributes.MANA);
        mana += ManaHandler.getBonusManaFromExperience(player);
        return Math.max(0.0f, mana -= ManaHandler.getReservedMana(player));
    }

    public static void replenishMana(Player player, float mana) {
        MagicData data = MagicData.getData(player);
        data.setCurrentMana(Math.min(ManaHandler.getMaxMana(player), data.getCurrentMana() + mana));
    }

    public static void consumeMana(Player player, float manaCost) {
        if (manaCost == 0.0f || player == null || player.hasInfiniteMaterials() || player.hasEffect(DSEffects.SOURCE_OF_MAGIC)) {
            return;
        }
        float pureMana = ManaHandler.getCurrentMana(player);
        ManaHandling manaHandling = ((DragonSpecies)DragonStateProvider.getData(player).species().value()).manaHandling();
        if (manaHandling.manaXpConversion() > 0.0 && player.level().isClientSide() && pureMana < manaCost && ManaHandler.getCurrentMana(player) + ManaHandler.getManaFromExperience(player) >= manaCost) {
            player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.01f, 0.01f);
        }
        MagicData magic = MagicData.getData(player);
        if (manaHandling.manaXpConversion() > 0.0) {
            if (pureMana < manaCost) {
                float missingMana = pureMana - manaCost;
                player.giveExperiencePoints(ManaHandler.convertMana(missingMana, manaHandling.manaXpConversion()));
                magic.setCurrentMana(0.0f);
            } else {
                magic.setCurrentMana(pureMana - manaCost);
            }
        } else {
            magic.setCurrentMana(pureMana - manaCost);
        }
    }

    public static float getReservedMana(Player player) {
        float reservedMana = 0.0f;
        MagicData magic = MagicData.getData(player);
        for (DragonAbilityInstance ability : magic.getAbilities().values()) {
            if (!ability.isApplyingEffects()) continue;
            reservedMana += ability.getContinuousManaCost(ManaCost.ManaCostType.RESERVED);
        }
        return reservedMana;
    }

    public static float getCurrentMana(Player player) {
        return Math.min(MagicData.getData(player).getCurrentMana(), ManaHandler.getMaxMana(player));
    }

    public static float getBonusManaFromExperience(Player player) {
        ManaHandling manaHandling = ((DragonSpecies)DragonStateProvider.getData(player).species().value()).manaHandling();
        if (manaHandling.maxManaFromLevels() == 0.0) {
            return 0.0f;
        }
        return (float)Math.min(manaHandling.maxManaFromLevels(), (double)player.experienceLevel * manaHandling.manaPerLevel());
    }

    public static float getManaFromExperience(Player player) {
        ManaHandling manaHandling = ((DragonSpecies)DragonStateProvider.getData(player).species().value()).manaHandling();
        if (manaHandling.manaXpConversion() == 0.0) {
            return 0.0f;
        }
        return (float)((double)ExperienceUtils.getTotalExperience(player) * manaHandling.manaXpConversion());
    }

    private static int convertMana(float mana, double manaXpConversion) {
        double converted = (double)mana / manaXpConversion;
        if (converted > 0.0) {
            return Mth.ceil((double)converted);
        }
        if (converted < 0.0) {
            return Mth.floor((double)converted);
        }
        return 0;
    }
}

