/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.compat.jei;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonInventoryScreen;
import by.dragonsurvivalteam.dragonsurvival.compat.jei.DragonInventoryGUIHandler;
import by.dragonsurvivalteam.dragonsurvival.compat.jei.ModifierRenderingGUIHandler;
import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiRuntime runtime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"fix");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new DragonInventoryGUIHandler());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new ModifierRenderingGUIHandler());
        registration.addGuiContainerHandler(DragonInventoryScreen.class, (IGuiContainerHandler)new DragonInventoryGUIHandler());
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime runtime) {
        JEIPlugin.runtime = runtime;
    }

    public static boolean handleKeyPress(InputConstants.Key key, ItemStack stack) {
        RecipeIngredientRole role = null;
        if (runtime.getKeyMappings().getShowUses().isActiveAndMatches(key)) {
            role = RecipeIngredientRole.INPUT;
        } else if (runtime.getKeyMappings().getShowRecipe().isActiveAndMatches(key)) {
            role = RecipeIngredientRole.OUTPUT;
        }
        if (role == null) {
            return false;
        }
        ITypedIngredient ingredient = runtime.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack).orElse(null);
        if (ingredient == null) {
            return false;
        }
        IFocusFactory factory = runtime.getJeiHelpers().getFocusFactory();
        IFocus focus = factory.createFocus(role, ingredient);
        runtime.getRecipesGui().show(focus);
        return true;
    }
}

