/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.compat.sophisticatedBackpacks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.compat.ModCheck;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class DragonBackpackRenderLayer
extends GeoRenderLayer<DragonEntity> {
    @Translation(key="render_backpack", type=Translation.Type.CONFIGURATION, comments={"enable / disable backpack rendering"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_backpack")
    public static Boolean SHOULD_RENDER = true;
    @Translation(key="backpack_slot", type=Translation.Type.CONFIGURATION, comments={"The curios slot which may contain the backpack (if Curios is installed)"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="backpack_slot")
    public static String CURIOS_SLOT = "back";
    private static final String BONE = "BackpackBone";
    private final boolean isCurioLoaded = ModCheck.isModLoaded("curios");

    public DragonBackpackRenderLayer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
    }

    public void renderForBone(PoseStack poseStack, DragonEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!SHOULD_RENDER.booleanValue()) {
            return;
        }
        if (!bone.getName().equals(BONE)) {
            return;
        }
        Player player = animatable.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return;
        }
        ItemStack backpack = this.getBackpack(player);
        if (backpack == null) {
            return;
        }
        IBackpackWrapper wrapper = BackpackWrapper.fromStack((ItemStack)backpack);
        int clothColor = wrapper.getMainColor();
        int borderColor = wrapper.getAccentColor();
        IBackpackModel model = BackpackModelManager.getBackpackModel((Item)backpack.getItem());
        Vec3 posOffset = new Vec3((double)bone.getPivotX(), (double)bone.getPivotY(), (double)bone.getPivotZ());
        Vec3 rotOffset = Vec3.ZERO;
        Vec3 scale = new Vec3(1.0, 1.0, 1.0);
        if (((DragonBody)handler.body().value()).backpackOffsets().isPresent()) {
            DragonBody.BackpackOffsets backpackOffsets = ((DragonBody)handler.body().value()).backpackOffsets().get();
            scale = backpackOffsets.scale();
            posOffset = posOffset.add(backpackOffsets.posOffset());
            rotOffset = backpackOffsets.rotOffset();
        }
        poseStack.pushPose();
        this.transformModel(poseStack, posOffset.scale(0.03125), rotOffset, scale);
        model.render(null, (LivingEntity)player, poseStack, bufferSource, packedLight, clothColor, borderColor, backpack.getItem(), wrapper.getRenderInfo());
        poseStack.popPose();
    }

    private void transformModel(PoseStack poseStack, Vec3 posOffset, Vec3 rotOffset, Vec3 scale) {
        Vec3 rot = rotOffset.add(0.0, 0.0, 180.0);
        Quaternionf quat = new Quaternionf().rotationZYX((float)Math.toRadians((double)rot.x), (float)Math.toRadians((double)rot.y), (float)Math.toRadians((double)rot.z));
        poseStack.rotateAround(quat, 0.0f, 1.1f, 0.0f);
        poseStack.translate(posOffset.x, -posOffset.y + 0.5, -posOffset.z - 0.1);
        poseStack.scale((float)scale.x, (float)scale.y, (float)scale.z);
    }

    @Nullable
    private ItemStack getBackpack(Player player) {
        ItemStack backpack = null;
        if (this.isCurioLoaded) {
            backpack = this.getBackpackFromCurios(player);
        }
        if (backpack == null) {
            return this.getBackpackFromChestSlot(player);
        }
        return backpack;
    }

    @Nullable
    private ItemStack getBackpackFromCurios(Player player) {
        if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            List curioBackSlots = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).findCurios(new String[]{CURIOS_SLOT});
            for (SlotResult slotItem : curioBackSlots) {
                if (!slotItem.slotContext().visible()) continue;
                ItemStack stack = slotItem.stack();
                if (stack.getItem() instanceof BackpackItem) {
                    return stack;
                }
                return null;
            }
        }
        return null;
    }

    private ItemStack getBackpackFromChestSlot(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack.getItem() instanceof BackpackItem) {
            return stack;
        }
        return null;
    }
}

