/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.sound;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record StartTickingSound(int playerId, SoundEvent soundEvent, ResourceLocation id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StartTickingSound> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("start_ticking_sound"));
    public static final StreamCodec<FriendlyByteBuf, StartTickingSound> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StartTickingSound::playerId, (StreamCodec)SoundEvent.DIRECT_STREAM_CODEC, StartTickingSound::soundEvent, (StreamCodec)ResourceLocation.STREAM_CODEC, StartTickingSound::id, StartTickingSound::new);

    public static void handleClient(StartTickingSound packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = context.player().level().getEntity(packet.playerId());
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            DragonSurvival.PROXY.queueTickingSound(packet.id(), packet.soundEvent(), SoundSource.PLAYERS, (Entity)player);
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

