/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.syncing;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.DSModifiers;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncComplete(int playerId, CompoundTag data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncComplete> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_complete"));
    public static final StreamCodec<FriendlyByteBuf, SyncComplete> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncComplete::playerId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncComplete::data, SyncComplete::new);

    public static void handleDragonSync(ServerPlayer player, boolean refreshMagicData) {
        PenaltySupply.clear((Player)player);
        DSModifiers.updateAllModifiers((Player)player);
        player.refreshDimensions();
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        handler.setGrowth((Player)player, handler.getGrowth(), true);
        if (refreshMagicData) {
            handler.refreshMagicData(player, true);
        }
        if (handler.isDragon()) {
            DSAdvancementTriggers.BE_DRAGON.get().trigger(player);
        }
    }

    public static void handleClient(SyncComplete packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                DragonStateHandler handler = DragonStateProvider.getData(player);
                handler.deserializeNBT((HolderLookup.Provider)player.registryAccess(), packet.data());
                player.refreshDimensions();
            }
        });
    }

    public static void handleServer(SyncComplete packet, IPayloadContext context) {
        ((CompletableFuture)context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            Holder<DragonSpecies> previousType = handler.species();
            handler.deserializeNBT((HolderLookup.Provider)player.registryAccess(), packet.data());
            SyncComplete.handleDragonSync(player, false);
            if (!handler.isDragon()) {
                PenaltySupply.clear((Player)player);
                DSModifiers.clearModifiers((Player)player);
                handler.refreshMagicData(player, false);
                return;
            }
            if (previousType == null || !previousType.is(handler.species())) {
                PenaltySupply.clear((Player)player);
                handler.refreshMagicData(player, false);
            }
        }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)context.player(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]))).thenAccept(ignored -> context.reply((CustomPacketPayload)RequestClientData.INSTANCE));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

