/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.BlockVision;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class BlockVisionData
extends Storage<BlockVision.Instance> {
    private final Map<Block, CacheEntry> cache = new HashMap<Block, CacheEntry>();
    private int maximumRange = -1;

    public int getRange(@Nullable Block block) {
        if (block == null) {
            if (this.maximumRange == -1) {
                this.maximumRange = this.storeRange(null);
            }
            return this.maximumRange;
        }
        return this.cache.computeIfAbsent(block, this::storeData).range();
    }

    public int getColor(Block block) {
        return Functions.lerpColor(this.cache.computeIfAbsent(block, this::storeData).colors());
    }

    public List<Integer> getColors(Block block) {
        return this.cache.computeIfAbsent(block, this::storeData).colors();
    }

    public BlockVision.DisplayType getDisplayType(Block block) {
        return this.cache.computeIfAbsent(block, this::storeData).displayType();
    }

    private CacheEntry storeData(Block block) {
        return new CacheEntry(this.storeRange(block), this.storeColor(block), this.storeDisplayType(block));
    }

    private int storeRange(@Nullable Block block) {
        int currentRange = 0;
        for (BlockVision.Instance instance : this.all()) {
            int range = instance.getRange(block);
            if (range <= currentRange) continue;
            currentRange = range;
        }
        return currentRange;
    }

    private List<Integer> storeColor(Block block) {
        for (BlockVision.Instance instance : this.all()) {
            List<Integer> colors = instance.getColors(block);
            if (colors.isEmpty()) continue;
            return colors;
        }
        return List.of();
    }

    private BlockVision.DisplayType storeDisplayType(Block block) {
        for (BlockVision.Instance instance : this.all()) {
            BlockVision.DisplayType displayType = instance.getDisplayType(block);
            if (displayType == BlockVision.DisplayType.NONE) continue;
            return displayType;
        }
        return BlockVision.DisplayType.NONE;
    }

    @Override
    public void invalidateCache() {
        this.cache.clear();
        this.maximumRange = -1;
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getExistingData(DSDataAttachments.BLOCK_VISION).ifPresent(storage -> {
                storage.tick((Entity)player);
                if (storage.isEmpty()) {
                    player.removeData(DSDataAttachments.BLOCK_VISION);
                }
            });
        }
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, BlockVision.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected BlockVision.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return BlockVision.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.BLOCK_VISION.value();
    }

    record CacheEntry(int range, List<Integer> colors, BlockVision.DisplayType displayType) {
    }
}

