/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.DamageModification;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import java.util.Iterator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class DamageModifications
extends Storage<DamageModification.Instance> {
    public boolean isFireImmune() {
        if (this.storage == null) {
            return false;
        }
        return this.storage.values().stream().anyMatch(DamageModification.Instance::isFireImmune);
    }

    public float calculate(Holder<DamageType> damageType, float damageAmount) {
        DamageModification.Instance modification;
        if (this.storage == null) {
            return damageAmount;
        }
        float newDamageAmount = damageAmount;
        Iterator iterator = this.storage.values().iterator();
        while (iterator.hasNext() && (newDamageAmount = (modification = (DamageModification.Instance)iterator.next()).calculate(damageType, newDamageAmount)) != 0.0f) {
        }
        return newDamageAmount;
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.DAMAGE_MODIFICATIONS).ifPresent(data -> {
            data.tick(event.getEntity());
            if (data.isEmpty()) {
                event.getEntity().removeData(DSDataAttachments.DAMAGE_MODIFICATIONS);
            }
        });
    }

    @SubscribeEvent
    public static void checkImmunity(EntityInvulnerabilityCheckEvent event) {
        if (event.isInvulnerable()) {
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.DAMAGE_MODIFICATIONS).ifPresent(modifications -> {
            if (modifications.calculate((Holder<DamageType>)event.getSource().typeHolder(), 1.0f) == 0.0f) {
                event.setInvulnerable(true);
            }
        });
    }

    @SubscribeEvent
    public static void reduceDamage(LivingIncomingDamageEvent event) {
        event.getEntity().getExistingData(DSDataAttachments.DAMAGE_MODIFICATIONS).ifPresent(modifications -> event.setAmount(modifications.calculate((Holder<DamageType>)event.getSource().typeHolder(), event.getAmount())));
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, DamageModification.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected DamageModification.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return DamageModification.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.DAMAGE_MODIFICATIONS.get();
    }
}

