/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

@EventBusSubscriber
public class EffectsMaintainedThroughDeath
implements INBTSerializable<CompoundTag> {
    private final List<MobEffectInstance> effectsToReapplyOnDeath = new ArrayList<MobEffectInstance>();

    public static EffectsMaintainedThroughDeath getData(Player player) {
        return (EffectsMaintainedThroughDeath)player.getData(DSDataAttachments.EFFECTS_MAINTAINED_THROUGH_DEATH);
    }

    public void addEffect(MobEffectInstance effect) {
        this.effectsToReapplyOnDeath.add(effect);
    }

    public List<MobEffectInstance> getEffectsToReapplyOnDeath() {
        return this.effectsToReapplyOnDeath;
    }

    @SubscribeEvent
    public static void reapplyEffectsOnRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        EffectsMaintainedThroughDeath effectsMaintainedThroughDeath = EffectsMaintainedThroughDeath.getData(player);
        for (MobEffectInstance effect : effectsMaintainedThroughDeath.getEffectsToReapplyOnDeath()) {
            player.addEffect(effect);
        }
        effectsMaintainedThroughDeath.getEffectsToReapplyOnDeath().clear();
    }

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.effectsToReapplyOnDeath.size(); ++i) {
            tag.put("effect" + i, this.effectsToReapplyOnDeath.get(i).save());
        }
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        this.effectsToReapplyOnDeath.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            this.effectsToReapplyOnDeath.add(MobEffectInstance.load((CompoundTag)nbt.getCompound("effect" + i)));
        }
    }
}

