/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class EnderDragonDamageHistory
implements INBTSerializable<CompoundTag> {
    private final Map<UUID, Float> damageHistory = new HashMap<UUID, Float>();

    public static EnderDragonDamageHistory getData(EnderDragon dragon) {
        return (EnderDragonDamageHistory)dragon.getData(DSDataAttachments.ENDER_DRAGON_DAMAGE_HISTORY);
    }

    public void addDamage(UUID uuid, float damage) {
        this.damageHistory.computeIfPresent(uuid, (key, value) -> Float.valueOf(value.floatValue() + damage));
        this.damageHistory.putIfAbsent(uuid, Float.valueOf(damage));
        this.damageHistory.entrySet().removeIf(entry -> ((Float)entry.getValue()).floatValue() <= 0.0f);
    }

    public void addDamageAll(float damage) {
        this.damageHistory.replaceAll((uuid, value) -> Float.valueOf(value.floatValue() + damage));
        this.damageHistory.entrySet().removeIf(entry -> ((Float)entry.getValue()).floatValue() <= 0.0f);
    }

    public float getDamage(UUID uuid) {
        return this.damageHistory.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue();
    }

    public List<Player> getPlayers(Level level) {
        return this.damageHistory.keySet().stream().map(arg_0 -> ((Level)level).getPlayerByUUID(arg_0)).toList();
    }

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.damageHistory.forEach((uuid, damage) -> nbt.putFloat(uuid.toString(), damage.floatValue()));
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.damageHistory.clear();
        nbt.getAllKeys().forEach(uuid -> this.damageHistory.put(UUID.fromString(uuid), Float.valueOf(nbt.getFloat(uuid))));
    }
}

