/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.HarvestBonus;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class HarvestBonuses
extends Storage<HarvestBonus.Instance> {
    public float getBaseSpeed(BlockState state) {
        if (this.storage == null) {
            return HarvestBonus.BASE_SPEED;
        }
        float baseSpeed = HarvestBonus.BASE_SPEED;
        for (HarvestBonus.Instance instance : this.storage.values()) {
            float speed = instance.getBaseSpeed(state);
            if (!(speed > baseSpeed)) continue;
            baseSpeed = speed;
        }
        return baseSpeed;
    }

    public int getHarvestBonus(BlockState state) {
        if (this.storage == null) {
            return HarvestBonus.NO_BONUS_VALUE;
        }
        int bonus = HarvestBonus.NO_BONUS_VALUE;
        for (HarvestBonus.Instance instance : this.storage.values()) {
            bonus += instance.getHarvestBonus(state);
        }
        return bonus;
    }

    public float getSpeedMultiplier(BlockState state) {
        if (this.storage == null) {
            return 1.0f;
        }
        float multiplier = 1.0f;
        for (HarvestBonus.Instance instance : this.storage.values()) {
            multiplier += instance.getSpeedMultiplier(state);
        }
        return multiplier;
    }

    public static boolean canHarvest(Player player, BlockState state, ItemStack tool) {
        int bonus = player.getExistingData(DSDataAttachments.HARVEST_BONUSES).map(data -> data.getHarvestBonus(state)).orElse(HarvestBonus.NO_BONUS_VALUE);
        if (ToolUtils.isCorrectTool(tool, state)) {
            return bonus + ToolUtils.toolToHarvestLevel(tool) >= ToolUtils.getRequiredHarvestLevel(state);
        }
        return bonus >= ToolUtils.getRequiredHarvestLevel(state);
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getExistingData(DSDataAttachments.HARVEST_BONUSES).ifPresent(storage -> {
                storage.tick(event.getEntity());
                if (storage.isEmpty()) {
                    player.removeData(DSDataAttachments.HARVEST_BONUSES);
                }
            });
        }
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, HarvestBonus.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected HarvestBonus.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return HarvestBonus.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.HARVEST_BONUSES.get();
    }
}

