/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class ItemData
implements INBTSerializable<CompoundTag> {
    public boolean isFireImmune;
    public double smeltingTime;
    public double smeltingProgress;
    private double previousSmeltingProgress;
    private int noSmeltingChange;
    public static final String IS_FIRE_IMMUNE = "is_fire_immune";
    public static final String SMELTING_TIME = "is_fire_immune";
    public static final String SMELTING_PROGRESS = "is_fire_immune";

    @SubscribeEvent
    public static void handleSmelting(EntityTickEvent.Post event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        event.getEntity().getExistingData(DSDataAttachments.ITEM).ifPresent(data -> {
            if (data.smeltingTime == 0.0) {
                return;
            }
            if (data.smeltingProgress == data.previousSmeltingProgress) {
                ++data.noSmeltingChange;
                if ((double)data.noSmeltingChange == Functions.ticksToSeconds(3)) {
                    data.smeltingProgress = 0.0;
                    data.noSmeltingChange = 0;
                }
            } else {
                data.noSmeltingChange = 0;
            }
            data.previousSmeltingProgress = data.smeltingProgress;
            if (event.getEntity().tickCount % 10 == 0) {
                int amount = (int)Math.max(1.0, 10.0 * (data.smeltingProgress / data.smeltingTime));
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, event.getEntity().getX(), event.getEntity().getY() + 0.5, event.getEntity().getZ(), amount, 0.0, 0.0, 0.0, 0.0);
            }
        });
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("is_fire_immune", this.isFireImmune);
        tag.putDouble("is_fire_immune", this.smeltingTime);
        tag.putDouble("is_fire_immune", this.smeltingProgress);
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.isFireImmune = tag.getBoolean("is_fire_immune");
        this.smeltingTime = tag.getDouble("is_fire_immune");
        this.smeltingProgress = tag.getDouble("is_fire_immune");
    }
}

