/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.StorageEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Storage<T extends StorageEntry>
implements INBTSerializable<CompoundTag> {
    public static final String STORAGE = "storage";
    @Nullable
    protected Map<ResourceLocation, T> storage;

    public void sync(ServerPlayer player) {
        player.getExistingData(this.type()).ifPresent(data -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncData(player.getId(), NeoForgeRegistries.ATTACHMENT_TYPES.getKey(this.type()), this.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public void tick(Entity storageHolder) {
        if (this.storage != null) {
            ArrayList finished = new ArrayList();
            this.storage.values().forEach(entry -> {
                if (entry.tick(storageHolder)) {
                    finished.add(entry.id());
                }
            });
            finished.forEach(id -> {
                StorageEntry removed = (StorageEntry)this.storage.remove(id);
                if (removed != null) {
                    removed.onRemovalFromStorage(storageHolder);
                }
            });
            if (!finished.isEmpty()) {
                this.invalidateCache();
            }
        }
    }

    public void add(Entity storageHolder, T entry) {
        if (this.storage == null) {
            this.storage = new HashMap<ResourceLocation, T>();
        }
        this.storage.put(entry.id(), entry);
        entry.onAddedToStorage(storageHolder);
        this.invalidateCache();
    }

    public void remove(Entity storageHolder, T entry) {
        if (this.storage == null || entry == null) {
            return;
        }
        this.storage.remove(entry.id());
        entry.onRemovalFromStorage(storageHolder);
        this.invalidateCache();
    }

    @Nullable
    public T get(ResourceLocation id) {
        if (this.storage == null) {
            return null;
        }
        return (T)((StorageEntry)this.storage.get(id));
    }

    public Collection<T> all() {
        if (this.storage == null) {
            return List.of();
        }
        return this.storage.values();
    }

    public void clear(Entity storageHolder) {
        if (this.storage == null || storageHolder.level().isClientSide()) {
            return;
        }
        ArrayList<StorageEntry> cleared = new ArrayList<StorageEntry>(this.storage.values());
        this.storage.clear();
        cleared.forEach(entry -> entry.onRemovalFromStorage(storageHolder));
        this.invalidateCache();
        storageHolder.removeData(this.type());
    }

    public int size() {
        if (this.storage == null) {
            return 0;
        }
        return this.storage.size();
    }

    public boolean isEmpty() {
        if (this.storage == null) {
            return true;
        }
        return this.storage.isEmpty();
    }

    public void invalidateCache() {
    }

    public boolean isType(Class<?> type) {
        if (this.isEmpty()) {
            return false;
        }
        return type.isInstance(this.storage.values().iterator().next());
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.storage == null) {
            return tag;
        }
        ListTag entries = new ListTag();
        this.storage.values().forEach(entry -> entries.add((Object)this.save(provider, entry)));
        tag.put(STORAGE, (Tag)entries);
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        HashMap<ResourceLocation, T> storage = new HashMap<ResourceLocation, T>();
        ListTag entries = tag.getList(STORAGE, 10);
        for (int i = 0; i < entries.size(); ++i) {
            T entry = this.load(provider, entries.getCompound(i));
            if (entry == null) continue;
            storage.put(entry.id(), entry);
        }
        this.storage = !storage.isEmpty() ? storage : null;
        this.invalidateCache();
    }

    public abstract AttachmentType<?> type();

    protected abstract Tag save(@NotNull HolderLookup.Provider var1, T var2);

    protected abstract T load(@NotNull HolderLookup.Provider var1, CompoundTag var2);
}

