/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tiers;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.text.WordUtils;
import org.objectweb.asm.Type;

public class DSLanguageProvider
extends LanguageProvider {
    private final String locale;
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DSLanguageProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, String locale) {
        super(output, "dragonsurvival", locale);
        this.lookup = lookup;
        this.locale = locale;
    }

    public static Component enumClass(Enum<?> enumValue) {
        return Component.translatable((String)DSLanguageProvider.enumClassKey(enumValue));
    }

    public static Component enumValue(Enum<?> enumValue) {
        return Component.translatable((String)(DSLanguageProvider.enumClassKey(enumValue) + "." + enumValue.name().toLowerCase(Locale.ENGLISH)));
    }

    private static String enumClassKey(Enum<?> enumValue) {
        return DSLanguageProvider.enumClassKey(enumValue.getClass());
    }

    private static String enumValueKey(Enum<?> enumValue) {
        return DSLanguageProvider.enumClassKey(enumValue) + "." + enumValue.name().toLowerCase(Locale.ENGLISH);
    }

    private static String enumClassKey(Class<?> classType) {
        return "enum." + classType.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.ENGLISH);
    }

    protected void addTranslations() {
        Set annotationDataSet = ModList.get().getModFileById("dragonsurvival").getFile().getScanResult().getAnnotations();
        this.handleTranslationAnnotations(annotationDataSet);
        this.handleConfigCategories(annotationDataSet);
        this.handleVanilla();
        this.handleParts();
        this.add(Tags.getTagTranslationKey(DSItemTags.key(LangKey.FOOD.apply(BuiltInDragonSpecies.CAVE_DRAGON.location()))), "Cave Dragon Food");
        this.add(Tags.getTagTranslationKey(DSItemTags.key(LangKey.FOOD.apply(BuiltInDragonSpecies.FOREST_DRAGON.location()))), "Forest Dragon Food");
        this.add(Tags.getTagTranslationKey(DSItemTags.key(LangKey.FOOD.apply(BuiltInDragonSpecies.SEA_DRAGON.location()))), "Sea Dragon Food");
    }

    private void handleVanilla() {
        for (ResourceKey damageType : ResourceHelper.keys(this.lookup.join(), Registries.DAMAGE_TYPE)) {
            this.add(Translation.Type.DAMAGE_TYPE.wrap(damageType.location()), this.capitalize(damageType.location().getPath()));
        }
        for (Tiers tier : Tiers.values()) {
            this.add(DSLanguageProvider.enumValueKey(tier), this.capitalize(tier.name().toLowerCase(Locale.ENGLISH)));
        }
        this.add(Tags.getTagTranslationKey((TagKey)DamageTypeTags.IS_FIRE), "Fire");
        this.add(Tags.getTagTranslationKey((TagKey)BlockTags.MINEABLE_WITH_PICKAXE), "Mineable with Pickaxe");
        this.add(Tags.getTagTranslationKey((TagKey)BlockTags.MINEABLE_WITH_AXE), "Mineable with Axe");
        this.add(Tags.getTagTranslationKey((TagKey)BlockTags.MINEABLE_WITH_SHOVEL), "Mineable with Shovel");
    }

    private void handleTranslationAnnotations(Set<ModFileScanData.AnnotationData> annotationDataSet) {
        Type translationType = Type.getType(Translation.class);
        for (ModFileScanData.AnnotationData annotationData : annotationDataSet) {
            String locale;
            if (!annotationData.annotationType().equals((Object)translationType) || (locale = (String)annotationData.annotationData().get("locale")) != null && !locale.equals(this.locale)) continue;
            String key = (String)annotationData.annotationData().get("key");
            Optional<ModAnnotation.EnumHolder> optionalEnum = Optional.ofNullable((ModAnnotation.EnumHolder)annotationData.annotationData().get("type"));
            Translation.Type type = optionalEnum.map(holder -> Translation.Type.valueOf(holder.value())).orElse(Translation.Type.NONE);
            List comments = (List)annotationData.annotationData().get("comments");
            if (key == null && annotationData.targetType() == ElementType.FIELD) {
                try {
                    String translationKey;
                    Field field = Class.forName(annotationData.clazz().getClassName()).getDeclaredField(annotationData.memberName());
                    field.setAccessible(true);
                    if (Holder.class.isAssignableFrom(field.getType())) {
                        Holder holder2 = (Holder)field.get(null);
                        this.add(type.wrap(holder2.getKey().location().getPath()), this.format(comments));
                        continue;
                    }
                    if (TagKey.class.isAssignableFrom(field.getType())) {
                        TagKey tag = (TagKey)field.get(null);
                        this.add(Tags.getTagTranslationKey((TagKey)tag), this.format(comments));
                        continue;
                    }
                    if (ResourceKey.class.isAssignableFrom(field.getType())) {
                        ResourceKey resourceKey = (ResourceKey)field.get(null);
                        this.add(type.wrap(resourceKey.location().getPath()), this.format(comments));
                        continue;
                    }
                    if (ResourceLocation.class.isAssignableFrom(field.getType())) {
                        ResourceLocation resourceLocation = (ResourceLocation)field.get(null);
                        this.add(type.wrap(resourceLocation.getPath()), this.format(comments));
                        continue;
                    }
                    if (type == Translation.Type.NONE && String.class.isAssignableFrom(field.getType())) {
                        translationKey = (String)field.get(null);
                        this.add(translationKey, this.format(comments));
                        continue;
                    }
                    if (type == Translation.Type.EMOTE && String.class.isAssignableFrom(field.getType())) {
                        translationKey = (String)field.get(null);
                        this.add(type.wrap(translationKey), this.format(comments));
                        continue;
                    }
                    if ((type == Translation.Type.ADVANCEMENT || type == Translation.Type.ADVANCEMENT_DESCRIPTION) && String.class.isAssignableFrom(field.getType())) {
                        String path = (String)field.get(null);
                        this.add(type.wrap(path), this.format(comments));
                        continue;
                    }
                    if (field.getType().isEnum()) {
                        Enum value = (Enum)field.get(null);
                        if (type == Translation.Type.NONE) {
                            this.add(DSLanguageProvider.enumValueKey(value), this.format(comments));
                            continue;
                        }
                        this.add(type.wrap(value.name().toLowerCase(Locale.ENGLISH)), this.format(comments));
                        continue;
                    }
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("An error occurred while trying to get the translations from [" + String.valueOf(annotationData) + "]", exception);
                }
            }
            if (key == null && annotationData.targetType() == ElementType.TYPE) {
                try {
                    Class<?> classType = Class.forName(annotationData.memberName());
                    if (classType.isEnum()) {
                        this.add(DSLanguageProvider.enumClassKey(classType), this.format(comments));
                        continue;
                    }
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("An error occurred while trying to get the translations from [" + String.valueOf(annotationData) + "]", exception);
                }
            }
            if (key == null || key.isEmpty()) {
                throw new IllegalStateException("Empty keys are not supported on that field type - annotation data: [" + String.valueOf(annotationData) + "]");
            }
            try {
                this.add(type.wrap(key), this.format(comments));
            }
            catch (IllegalStateException exception) {
                DragonSurvival.LOGGER.error("Invalid translation entry due to a duplicate key issue [{}]", (Object)annotationData);
                throw exception;
            }
            if (type != Translation.Type.CONFIGURATION) continue;
            String capitalized = this.capitalize(key);
            if (capitalized.length() > 25) {
                DragonSurvival.LOGGER.warn("Translation [{}] for the key [{}] might be too long for the configuration screen", (Object)capitalized, (Object)key);
            }
            this.add(type.prefix + key, capitalized);
        }
    }

    private void handleConfigCategories(Set<ModFileScanData.AnnotationData> annotationDataSet) {
        Type configOptionType = Type.getType(ConfigOption.class);
        ArrayList categoriesAdded = new ArrayList();
        for (ModFileScanData.AnnotationData annotationData : annotationDataSet) {
            if (!annotationData.annotationType().equals((Object)configOptionType)) continue;
            List<String> categories = (List<String>)annotationData.annotationData().get("category");
            if (categories == null || categories.isEmpty()) {
                categories = List.of("general");
            }
            categories.forEach(category -> {
                if (categoriesAdded.contains(category)) {
                    return;
                }
                categoriesAdded.add(category);
                String key = LangKey.CATEGORY_PREFIX + category;
                this.add(key, this.capitalize((String)category));
            });
        }
    }

    public static List<Translation> getTranslations(Field field) {
        Translation translation = field.getAnnotation(Translation.class);
        if (translation != null) {
            return List.of(translation);
        }
        Translation.Translations translations = field.getAnnotation(Translation.Translations.class);
        if (translations != null) {
            return List.of(translations.value());
        }
        return List.of();
    }

    private String format(List<String> comments) {
        return this.format(comments.toArray(new String[0]));
    }

    private String format(String ... comments) {
        StringBuilder comment = new StringBuilder();
        for (int line = 0; line < comments.length; ++line) {
            comment.append(comments[line]);
            if (line == comments.length - 1) continue;
            comment.append("\n");
        }
        return comment.toString();
    }

    private String capitalize(String snakeCaseString) {
        return this.capitalize(snakeCaseString.split("_"));
    }

    private String capitalize(String ... components) {
        if (components.length == 1) {
            return WordUtils.capitalize((String)components[0]);
        }
        StringBuilder capitalized = new StringBuilder();
        for (int i = 0; i < components.length; ++i) {
            capitalized.append(WordUtils.capitalize((String)components[i]));
            if (i == components.length - 1) continue;
            capitalized.append(" ");
        }
        return capitalized.toString();
    }

    private void handleParts() {
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.none"), "");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.none"), "");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.none"), "");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_1"), "Dragon");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_2"), "Large Pupils");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_3"), "Observer");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_4"), "Cute");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_5"), "Snake");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_6"), "Drake");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_7"), "Rounded");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_8"), "Gecko");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_9"), "Curious");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_10"), "Crocodile");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_11"), "Surprised");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_12"), "Blank");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_13"), "Narrow");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_14"), "Simple");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_15"), "Raised");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_16"), "Layered");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_17"), "Empathic");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_18"), "Faded");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_19"), "Fresh");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_20"), "Square");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_21"), "Eccentric");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_22"), "Smoke");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_23"), "Pupil");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_24"), "Gritty");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_25"), "Dark");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_26"), "Glitter");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_27"), "Twinkle");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_28"), "Slanted");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_29"), "Diagonal");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_30"), "Chain");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_31"), "Hourglass");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_32"), "Lozenge");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_33"), "Triangle");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_34"), "Lizard");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_35"), "Frog");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_36"), "Crescent");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_37"), "Wave");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_38"), "Sclera");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_39"), "Pale");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_40"), "Dim");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_41"), "Spark");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_42"), "Light");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_43"), "Cross");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_44"), "Unusual");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_45"), "Quadro");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_46"), "Lens");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_47"), "Cog");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_48"), "Multicolor");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_49"), "Sharp");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_50"), "Keen");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_51"), "Gradient");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_52"), "Radiant");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_53"), "Blackhole");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_54"), "Striped");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_55"), "Beetle");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_56"), "Possessed");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_57"), "Spiral");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_58"), "Hypno");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_59"), "Gem");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_60"), "Spectre");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_61"), "Rainbow");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_62"), "Fear");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_63"), "Amphibian");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_64"), "Fish");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_65"), "Pretty");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_66"), "Heart");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_67"), "Star");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.eyes_68"), "Evil");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_1"), "Stone Body");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_2"), "Fire Clay");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_3"), "Charred Rock");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_4"), "Stony Dirt");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_5"), "Marble Body");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_6"), "Scales of Fire");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_7"), "Large Scales");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_8"), "Ancient Scales");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.base_9"), "Asbestos Fur");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_1"), "Smooth Plates");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_2"), "Large Plates");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_3"), "Fire Plates");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_4"), "Lava Eater");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_5"), "Fire Plates");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_6"), "Glowing Furnace");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.bottom_7"), "Asbestos");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_1"), "Crown");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_2"), "Beak");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_3"), "Nose Axe");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_4"), "Jaw Muscles");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_5"), "Tongue");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_6"), "Soft Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_7"), "Regular Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_8"), "Fur Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_9"), "Warden Tail");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_10"), "Warden Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.all_extra_11"), "Warden Body");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_1"), "Speleothems");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_2"), "Trike Frill");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_3"), "Pointy Ears");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_4"), "Straight Ears");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_body_1"), "Amethyst Outgrowths");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_body_2"), "Lava Side");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_body_3"), "Lava Back");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_body_4"), "Lava Back Stains");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_jewelry_1"), "Saddle");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_jewelry_2"), "Saddle with Supplies");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_jewelry_3"), "Rings Gold");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_jewelry_4"), "Rings Copper");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_jewelry_5"), "Collar");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_moustache_1"), "Small Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_moustache_2"), "Big Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_mouth_1"), "Lava Mouth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_mouth_2"), "Hot Mouth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_paws_1"), "Stone Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_paws_2"), "Hot Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_paws_3"), "Lava Paws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_tail_1"), "Little Mace");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_tail_2"), "Medium Mace");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_tail_3"), "Big Mace");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_tail_4"), "Dedicurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_tail_5"), "Ankylosaurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_1"), "Lava Feather Wings");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_2"), "Stone Wings");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_3"), "Stone Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_4"), "Stone Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_5"), "Amethyst Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_6"), "Amethyst Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_7"), "Lava Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_8"), "Lava Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_extra_wings_9"), "Star Wings");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_1"), "Fire Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_2"), "Stone Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_3"), "Sharp Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_4"), "Parrot Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_5"), "Amethyst Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_6"), "Smaller Dots");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_fins_7"), "Blazing Wings");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_1"), "Thorn Brows");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_2"), "Twisted Brows");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_3"), "Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_4"), "Twisted Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_5"), "Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_6"), "Twisted Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_7"), "Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_8"), "Twisted Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_9"), "Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_10"), "Twisted Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_11"), "Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_12"), "Twisted Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_13"), "Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_14"), "Twisted Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_15"), "Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_16"), "Twisted Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_17"), "Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_18"), "Twisted Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_19"), "Black Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.extra_horns_20"), "Black Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_1"), "Mechanisms");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_2"), "Swords");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_3"), "Arrows");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_4"), "Meander");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_5"), "Time");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.cave_magic_6"), "Echo");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_1"), "Small Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_2"), "Regular Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_3"), "Small Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_4"), "Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_5"), "Boars Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_6"), "Regular Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_7"), "Lower Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_8"), "Two Rows Of Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_9"), "Crooked Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_10"), "Crooked Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_11"), "Evil Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.teeth_12"), "Chinese Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_1"), "Three Red Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_2"), "Scabrous Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_3_cave"), "Cave Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_3_cave_1"), "Cave Newborn Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_3_cave_2"), "Cave Young Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_3_cave_3"), "Cave Adult Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_4"), "Huge Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_5"), "Square Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_6"), "Sharp Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.claw_7_cave"), "Lava Claws");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.spikes_1"), "Spineback");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.spikes_2"), "Low");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.spikes_3"), "Tall");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.spikes_4"), "Amethyst");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.spikes_5"), "Asbestos Wool");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_44"), "Ashen");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_19"), "Netherite");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_20"), "Blackstone");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_1"), "Triple");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_3"), "Twisted Triple");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_17"), "Double");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_25"), "Twisted Double");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_11"), "Bent");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_27"), "Twisted Bent");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_5"), "Long");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_26"), "Twisted Long");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_4"), "Wide");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_6"), "Twisted Wide");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_8"), "Upper");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_28"), "Twisted Upper");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_12"), "Lower");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_29"), "Twisted Lower");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_9"), "Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_14"), "Twisted Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_31"), "Short");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_32"), "Twisted Short");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_33"), "Bull");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_34"), "Twisted Bull");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_35"), "Ram");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_36"), "Twisted Ram");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_15"), "Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_42"), "Twisted Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_10"), "Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_38"), "Twisted Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_2"), "Royal");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_18"), "Twisted Royal");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_16"), "Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_23"), "Twisted Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_24"), "Tree");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_43"), "Twisted Tree");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_7"), "Guard");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_37"), "Twisted Guard");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_39"), "Defender");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_40"), "Twisted Defender");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_13"), "Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_30"), "Twisted Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_49"), "Stump");
        this.add(Translation.Type.SKIN_PART.wrap("cave_dragon.horns_50"), "Trident");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_1"), "Snake");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_2"), "Gecko");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_3"), "Cute");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_4"), "Curious");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_5"), "Rounded");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_6"), "Crocodile");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_7"), "Drake");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_8"), "Surprised");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_9"), "Blank");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_10"), "Observer");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_11"), "Large Pupils");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_12"), "Dragon");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_13"), "Narrow");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_14"), "Simple");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_15"), "Raised");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_16"), "Layered");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_17"), "Empathic");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_18"), "Faded");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_19"), "Fresh");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_20"), "Square");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_21"), "Eccentric");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_22"), "Smoke");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_23"), "Pupil");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_24"), "Gritty");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_25"), "Dark");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_26"), "Glitter");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_27"), "Twinkle");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_28"), "Slanted");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_29"), "Diagonal");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_30"), "Chain");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_31"), "Hourglass");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_32"), "Lozenge");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_33"), "Triangle");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_34"), "Lizard");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_35"), "Frog");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_36"), "Crescent");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_37"), "Wave");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_38"), "Sclera");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_39"), "Pale");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_40"), "Dim");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_41"), "Spark");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_42"), "Light");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_43"), "Cross");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_44"), "Unusual");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_45"), "Quadro");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_46"), "Lens");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_47"), "Cog");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_48"), "Multicolor");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_49"), "Sharp");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_50"), "Keen");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_51"), "Gradient");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_52"), "Radiant");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_53"), "Blackhole");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_54"), "Striped");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_55"), "Beetle");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_56"), "Possessed");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_57"), "Spiral");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_58"), "Hypno");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_59"), "Gem");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_60"), "Spectre");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_61"), "Rainbow");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_62"), "Fear");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_63"), "Amphibian");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_64"), "Fish");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_65"), "Pretty");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_66"), "Heart");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_67"), "Star");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.eyes_68"), "Evil");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_1"), "Deepwater");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_2"), "Ocean");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_3"), "River");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_4"), "Fish");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_5"), "Ice");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_6"), "Large Scales");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_7"), "Ancient Scales");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.base_8"), "Wet Fur");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_1"), "Snowy");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_2"), "Bright");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_3"), "Frozen");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_4"), "Waves");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_5"), "Orca");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_6"), "Plates");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_7"), "Furry Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bottom_8"), "Flat Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_1"), "Crown");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_2"), "Beak");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_3"), "Nose Axe");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_4"), "Jaw Muscles");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_5"), "Tongue");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_6"), "Soft Paws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_7"), "Regular Paws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_8"), "Fur Paws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_9"), "Warden Tail");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_10"), "Warden Paws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.all_extra_11"), "Warden Body");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_1"), "Small Mane");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_2"), "Big Mane");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_3"), "Pointy Ears");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_4"), "Straight Ears");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_5"), "Frill Trike");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_6"), "Frill Small");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_7"), "Frill Big");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.bonus_eyes"), "Bonus Eyes");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.glob_tail"), "Glob Tail");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_body_1"), "Balanus");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_body_2"), "Battle Scars");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_body_3"), "Glow Dots");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_body_4"), "Back Glow Dots");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_jewelry_1"), "Saddle");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_jewelry_2"), "Saddle with Supplies");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_jewelry_3"), "Rings Gold");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_jewelry_4"), "Rings Copper");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_jewelry_5"), "Collar");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_moustache_1"), "Small Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_moustache_2"), "Big Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_tail_1"), "Dedicurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_tail_2"), "Ankylosaurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_tail_3"), "Crystal Lizard");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_1"), "Round Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_2"), "Round Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_3"), "Wind Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_4"), "Wind Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_5"), "Ocean Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_6"), "Ocean Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_7"), "Penguins Dream");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_8"), "Wings Edge");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_9"), "Wing Patterns Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_10"), "Wing Patterns Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_11"), "Star Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_12"), "Star Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_13"), "Dots Wings Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_extra_wings_14"), "Dots Wings Top");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_1"), "Fire Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_2"), "Stone Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_3"), "Sharp Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_4"), "Parrot Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_5"), "Amethyst Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_6"), "Smaller Dots");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_fins_7"), "Blazing Wings");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_1"), "Thorn Brows");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_2"), "Twisted Brows");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_3"), "Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_4"), "Twisted Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_5"), "Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_6"), "Twisted Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_7"), "Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_8"), "Twisted Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_9"), "Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_10"), "Twisted Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_11"), "Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_12"), "Twisted Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_13"), "Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_14"), "Twisted Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_15"), "Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_16"), "Twisted Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_17"), "Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.extra_horns_18"), "Twisted Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_1"), "Mechanisms");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_2"), "Swords");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_3"), "Arrows");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_4"), "Meander");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_5"), "Time");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.sea_magic_6"), "Echo");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_1"), "Small Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_2"), "Regular Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_3"), "Small Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_4"), "Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_5"), "Boars Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_6"), "Regular Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_7"), "Lower Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_8"), "Two Rows Of Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_9"), "Crooked Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_10"), "Crooked Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_11"), "Evil Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.teeth_12"), "Chinese Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_1"), "Three Red Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_2"), "Scabrous Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_3_sea"), "Sea Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_3_sea_1"), "Sea Newborn Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_3_sea_2"), "Sea Young Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_3_sea_3"), "Sea Adult Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_4"), "Huge Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_5"), "Square Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_6"), "Sharp Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.claw_7_sea"), "Golden Claws");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_1"), "Echinoidea");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_2"), "Membrane");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_3"), "Sea King");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_4"), "Kelp");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_5"), "Oarfish");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_6"), "Prism");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_7"), "Newt");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_8"), "Fish");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_9"), "Ice Lord");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_10"), "Glacier");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.spikes_11"), "Woolly Mane");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_45"), "River");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_46"), "Sea");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_21"), "Ocean");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_1"), "Triple");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_3"), "Twisted Triple");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_17"), "Double");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_25"), "Twisted Double");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_11"), "Bent");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_27"), "Twisted Bent");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_5"), "Long");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_26"), "Twisted Long");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_4"), "Wide");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_6"), "Twisted Wide");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_8"), "Upper");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_28"), "Twisted Upper");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_12"), "Lower");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_29"), "Twisted Lower");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_9"), "Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_14"), "Twisted Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_31"), "Short");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_32"), "Twisted Short");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_33"), "Bull");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_34"), "Twisted Bull");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_35"), "Ram");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_36"), "Twisted Ram");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_15"), "Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_42"), "Twisted Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_10"), "Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_38"), "Twisted Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_2"), "Royal");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_18"), "Twisted Royal");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_16"), "Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_23"), "Twisted Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_24"), "Tree");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_43"), "Twisted Tree");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_7"), "Guard");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_37"), "Twisted Guard");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_39"), "Defender");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_40"), "Twisted Defender");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_13"), "Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_30"), "Twisted Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_49"), "Stump");
        this.add(Translation.Type.SKIN_PART.wrap("sea_dragon.horns_50"), "Trident");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_0"), "Meadow");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_1"), "Dry Season");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_2"), "Autumn Forest");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_3"), "Wood");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_4"), "Large Scales");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_5"), "Ancient Scales");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.base_6"), "Thick Grass");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_1"), "Deep Stripes");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_2"), "Overgrown");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_3"), "Soft Grass");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_4"), "Plates");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_5"), "Swamp Sludge");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.bottom_6"), "Fur Belly");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_1"), "Snake");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_2"), "Gecko");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_3"), "Cute");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_4"), "Curious");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_5"), "Rounded");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_6"), "Crocodile");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_7"), "Drake");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_8"), "Surprised");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_9"), "Blank");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_10"), "Observer");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_11"), "Large Pupils");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_12"), "Dragon");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_13"), "Narrow");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_14"), "Simple");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_15"), "Raised");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_16"), "Layered");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_17"), "Empathic");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_18"), "Faded");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_19"), "Fresh");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_20"), "Square");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_21"), "Eccentric");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_22"), "Smoke");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_23"), "Pupil");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_24"), "Gritty");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_25"), "Dark");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_26"), "Glitter");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_27"), "Twinkle");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_28"), "Slanted");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_29"), "Diagonal");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_30"), "Chain");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_31"), "Hourglass");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_32"), "Lozenge");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_33"), "Triangle");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_34"), "Lizard");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_35"), "Frog");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_36"), "Crescent");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_37"), "Wave");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_38"), "Sclera");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_39"), "Pale");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_40"), "Dim");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_41"), "Spark");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_42"), "Light");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_43"), "Cross");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_44"), "Unusual");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_45"), "Quadro");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_46"), "Lens");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_47"), "Cog");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_48"), "Multicolor");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_49"), "Sharp");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_50"), "Keen");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_51"), "Gradient");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_52"), "Radiant");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_53"), "Blackhole");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_54"), "Striped");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_55"), "Beetle");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_56"), "Possessed");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_57"), "Spiral");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_58"), "Hypno");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_59"), "Gem");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_60"), "Spectre");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_61"), "Rainbow");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_62"), "Fear");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_63"), "Amphibian");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_64"), "Fish");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_65"), "Pretty");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_66"), "Heart");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_67"), "Star");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.eyes_68"), "Evil");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_1"), "Fire Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_2"), "Stone Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_3"), "Sharp Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_4"), "Parrot Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_5"), "Amethyst Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_6"), "Smaller Dots");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_fins_7"), "Blazing Wings");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_47"), "Sprout");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_48"), "Sapling");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_20"), "Wood");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_1"), "Triple");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_3"), "Twisted Triple");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_17"), "Double");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_25"), "Twisted Double");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_11"), "Bent");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_27"), "Twisted Bent");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_5"), "Long");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_26"), "Twisted Long");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_4"), "Wide");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_6"), "Twisted Wide");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_8"), "Upper");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_28"), "Twisted Upper");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_12"), "Lower");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_29"), "Twisted Lower");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_9"), "Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_14"), "Twisted Pinecone");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_31"), "Short");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_32"), "Twisted Short");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_33"), "Bull");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_34"), "Twisted Bull");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_35"), "Ram");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_36"), "Twisted Ram");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_15"), "Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_42"), "Twisted Twigs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_10"), "Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_38"), "Twisted Soldier");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_2"), "Royal");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_18"), "Twisted Royal");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_16"), "Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_23"), "Twisted Infernal");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_24"), "Tree");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_43"), "Twisted Tree");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_7"), "Guard");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_37"), "Twisted Guard");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_39"), "Defender");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_40"), "Twisted Defender");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_13"), "Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_30"), "Twisted Sorcerer");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_49"), "Stump");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.horns_50"), "Trident");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_1"), "Amaranth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_2"), "Wildfire");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_3"), "Old Leaves");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_4"), "Cactus");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_5"), "Thorny Bush");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_6"), "Lush Bushes");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_7"), "Thickets");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.spikes_8"), "Spineback");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_1"), "Crown");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_2"), "Beak");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_3"), "Nose Axe");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_4"), "Jaw Muscles");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_5"), "Tongue");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_6"), "Soft Paws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_7"), "Regular Paws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_8"), "Fur Paws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_9"), "Warden Tail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_10"), "Warden Paws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.all_extra_11"), "Warden Body");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_1"), "Pointy Ears");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_2"), "Straight Ears");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_3"), "Chest Leaves");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_4"), "Chest Honeycomb");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_5"), "Chest Roots");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_6"), "Frill Trike");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_7"), "Frill Big");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_8"), "Frill Small");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_9"), "Big Eyebrows");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_10"), "Mushroom Spike");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_body_1"), "Plates");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_body_2"), "Color Point");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_body_3"), "Moss Back");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_body_4"), "Tiger Back");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_body_5"), "Leaves Back");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_jewelry_1"), "Saddle");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_jewelry_2"), "Saddle with Supplies");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_jewelry_3"), "Rings Gold");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_jewelry_4"), "Rings Copper");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_jewelry_5"), "Collar");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_moustache_1"), "Small Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_moustache_2"), "Big Mustache");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_1"), "Scorpio Small");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_2"), "Scorpio Big");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_3"), "Tail Root");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_4"), "Dedicurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_5"), "Ankylosaurus Tail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_6"), "Palm Leaf");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_7"), "Patterned Leaf");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_8"), "Fern");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_9"), "Amaranth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_10"), "Bushy Tail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_11"), "Firetail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_12"), "Redtail");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_tail_13"), "Clumsy Situation");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_1"), "Wing Forest Top");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_2"), "Wing Forest Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_3"), "Wings Autumn Top");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_4"), "Stone Autumn Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_5"), "Wings Amaranth Top");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_6"), "Wings Amaranth Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_7"), "Wings Creek Top");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_8"), "Wings Creek Bottom");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_9"), "Green Feathers");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_extra_wings_10"), "Red Edge");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_1"), "Thorn Brows");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_2"), "Twisted Brows");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_3"), "Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_4"), "Twisted Front Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_5"), "Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_6"), "Twisted Thick Nose Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_7"), "Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_8"), "Twisted Long Nose");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_9"), "Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_10"), "Twisted Rhino Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_11"), "Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_12"), "Twisted Unicorn Horn");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_13"), "Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_14"), "Twisted Trike Horns");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_15"), "Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_16"), "Twisted Elbow Horns");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_17"), "Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.extra_horns_18"), "Twisted Horn Back Spikes");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_1"), "Mechanisms");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_2"), "Swords");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_3"), "Arrows");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_4"), "Meander");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_5"), "Time");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.forest_magic_6"), "Echo");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_1"), "Small Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_2"), "Regular Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_3"), "Small Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_4"), "Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_5"), "Boars Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_6"), "Regular Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_7"), "Lower Big Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_8"), "Two Rows Of Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_9"), "Crooked Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_10"), "Crooked Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_11"), "Evil Teeth");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.teeth_12"), "Chinese Fangs");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_1"), "Three Red Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_2"), "Scabrous Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_3_forest"), "Forest Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_3_forest_1"), "Forest Dark Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_4"), "Huge Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_5"), "Square Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_6"), "Sharp Claws");
        this.add(Translation.Type.SKIN_PART.wrap("forest_dragon.claw_7_forest"), "Diamond Claws");
    }
}

